#
# pendulum.sl
#

nassign("pendulum");
npp();
nlink("-O2");
ntime(10.0,0.01,0.01,0.05);
time=(0~(10/0.01))*0.01;

series theta;
nout(theta,"pendulum",0,1);
theta0=PI/180*10.0;
npara("pendulum","theta0",theta0);
ncal();

wopen(1,"A4",0,0);
origin(40,40);
color("black","black");

phi=PI/180*90;
m=1.0;
l=1.0;
gra=9.8;
true_theta=theta0*sin(sqrt(gra/l)*time+phi);
theta=theta/(PI/180.0);
true_theta=true_theta/(PI/180.0);

title(1,"time [s]","angle [deg]");
scale("N","F","N","F",0,10,-30,30);
axis(1,1,"XY","XY",6,0,3,2,15,0);
frame();
color("GREEN","YELLOW");
graph(theta,time,0,1,10,0,2);
color("RED","YELLOW");
graph(true_theta,time,0,0,0,0,0);



