/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/******************************************************************************

                   NEURAL CIRCUIT SIMULATOR                 
                      SIMULATION PROGRAM                    
                      REALTIME EXTENSTION

    $Id: realtime.cpp,v 1.4 2005/02/23 04:40:23 orrisroot Exp $

*****************************************************************************/
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef DSPTEC_EXTENSION

#include <windows.h>
#include <mmsystem.h>

#include <stdio.h>
#include <string.h>
#include <math.h>

#include "libsatellite.h"

#include "libncsc.h"
#include "libncss.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*INTEG_METHOD)(INTEG_FUNC,double,double,int,int,double**,double*,int*);

/* referabce */
extern void cf( double t, double **ncs_y, double **ncs_dy );
extern INTEG_METHOD Integrl;

/* global variable for realtime simulation */
int          g_realtime_mode;
int          g_realtime_disp;
int          g_realtime_outport;

extern int   gScxfpType; /* ncsslib.c */
UINT         g_uTimerID;

int        g_calc_cnt;
int        g_strd_cnt;
char      *g_moni_vflag;
int       *g_iflag;
int       *g_index;
double     g_report_end;
int        g_calc_end;
int        g_str_period;
int        g_calc_end_flag;

// MyTimerProc is an application-defined callback function that 
// processes WM_TIMER messages. 
 
VOID CALLBACK MyTimerProc( 
                          HWND hwnd,    // handle of window for timer messages 
                          UINT message, // WM_TIMER message 
                          UINT idTimer, // timer identifier 
                          DWORD dwTime) // current system time 
{
//xgpȂbZ[W폜̂
//  char tmp[_MAX_PATH];
//  sprintf(tmp, "%d %d %d %ld",hwnd,message,idTimer,dwTime);
  printf("... timer event.\n");
}


// timeSetEvent֐̃R[obN֐
void CALLBACK MyTimerEvent (UINT uID, UINT uMsg, DWORD dwUser, 
                            DWORD dw1, DWORD dw2)
{ // TimerProc //
  // vZ
  double time;

  //xgpȂbZ[W폜̂
  char tmp[_MAX_PATH];
  sprintf(tmp, "%d %d %ld %ld %ld",uID,uMsg,dwUser,dw1,dw2);
  
  realtime_calculate_mode2_wait();
  
  if(((ncsg_intg_method) == ('E'))&&(g_calc_cnt == 0)){
    g_calc_cnt = 1;
    g_calc_end++;
  }
  
  /* for interporation (Buffer Input) */
  ncsg_cdpoint = (int)g_calc_cnt;
  
  time = ((double) g_calc_cnt) * ncsg_calstep;
  /* Consoleւ̃bZ[W*/
  realtime_calculate_mode2_display(g_calc_cnt,time);
  
  /*
   * setting up of external input values
   * ncssfunc.cpp
   */
  ncsf_xinset( ncsg_nxinc, ncsg_xindata, ncsg_xfpdata, ncsg_xinfaddr);
  
  /* storing of results into memory area */
  if( g_strd_cnt % g_str_period == 0 ){
    
    ncsf_dataout( g_moni_vflag, (*g_index)++, g_strd_cnt );/*ncssfunc.cpp*/
    
    if( *g_moni_vflag == NCS_FLAG_OFF ){
      ncsf_repoprogress( g_calc_cnt, g_report_end ); /*ncssfunc.cpp*/
    }
    
  }    /* if */
  g_strd_cnt = g_calc_cnt + 1;
  /*
   * Integration taking one step NETWORK() is produced by
   * preprocessor in cf(). 
   */
  
  (*Integrl)(cf, time, ncsg_calstep, ncsg_cell, ncsg_neqn, ncs_y,
             &ncsg_relerr, g_iflag);
  
  realtime_calculate_mode2_next();
  
  //I`FbN
  g_calc_cnt++;
  if(g_calc_end_flag || g_calc_cnt > g_calc_end) {
    timeKillEvent(g_uTimerID);
    g_calc_end_flag = 1;
  }
  
} // TimerProc //    



void realtime_calculate_mode2(char *moni_vflag, int *iflag, int *index,
							  double report_end, int calc_end, int str_period)
{
  /* realtime calculation */
  printf("Realtime simulation start ...\n");
  printf("Wait for %.1f[s]\n",ncsg_calstep*calc_end);
  /* generate realtime clock */
  g_uTimerID = timeSetEvent((int)(ncsg_calstep*1000), 0, MyTimerEvent, 
                            0, TIME_PERIODIC);
  if(g_uTimerID == NULL) {
    printf("\ntimeSetEvent error.\n");
  }

  /* initialize */
  g_calc_cnt= 0;
  g_strd_cnt= 0;
  g_moni_vflag = moni_vflag;
  g_iflag = iflag;
  g_index = index;
  g_report_end = report_end;
  g_calc_end = calc_end;
  g_str_period = str_period;
  g_calc_end_flag = 0;
        
  /* infinite loop ? */
  for(;;) {
    if(g_calc_end_flag) {
      printf("Realtime simulation finished.\n");
      //_getch();
      break;
    }
  }
}

#ifdef __cplusplus
}
#endif

#endif
