/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ncssdsp.h,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
#ifndef  _LIBNCSS_DSPTEC_H_
#define  _LIBNCSS_DSPTEC_H_

#ifdef EXTERN
# undef EXTERN
#endif
#ifdef MOD_NCS_LIBNCSS_EXTENTION
# define EXTERN
#else
# define EXTERN extern
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef DSPTEC_EXTENSION

#define NCS_PRM_MAX 100

/* global variables for A/D, D/A converter */
/* --  A/D -- */
EXTERN int g_realtime_mode;
EXTERN int g_realtime_disp;
EXTERN int g_realtime_outport;
EXTERN int g_calc_end_flag;
EXTERN int g_calc_cnt;
/* --  D/A -- */
EXTERN int gScxfpType;

/* parameter */
#ifdef MOD_NCS_LIBNCSS_EXTENTION
struct scf_prm scData[NCS_PRM_MAX];
#else
EXTERN struct scf_prm scData[];
#endif

/* controller of A/D - D/A converter */
double ncsl_ad3163( double, double, double, double, double/*int ch*/ );
void   ncsl_da3305( int ch, double data );
/* realtime clock */
int    ncsf_rtclk( char scfn[] );
/* hardware control */
int    ncsf_hardopen(char scfn[]);
int    ncsf_hardclose(char scfn[]);
/* pulse generation */
double ncsl_sin(double amp, double freq, double phase,
                double dummy1, double dummy2 );
double ncsl_sweep(double start, double amp, double ifreq, double efreq, 
                   double dummy1 );

#endif
#ifdef __cplusplus
}
#endif

#endif /* _LIBNCSS_DSPTEC_H_ */
