/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*****************************************************************************

            NCS FUNCTIONS FOR SIMULATION PROGRAM ( for SATELITE )

    $Id: ncsssate.cpp,v 1.4 2005/02/23 04:40:23 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>

/* TODO check! */
/* this source code is a part of child process.. */
/* this process should be independence from the SATELLITE shell. */
/* this process must be initialize system common area. */
/*  because, get_tmpdir() and ChangeDataSize() use syscom */
#include "libsatellite.h"

#define MOD_NCS_LIBNCSS_EXPORTS
#include "libncsc.h"
#include "libncss.h"
#include "ncssdata.h"
#include "ncssdsp.h"

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
FUNCTION  NCSF_SCFREAD
******************************************************************************
READ SIMULATION CONDITION

return( 0 ) : success;
return( 1 ) : error;

MSC Ver.5.1                                     Coded by A.Anzai   06/12/1989
UNIX                                          Modifid by S.Hitomi  06/28/1991
*****************************************************************************/

DLLEXPORT int ncsf_scfread(){
  const char *tmpdir;
  char tmp[NCS_FNAME_WD], scfn[NCS_FNAME_WD];

  tmpdir = get_tmpdir();

  SetWorkDirSCF( tmpdir );
#ifdef HAVE_SNPRINTF
  snprintf( scfn, NCS_FNAME_WD, "%s/%s", tmpdir, ModelNameSCFN( tmp ));
#else
  sprintf( scfn, "%s/%s", tmpdir, ModelNameSCFN( tmp ));
#endif

  if( ncsf_rdmat(scfn) == NCS_ERROR ){
    return( NCS_ERROR );
  }

  if( ncsf_rdxinfo(scfn) == NCS_ERROR ){
    return( NCS_ERROR );
  }

  if( ncsf_rdprm(scfn) == NCS_ERROR ){
    return( NCS_ERROR );
  }

  if( ncsf_rdout(scfn) == NCS_ERROR ){
    return( NCS_ERROR );
  }

  if( ncsf_rddly(scfn) == NCS_ERROR ){
    return( NCS_ERROR );
  }

#ifdef DSPTEC_EXTENSION
  /* realtime clock condition */
  if( ncsf_rtclk(scfn) == NCS_ERROR ){
    return( NCS_ERROR );
  }

  /* open hard ware */
  if(g_realtime_mode >= 2) {
	  if( ncsf_hardopen(scfn) == NCS_ERROR ){
		return( NCS_ERROR );
	  }
  }
#endif /* DSPTEC_EXTENSION */

  return (NCS_SUCCESS);
}

DLLEXPORT void ncsf_memalloc( int nbuff, int dpoint ){
  /* Memory allocation for Integlation */
  ncs_y  = (double**)alloc2d(ncsg_cell, ncsg_neqn, sizeof(double));
  ncs_yp = (double**)alloc2d(ncsg_cell, ncsg_neqn, sizeof(double));
  
  /* Memory allocation for Data buffer */
  ncs_buffer = (double**)alloc2d(nbuff, (dpoint+1), sizeof(double));
}


DLLEXPORT void ncsf_strd( int nstrd, int mem_index, double **dptr){
  /* nstrd     - number of buffers to out     */
  /* mem_index - number of *store* data point */
  /* dptr      - address of out data          */
  register int buff_num;
  double       f_data=0.0;
  double       data;

  for( buff_num = 0; buff_num < nstrd; buff_num++ ){
    data = *dptr[buff_num];

    if ( data > 1.e+37 ){
      f_data = 1.e+37;
    }
    if ( data < -1.e+37 ){
      f_data = -1.e+37;
    }

    if ( -1.e+37 <= data && data <= 1.e+37 ) {
      if (fabs(data) < 1.e-36){
        f_data = 0.;
      } else {
        f_data = data;
      }
    }
    
    ncs_buffer[buff_num][mem_index] = f_data;
  }
}

/*
 *   function for Data Store to ISPP buffer 
 *                        Coded by A.Anzai (MSC Ver.5.1)    [06/21/1989]
 *                        Modifid by S.Hitomi (on UNIX)     [08/29/1990]
 *                        Modifid        (on SATELLITE)     [15,Jun.'94]
 */
DLLEXPORT void ncsf_StoreData( int dpoint, int nstrd){
  /* dpoint  - number of *store* data point (not calculated data) */
  const char *tmpdir;
  int     i, j, k;
  int     buff_num, buff_dim;
  char    buff_name[NCS_FNAME_WD];
  double *tmpbuffer;
  int     tmpdim, tmpindex[MAX_INDEX];
  char    model_name[NCS_FNAME_WD];
  int     dsize_org;
  Header head;

  if( dpoint == 0 ){
    return;
  }

  tmpdir = get_tmpdir();

  SetWorkDirSCF( tmpdir );
  if( ModelNameSCFN( model_name ) == NULL ){
    exit (85);
  }

  /* TODO check ! */
  tmpbuffer = (double*)malloc(sizeof(double)*dpoint);
  if( tmpbuffer == NULL ){
    exit (201); 
  }

  dsize_org = sl2_get_data_size();
  ChangeDataSize(8);

  for( i = 0; i < nstrd; i++ ){
    buff_num = ncsg_out_buffnum[i];
    buff_dim = ncsg_out_buffdim[i];
    sprintf(buff_name, "%s/nout_%s.fobj", tmpdir,  ncsg_out_bufname[i]);

    k = 0;
    for( j = 0; j < dpoint; j++ ){
      tmpbuffer[j] = ncs_buffer[i][j];
    }

    tmpdim = 1;
    /* use file object */
    if(LoadHeader(buff_name, &head) == -1)
      exit(210);
    if( head.dim == -1 ){
      fprintf( stderr, "...Warnning: Fail to Write Buffer%d, because it is not existance.\n", buff_num );
    }else{
      if( head.dim == 1 ){
        tmpindex[0] = dpoint;
        /* use file object */
        if(_WriteFile4(buff_name, tmpdim, tmpindex, (char*)tmpbuffer) == -1){
          exit(210);
        }
      }else{
        tmpindex[0] = buff_dim;
        /* use file object */
        if(StoreTimeData(buff_name, tmpdim, tmpindex, (char*)tmpbuffer, dpoint)
           == -1){
          exit(210);
        }
      }
    }
  }
  free(tmpbuffer);

  /* TODO: restore data size. */
  ChangeDataSize(dsize_org); 
}

#ifdef DSPTEC_EXTENSION
DLLEXPORT int ncsf_scfclose(){
  const char *tmpdir;
  char tmp[NCS_FNAME_WD], scfn[NCS_FNAME_WD];

  tmpdir = get_tmpdir();
  SetWorkDirSCF( tmpdir );
#ifdef HAVE_SNPRINTF
  snprintf( scfn, NCS_FNAME_WD, "%s/%s", tmpdir, ModelNameSCFN( tmp ));
#else
  sprintf( scfn, "%s/%s", tmpdir, ModelNameSCFN( tmp ));
#endif

  /* close hardware */
  if(g_realtime_mode >= 2) {
	  if( ncsf_hardclose(scfn) == NCS_ERROR ){
		return( NCS_ERROR );
	  }
  }

  return (NCS_SUCCESS);
}
#endif

#ifdef __cplusplus
}
#endif
