/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/******************************************************************************

            NCS UTILITY  PROGRAM

    $Id: ncssutil.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $

******************************************************************************/

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* TODO check! */
/* this source code is a part of child process.. */
/* this process should be independence from the SATELLITE shell. */
#include "libsatellite.h"

#define MOD_NCS_LIBNCSS_EXPORTS
#include "libncsc.h"
#include "libncss.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT void init_queue(double *q, long qsize, double init){
  register int   i;
  for( i = 0; i < qsize; i++ ){
    q[i] = init;
  }
}


DLLEXPORT double delay( double *q, long *ptr, long qsize, double in ){
  double  out;
  if( qsize == 0 ){
    return( in );
  }
  out = q[*ptr];
  q[(*ptr)++] = in;
  if( *ptr == qsize ){
    *ptr = 0;
  }
  return( out );
}

DLLEXPORT char **alloc2d( int m, int n, int size ){
  int    i;
  char **f;
  f = (char **) malloc(m * sizeof(char *));
  if( f == NULL ){
    printf( ">>>Memory Allocation Error<<<" );
    exit(213);
    return(NULL);
  }

  for( i = 0; i < m; i++ ){
    if( n != 0 ){
      f[i] = (char *) calloc(n, size);
      if( f[i] == NULL ){
        printf( ">>>Memory Allocation Error<<<" );
        exit(213);
      }
    } else {
      f[i] = NULL;
    }
  }
  return( f );
}

DLLEXPORT void free2d( char **f, int m ){
  int  i;
  free( f );
  for( i = 0; i < m; i++ ){
    free( f[i] );
  }
}

#ifdef __cplusplus
}
#endif
