/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/*****************************************************************************

                            STRING FUNCTIONS

    $Id: strfunc.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $

*****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MOD_NCS_LIBNCSS_EXPORTS
#include "libncsc.h"
#include "libncss.h"

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************************************
FUNCTION  STRING_ANA
******************************************************************************
ANALYZING OF A STRING

buffer : a string to be analyzed;
anatbl : string table for analysis;
mode   : mode( MODE0: report error , MODE1: not report error );

id_num : string id on the table ( 0 < id_num ) ;

return( id_num ): success;
return( 0 ): error;

MSC Ver.5.1                                      06/09/1989 CODED BY A. ANZAI
*****************************************************************************/

DLLEXPORT int string_ana( char buffer[], char *anatbl[], int mode ){
  int counter, id_num = 0;

  /* string comparison */
  for( counter = 0; anatbl[counter] != NCS_EOS; counter++ ){
    if( strcmp(buffer, anatbl[counter]) != NCS_EQUIVALENT ){
      continue;
    } else {
      id_num = counter + 1;
      break;
    }
  }

  /* error processing */
  if( id_num == 0 ){
    if( mode == NCS_MODE0 ){
      printf( "\nIllegal String '%s'\n", buffer );
      return( NCS_ERROR0 );
    } else {
      return (counter + 1);  /* for 'default' */
    }
  } else {
    return( id_num );
  }
}

#ifdef __cplusplus
}
#endif
