/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: list.c,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/**************************************************************************
  
  	Functions to control list structure

**************************************************************************/
 
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libncsc.h"
#include "list.h"

void menu();

#ifndef HAVE_STRDUP
static char *strdup(const char *str){
  char *ret;
  ret = (char *)malloc(strlen(str)+1);
  if(ret == NULL) return NULL;
  strcpy(ret, str);
  return ret;
}
#endif

void 
menu( void )
{
	int	i;
	char    w[256];
	pos	p;
	List	l;
	
	init_list(&l);
	do {	
	  print_list(&l);
	  printf("\n");
	  printf("1...insert   2...delete   3...see   4...locate\n");
	  printf("5...next     6...previous 7...end   8...first\n");
	  printf("others... quit ? ");
	  scanf("%d" , &i);
	  printf("\n");
	  switch( i ){
	    case 1 :printf("word? ");
	      scanf("%s" , w);
	      printf("position? ");
	      scanf("%d" ,&p);
	      insert(w , p , &l);
	      break;
	    case 2 :printf("position? ");
	      scanf("%d" ,&p);
	      SL_delete(p , &l);
	      break;
	    case 3 :printf("position? ");
	      scanf("%d" ,&p);
	      printf("element of position %d = %s\n" , p , see(p , &l) );
	      break;
	    case 4 :printf("word? ");
	      scanf("%s" , w);
	      printf("%s is located %d\n" , w , locate(w , &l) );
	      break;
	    case 5 :printf("position? ");
	      scanf("%d" ,&p);
	      printf("next position is %d\n" , next(p , &l) );
	      break;
	    case 6 :printf("position? ");
	      scanf("%d" , &p);
	      printf("previous position is %d\n",previous(p,&l));
	      break;
	  case 7 :printf("end position is %d\n" , endlist(&l) );
	      break;
	  case 8 :printf("first is %d\n" , first(&l) );
	      break;
		}
	}while( ( i >= 1 ) && ( i <= 8 ) );
}

void 
init_list( List *ptr )
{
	ptr->str = NULL;
	ptr->next = NULL;
}

void 
print_list( List *header )
{
	List	*i;
	int	c;
	
	c = 0;
	printf( "\n" );
	i = header->next;
	while( i != NULL ){
	  c++;
	  if( c == 6 )
	    {	
	      printf("\n");
	      c = 0;
	    }
	  printf("[%s] -> " , i->str );
	  i = i -> next;
	}
	printf( "end of list\n" );
}

int 
insert( char *word, pos p, List *ptr )
{
	List	*i;
	List	*newlist;
	List	*plist;		/* previous list */
	int	c;		/* count */
	char    *wa;            /* word address */

	if( check( p, ptr, 1 ) == NCS_FALSE ) {
	  return( NCS_FALSE );
	}
	if( ( wa = strdup(word) ) == NULL ) {
	  fprintf( stderr, "plist: Memory allocation error.\n" );
	  return( NCS_FALSE );
	}

	if( ( newlist = (List *)malloc(sizeof(List)) ) == NULL ) {
	  fprintf( stderr, "plist: Memory allocation error.\n");
	  return( NCS_FALSE );
	}
	
	c = 0;
	plist = ptr;
	for( i = ptr->next; i != NULL; i = i->next ) {
	  c++;
	  if( c == p ){
	    break;
	  }
	  plist = i;
	}
	newlist->next = plist->next;
	plist->next = newlist;
	newlist->str = wa;
	
	return( NCS_TRUE );
}

int
SL_delete( pos p, List *ptr )
{
	int	c;
	List	*i;
	List	*plist;
	
	if( check( p, ptr, 0 ) == NCS_FALSE ){
	  return( NCS_FALSE );
	}

	c = 0;
	plist = ptr;
	for( i = ptr->next; i != NULL; i = i->next ){
	  c++;
	  if( c == p ){
	    break;
	  }
	  plist = i;
	}
	plist->next = i->next;
	free( i );

	return( NCS_TRUE );
}

char *
see( pos p, List *ptr )
{
	int	c;
	List	*i;
	
	if( check( p, ptr, 0 ) == NCS_FALSE ){
	  return( NULL );
	}
	
	c = 0;
	for( i = ptr->next; i != NULL; i = i->next ){
	  c++;
	  if( c == p ){
	    break;
	  }
	}
	return(	i->str );
}

int
locate( char *word, List *ptr )
{
	List	*i;
	pos	p;
	
	p = 0;
	for( i = ptr->next; i != NULL; i = i->next ){
	  p++;
	  if( strcmp(i->str, word) == 0 ){
	    return( p );
	  }
	}
	return( 0 );
}

pos
endlist( List *ptr )
{
	List	*i;
	pos	p;
	
	p = 0;
	for( i = ptr->next; i != NULL; i = i->next ){
	  p++;
	}
	return( p+1 );
}

pos
next( pos p, List *ptr )
{
	if( check(p, ptr, -1) == NCS_FALSE ){
	  return( NCS_ERROR );
	}
	return( p+1 );
}

pos
previous( pos p, List *ptr )
{
	if( check(p, ptr, 0) == NCS_FALSE ){
	  return( NCS_ERROR );
	}
	return( p-1 );
}

pos
first( List *ptr )
{
	if( ptr->next == NULL ){
	  return( NCS_ERROR );
	}
	return( NCS_TRUE );
}

void
listcat( List *p1, List *p2 )
{
	List 	*i;

	i = p1;
	while( i->next != NULL ){
	  i = i->next;
	}
	i->next = p2->next;
	init_list( p2 );
}

void
clearlist( List *ptr )
{
	List 	*i;
	List 	*plist;

	while( ptr->next != NULL ){
	  plist = ptr;
	  for( i = ptr->next; i->next != NULL; i = i->next ){
	    plist = i;
	  }
	  free( i->str );
	  free( i );
	  plist->next = NULL;
	}
	init_list( ptr );
}

int 
check( pos p, List *ptr, int j )
{
	int	nol;
	List	*i;
	
	if( p < 1 ){
	  fprintf( stderr, "plist: Disable position\n" );
	  return( NCS_FALSE );
	}
	
	nol = 0;
	for( i = ptr->next ; i != NULL ; i = i->next ){
	  nol++;
	}
	if( p > nol+j ){	
	  fprintf( stderr, "plist: Disable position\n" );
	  return( NCS_FALSE );
	}
	
	return( NCS_TRUE );
}

/*
 * Delete a same entry in the list
 *    Return: NCS_TRUE  : delete a same entry.
 *            NCS_FALSE : do not.
 *				(1,Jun.,95' by tomi )
 */

int
unique( List *ptr )
{
	int 	i, j;
	int 	n;		/* number of entry in the list */
	char 	*buffer;	/* work area */
	int 	flag = 0;

	n = endlist( ptr );
	for( i = 1; i < n; i++ ){
	  buffer = see( i, ptr );
	  for( j = i+1; j < n; j++ ){
	    if( strcmp(buffer,see(j,ptr)) == 0 ){
	      SL_delete( j, ptr );
	      flag++;
	      n--;
	    }
	  }
	}
	if( flag == 0 ){
	  return( NCS_FALSE );
	}else{
	  return( NCS_TRUE );
	}
}


int 
writelist( char *word, pos p, List *ptr )
{
	List	*i;
	List	*plist;	
	int	c;		/* count */
	char    *wa;            /* word address */

	if( check( p, ptr, 1 ) == NCS_FALSE ) {
	  return( NCS_FALSE );
	}
	if( ( wa = strdup(word) ) == NULL ) {
	  fprintf( stderr, "plist: Memory allocation error.\n" );
	  return( NCS_FALSE );
	}

	c = 0;
	plist = ptr;
	for( i = ptr->next; i != NULL; i = i->next ) {
	  c++;
	  plist = i;
	  if( c == p ){
	    break;
	  }
	}
	free( plist->str );
	plist->str = wa;
	
	return( NCS_TRUE );
}

pos 
searchlist( char *word, List *ptr )
{
  	int     c = 0, p = 0;
	List	*i;

	for( i = ptr->next; i != NULL; i = i->next ){
	  c++;
	  if( strcmp( word, i->str ) == 0 ){
	    p = c;
	    break;
	  }
	}
	return( p );
}
