/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: list.h,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/**********************************************************************

            Header File for NCS PreProcessor Program (list.h)
 
 **********************************************************************/
#ifndef _NCSPP_LIST_H_
#define _NCSPP_LIST_H_

#ifdef __cplusplus
extern "C" {
#endif

/* list.c */
typedef	int		pos;

/* structure of linearly list */
typedef struct _List{
  char *str;
  struct _List *next;
} List;

void  init_list( List * );
int   writelist( char *, pos, List * );
void  print_list( List * );
int   insert( char * , pos , List * );
int   SL_delete( pos, List * );
char *see( pos, List * );
int   locate( char * , List * );
pos   endlist( List * );
pos   next( pos, List * );
pos   previous( pos , List * );
pos   first( List * );
int   check( pos, List *, int );
void  listcat( List *, List * );
void  clearlist( List * );
int   unique( List * );
pos   searchlist( char *, List * );

#ifdef __cplusplus
}
#endif

#endif /*  _NCSPP_LIST_H_ */
