/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: npp-lex.l,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */
/**************************************************************************
                                                                        
   Lexical Analyzer [npp.l] for lex of NCS PreProcessor Program

**************************************************************************/
%{
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_IO_H
# include <io.h>
#endif

#include "libncsc.h"
#include "npp-yacc.h"
#include "list.h"

extern int  npp_lineno;
extern int  npp_charno;
extern int  npp_tabno;
extern char npp_buffer[];
extern List npp_clang;

extern int yyerror( char * );

static char var_top[10] = "variable_";
static char str_buffer[100];
static int  bn=0;

#ifdef HAVE_IO_H
# include <io.h>
#endif

#ifdef WIN32
# define isatty(x) _isatty(x)
#endif

%}
%option noyywrap

newline        (\r\n)|[\r\n]
digit          [0-9]
exp            ([eE][+-]?{digit}+)
ident          [a-zA-Z][_a-zA-Z0-9]*
c_keyword      auto|break|case|char|const|continue|default|do|double|enum|extern|float|goto|int|long|register|return|short|signed|sizeof|static|struct|switch|typedef|union|unsigned|void|while
%x comment
%x csource
%%
"type"                 { npp_charno+=(int)yyleng; return(NCS_TYPE); }
"CELL"                 { npp_charno+=(int)yyleng; return(CELL); }
"SYNAPSE"              { npp_charno+=(int)yyleng; return(SYNAPSE); }
"GAP"                  { npp_charno+=(int)yyleng; return(GAP); }
"EXINPUT"              { npp_charno+=(int)yyleng; return(EXINPUTM); }
"NETWORK"              { npp_charno+=(int)yyleng; return(NETWORK); }
"end"                  { npp_charno+=(int)yyleng; return(END); }
"if"                   { npp_charno+=(int)yyleng; return(IF); }
"else"                 { npp_charno+=(int)yyleng; return(ELSE); }
"for"                  { npp_charno+=(int)yyleng; return(FOR); }
"cell"                 { npp_charno+=(int)yyleng; return(CELLN); }
"synapse"              { npp_charno+=(int)yyleng; return(SYNN); }
"gap"                  { npp_charno+=(int)yyleng; return(GAPN); }
"connection"           { npp_charno+=(int)yyleng; return(CONEX); }
":"                    { npp_charno+=(int)yyleng; return(COLON); }
";"                    { npp_charno+=(int)yyleng; return(SCOLON); }
"/"                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(DIV);}
"*"                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(MULT);}
"+"                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(PLUS);}
"-"                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(MINUS);}
"("                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(LP);}
")"                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(RP);}
"{"                    { npp_charno+=(int)yyleng; return(BRCL); }
"}"                    { npp_charno+=(int)yyleng; return(BRCR); }
"["                    { npp_charno+=(int)yyleng; return(BRKL); }
"]"                    { npp_charno+=(int)yyleng; return(BRKR); }
","                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(COMMA);}
"="                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(EQUAL);}
"+="                   { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(PLEQ);}
"-="                   { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(MIEQ);}
"*="                   { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(MLEQ);}
"/="                   { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(DVEQ);}
"%"                    { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(MOD);}
"=="                   { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(EQ); }
"!="                   { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(NE); }
"<"                    { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(LESS);}
">"                    { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(GR);}
"<="                   { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(LEQ); }
">="                   { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(GEQ); }
"||"                   { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(OR);}
"&&"                   { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(AND);}
"++"                   { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(INC);}
"--"                   { npp_charno+=(int)yyleng; 
                         yylval.ptr=(char *)strdup(yytext);
                         return(DEC);}
"name"                 { npp_charno+=(int)yyleng; return(NAME); }
"module"               { npp_charno+=(int)yyleng; return(MODULE); }
"exinput"              { npp_charno+=(int)yyleng; return(EXINPUT); }
"input"                { npp_charno+=(int)yyleng; return(Input); }
"output"               { npp_charno+=(int)yyleng; return(OUTPUT); }
"observable"           { npp_charno+=(int)yyleng; return(OBSERVABLE); }
"constant"             { npp_charno+=(int)yyleng; return(CONSTANT); }
"parameter"            { npp_charno+=(int)yyleng; return(PARAMETER); }
"initial"              { npp_charno+=(int)yyleng; return(INIT); }
"function"             { npp_charno+=(int)yyleng; return(FUNCTION); }
{c_keyword}            { npp_charno+=(int)yyleng+(int)strlen(var_top);
			 sprintf(str_buffer,"Can not describe keyword \"%s\" of C language in model description\n" , yytext);
			 yyerror( str_buffer );
                         strcpy( str_buffer,var_top );
                         yylval.ptr=(char *)strdup(strcat(str_buffer,yytext));
                         return(IDENT);}
{digit}+               { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(NUMBER); }
{digit}+"."{digit}*{exp}? |
{digit}*"."{digit}+{exp}? |
{digit}+{exp}              { npp_charno+=(int)yyleng;
                             yylval.ptr=(char *)strdup(yytext);
                             return(NUMBER); }
{ident}                { npp_charno+=(int)yyleng;
                         yylval.ptr=(char *)strdup(yytext);
                         return(IDENT); }
{newline}              { npp_lineno++; npp_charno = 0; npp_tabno = 0; }
[ ]                    { npp_charno += yyleng;}
[\t]		       { npp_tabno++; }
"/"("*"+)              { BEGIN(comment); }
<comment>[^*/\r]       { npp_charno += yyleng; }
<comment>[^*/\r\n]     { npp_charno += yyleng; }
<comment>[^*/\n]       { npp_charno += yyleng; }
<comment>{newline}     { npp_lineno++; npp_charno = 0; npp_tabno = 0; }
<comment>"/"+          { npp_charno += yyleng; }
<comment>"*"+          { npp_charno += yyleng; }
<comment>("*"+)"/"     { BEGIN(INITIAL); }
"%{"                   { BEGIN(csource); }
<csource>[^}%\n]       { npp_buffer[bn++] = yytext[0]; }
<csource>"}"+          { npp_buffer[bn++] = yytext[0]; }
<csource>"%"+          { npp_buffer[bn++] = yytext[0]; }
<csource>\n            { npp_lineno++;
                         npp_buffer[bn++] = '\n';
                         npp_buffer[bn++] = NCS_EOS;
                         insert( npp_buffer, endlist(&npp_clang), &npp_clang );
                         bn = 0; }
<csource>"}%"          { npp_buffer[bn++] = '\n';
                         npp_buffer[bn++] = NCS_EOS;
                         insert( npp_buffer, endlist(&npp_clang), &npp_clang );
                         BEGIN(INITIAL); }
.                      { sprintf( str_buffer, 
				  "unknown token \"%s\"\n" , yytext);
                         yyerror( str_buffer );}
%%

int
call_yy_new_file () {
#ifdef FLEX_SCANNER
 YY_NEW_FILE;
#endif
 return( 0 );
}
