/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: cinit.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*********************************************************
**  cinit.cpp                                           **
**  command  : cinit                                    **
**  function : set the initial value of each parameter  **
**  argument : 1.number of parameter                    **
**             2.initial value                          **
**             3.parameter flag (variable or fix)       **
**             4.parameter name                         **
**             5.span                                   **
*********************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include  <stdio.h>
#include  <stdlib.h>
#include  <ctype.h>
#include  <string.h>

#include  "SL_macro.h"
#include  "SL_cmd.h"

#include "libnpec.h"
#include "npepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

/******************** MAIN ********************/
DLLEXPORT int mod_npe_cinit()
{
  int     err;
  int     ninit, inum, flag;
  char   *tflag;
  char   *name;
  double  val,span;

  ninit  = (int)GetScalar(0);
  inum   = (int)GetScalar(1);
  val    = GetScalar(2);
  tflag  = GetString(3);
  name   = GetString(4);
  span   = GetScalar(5);

  flag = npe_param_flag_type(tflag);

  if(ninit < 0 || inum < 0)
    return 112; /* illegal number of initial parameters */

  /*  set contents */
  err = npe_init_set(npe_common, (unsigned int)ninit, (unsigned int)inum, 
                     val, flag, name, span);
  switch(err){
  case -1: return 1;   /* can't open common area */
  case -2: return 2;   /* out of memory */
  case  1: return 112; /* illegal number of initial parameters */
  case  2: return 115; /* illegal initial perameter flag */
  case  3: return 116; /* illegal initial parameter name */
  }

  return 0;
}

#ifdef __cplusplus
}
#endif
