/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: clsearch.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/**************************************************
**  clsearch.cpp                                 **
**  command  : clsearch                          **
**  function : set linear search method          **
**  argument : 1.linear search method            **
**             2.search parameter                **
**************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include  <stdio.h>
#include  <stdlib.h>
#include  <string.h>
#include  <ctype.h>

#include  "SL_macro.h"
#include  "SL_cmd.h"

#include "libnpec.h"
#include "npepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_npe_clsearch(){
  int     err;
  int     type;
  char   *name;
  double  value;

  name  = GetString(0);
  value = GetScalar(1);

  /* check arguments */
  type  = npe_lsearch_type(name);
  if(type == NPE_LSEARCH_NONE)
    return 107; /* illegal linear search method type*/

  /* set contents */
  err = npe_lsearch_set(npe_common, type, value);
  switch(err){
  case -1: return 1;   /* can't open common area */
  case -2: return 2;   /* out of memory */
  case  1: return 107; /* illegal linear search method type */
  case  2: return 108; /* illegal linear search initial bracket value */
  }

  return 0;
}

#ifdef __cplusplus
}
#endif
