/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: diff.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */

#define  MOD_NPE_LIBNPEE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>

#include "libsatellite.h"
#include "libnpec.h"
#include "libnpee.h"
#include "npeepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

/*********************************************************************
**  Subroutine of Differentiation				    **
**********************************************************************/
double npe_differentiate(npe_param_t  *vParam[], double *nablaFx, 
                         double *direction ){
  int    i;
  double x, h, f, Fdash=0.0;

  for( i=0; i<(int)NumVarParam; i++ ) {
    x = vParam[i]->value;
    h = vParam[i]->span;

    vParam[i]->value = x + h;
    f  = npe_errorFunc( AllParam );  /* f(x+h) */

    vParam[i]->value = x - h;
    f -= npe_errorFunc( AllParam );  /* f(x+h)-f(x-h) */

    nablaFx[i] = f/(2.0*h);      /* f'(x)=(f(x+h)-f(x-h))/2h */

    vParam[i]->value = x;

    if( direction != NULL )
      Fdash += direction[i] * nablaFx[i];
  }
  return Fdash;
}

#ifdef __cplusplus
}
#endif
