/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: display.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/**************************************************************
**  display.cpp                                              **
**  display parameters                                       **
**************************************************************/
#define  MOD_NPE_LIBNPEE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>

#include "libsatellite.h"
#include "libnpec.h"
#include "libnpee.h"
#include "npeepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

#define WIDTH (4)  /* display 4 parameters in each line */

void npe_display_parameters(npe_param_t  *param, double  errorValue)
{
  unsigned int i, j;
  npe_estparam_t *e;

  printf("\n\t<<<  %d Step : Error = %g  Penalty = %g >>>\n\n",
         Step, errorValue, PenaltyValue);

  e = npe_common->estparam;

  for(i=0; i<npe_common->init_paramnum; i+=j ){
    for(j=0; ((i+j)<npe_common->init_paramnum) && (j<WIDTH); j++,e++){
      printf("%15s ", e->name);
    }
    printf("\n");

    for(j=0; (i+j)<npe_common->init_paramnum && j<WIDTH; j++){
      printf("%15g ", getValue(param[i+j]));
    }
    putchar('\n');
    putchar('\n');
  }
  fflush( stdout );
}

#ifdef __cplusplus
}
#endif
