/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: libnpee.h,v 1.1 2004/04/19 17:07:52 orrisroot Exp $ */
#ifndef _MOD_NPE_LIBNPEE_H_
#define _MOD_NPE_LIBNPEE_H_

#ifdef DLLEXPORT
# undef DLLEXPORT
#endif
#ifdef DLLIMPORT
# undef DLLIMPORT
#endif
#ifdef DECLSPEC
# undef DECLSPEC
#endif
#ifdef WIN32
#  define DLLEXPORT __declspec(dllexport)
#  define DLLIMPORT __declspec(dllimport)
# ifdef MOD_NPE_LIBNPEE_EXPORTS
#  define DECLSPEC DLLEXPORT
# else
#  define DECLSPEC DLLIMPORT
# endif
#else
# define DLLEXPORT
# define DLLIMPORT
# define DECLSPEC
#endif

#ifdef EXTERN
# undef EXTERN
#endif
#ifdef LIBNPEE_GLOBAL_VARS
# define EXTERN
#else
# define EXTERN extern
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* definition of macro */
#define  getValue(P)  ((P.value*P.scale))
#define  UPPER_LIMIT  (10000)   /** value of Upper Limit           **/

/** NPE common area **/
DECLSPEC EXTERN npe_common_t *npe_common;

/** Array of Structures of All Parameters  **/
DECLSPEC EXTERN npe_param_t *AllParam;

/** Number of Variable Parameters **/
DECLSPEC EXTERN unsigned int NumVarParam;

/** Array of Pointers to Variable Parameters  **/
DECLSPEC EXTERN npe_param_t **VarParam;

/** Model Parameter **/
DECLSPEC EXTERN double *ModelParam;

/** Experiment Wave Data **/
DECLSPEC EXTERN double **WaveData;

/** Weight of error function **/
DECLSPEC EXTERN double **WeightData;

/** Output of model **/
DECLSPEC EXTERN double *Output;

/** temporary Value of Error & Penalty **/
DECLSPEC EXTERN double tmpDisp;
DECLSPEC EXTERN double tmpPena;

/**************************************************
**  NPE_proto.h                                  **
**  Header file in order to state                **
**  the prototype of NPE library                 **
**************************************************/

/* model (ncs or user) depend functions **/
/** Read Paramerter Function   */
typedef int (*readParam_t)();
DECLSPEC EXTERN readParam_t npe_readParam;
/** Error Function */
typedef double (*errorFunc_t)(npe_param_t*);
DECLSPEC EXTERN errorFunc_t npe_errorFunc;
/** Store Data */
typedef void (*dataStore_t)(npe_param_t*);
DECLSPEC EXTERN dataStore_t npe_dataStore;

/* lib/sim/method.c */
/** Optimization Function **/
DECLSPEC int npe_optimazation();

/* lib/sim/malloc.c */
/** memory allocate and init npe_common area */
DECLSPEC int npe_estimator_init();
DECLSPEC int npe_estimator_final();

/** Allocate Memory         **/
DECLSPEC void *malloc2Dim(int m, int n, int types);
/** Release Memory         **/
DECLSPEC void  free2Dim(void *ptr, int n, int types);

#ifdef __cplusplus
}
#endif

#endif /* _MOD_NPE_LIBNPEE_H_ */
