/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: read.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*************************************************
**  read.cpp --- Reading Functions of NPE	**
*************************************************/
#define  MOD_NPE_LIBNPEE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libsatellite.h"
#include "libnpec.h"
#include "libnpee.h"
#include "npeepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

#define	DEFAULTDATAPOINT	(1024)

/* global vars */
unsigned int  MaxHistoryPoint; /* referenced by lib/sim/store.c */
double       *ParamHist;
Header        head;

/*******************************************************************
**  'readStoreFile()' reads File Name for  Model Output &         **
**                                         Parameter Histry       **
*******************************************************************/
int npe_readStoreFile(){
  if(npe_common->history_file == NULL )
    return -1;

  if(npe_common->term_setbit[0] == NPE_FALSE)
    MaxHistoryPoint = DEFAULTDATAPOINT;
  else
    MaxHistoryPoint = (unsigned int)npe_common->term_crite[0];

  MaxHistoryPoint = MaxHistoryPoint/npe_common->history_interval+1
    +(((MaxHistoryPoint%npe_common->history_interval)==0)?(0):(1));

  ParamHist = (double*)malloc(sizeof(double)*MaxHistoryPoint);
  memset(ParamHist, 0, sizeof(double)*MaxHistoryPoint);

  InitHeader(&head);

  return 0;
}

#ifdef __cplusplus
}
#endif
