/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: read2.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*************************************************
**  read2.cpp --- Data Reading Function		**
**              from data and weight files      **
*************************************************/
#define  MOD_NPE_LIBNPEE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libsatellite.h"

#include "libnpec.h"
#include "libnpee.h"
#include "npeepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************
**  'readData()' reads object data & weight data                  **
*******************************************************************/
static int dataLoad(double **data, char *fname);

void  npe_readData(){
  if(npe_common->number_value > UPPER_LIMIT){
    exit(104); /* too may data */
  }

  Output = (double*)malloc2Dim(0, npe_common->number_value, 'D');

  /* load a output data */
  WaveData = (double**)malloc2Dim(npe_common->number_value, 
                                  npe_common->point_value, 'D');
  switch(dataLoad(WaveData, npe_common->data_file)){
  case 0: break; /* success */
  case -1: exit(105); /* can't open data file */
  case -2: exit(106); /* illegal data point of data file */
  case -3: exit(107); /* illegal data block size of data file header */
  }

  /* load a weight data */
  WeightData = (double**)malloc2Dim(npe_common->number_value, 
                                    npe_common->point_value, 'D');
  switch(dataLoad(WeightData, npe_common->weight_file)){
  case  0: break; /* success */
  case -1: exit(108); /* can't open weight file */
  case -2: exit(109); /* illegal data point of weight file */
  case -3: exit(110); /* illegal data block size of weight file header */
  }
}


/* data load function */
/*  0 - success */
/* -1 - can't open file */
/* -2 - illegal data point */
/* -3 - illegal data block size of data file */
static int dataLoad(double **data, char *fname){
  int  i, j;
  Header  head;
  char   *cdumWave;
  float  *fdumWave;
  double *ddumWave;

  /* The file is exist? */
  if(LoadHeader(fname, &head) < 0){
    return -1;
  }

  /* check the file size */
  if(head.index[1] < npe_common->point_value){
    return -2;
  }

  switch(head.data_size){
  case 2 :
    fprintf(stderr, "\n[Warring] < %s > is 2 byte size file.\n", fname);
/*     printf("Realy do you use this file ? (y/n) "); */
/*     rewind(stdin); */
/*     ch = getc(stdin); */
/*     rewind(stdin); */
/*     if((ch != 'y')&&(ch != 'Y')) exit(62); */
    for(i=0; i<npe_common->number_value; i++){
      cdumWave = (char*)LoadData(fname, i, &head);
      for(j=0; j<npe_common->point_value; j++)
        data[i][j] = (double)cdumWave[j];
      FreeData(cdumWave);
    }
    break;
  case 4 :
    for(i=0; i<npe_common->number_value; i++){
      fdumWave = (float*)LoadData(fname, i, &head);
      for(j=0; j<npe_common->point_value; j++)
        data[i][j] = (double)fdumWave[j];
      FreeData(fdumWave);
    }
    break;
  case 8 :
    for(i=0; i<npe_common->number_value; i++){
      ddumWave = (double*)LoadData(fname, i, &head);
      for(j=0; j<npe_common->point_value; j++)
        data[i][j] = ddumWave[j];
      FreeData(ddumWave);
    }
    break;
  default: 
    return -3;
  }
  return 0;
}

#ifdef __cplusplus
}
#endif
