/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: scale.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*************************************************
** scale.cpp --- Scaling Functions		**
*************************************************/
#define  MOD_NPE_LIBNPEE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>

#include "libnpec.h"
#include "libnpee.h"
#include "npeepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************
** Scale Transformation subroutine                                **
*******************************************************************/
static void scaleTrans10(npe_param_t **varParam);
static void scaleTrans1(npe_param_t **varParam);

int npe_scaleTrans(npe_param_t  **varParam){
  switch(npe_common->scale_type){
  case NPE_SCALE_NOFIRST:
    if(Step != 0) break; /* Execute scaling at the first time ONLY */
  case NPE_SCALE_ALLWAYS:
    scaleTrans10(varParam);
    break;
  case NPE_SCALE_RESCALING: /* Re-scaling */
    scaleTrans1(varParam);
    break;
  case NPE_SCALE_OFF: /* scaling off */
  default:
    break;
  }
  return 0;
}


static void  scaleTrans10(npe_param_t  **varParam){
  int  i;
  for(i=0; i<(int)NumVarParam; i++){
    if((varParam[i]->value >= 10.0)||(varParam[i]->value <= -10.0)){
      while((varParam[i]->value >= 10.0)||(varParam[i]->value <= -10.0)){
        varParam[i]->value /= 10.0;
        varParam[i]->scale *= 10.0;
      }
    }else if((varParam[i]->value < 1.0)&&(varParam[i]->value > -1.0)){
       while((varParam[i]->value < 1.0)&&(varParam[i]->value > -1.0)){
         varParam[i]->value *= 10.0;
         varParam[i]->scale /= 10.0;
       }
    }
  }
}

/* Re-scaling */
static void  scaleTrans1(npe_param_t  **varParam){
  int  i;
  for(i=0; i<(int)NumVarParam; i++){
    varParam[i]->scale *= varParam[i]->value;
    varParam[i]->value  = 1.0;
  }
}

#ifdef __cplusplus
}
#endif
