/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: store.cpp,v 1.2 2004/04/19 17:07:52 orrisroot Exp $ */
/*************************************************
**  store.cpp --- Store routine			**
**************************************************/

/*******************************************************************
**  storeParamHist	: stores Parameters & Model(C) Outputs    **
*******************************************************************/
#define  MOD_NPE_LIBNPEE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libsatellite.h"
#include "libnpec.h"
#include "libnpee.h"
#include "npeepriv.h"

#ifdef __cplusplus
extern "C" {
#endif

extern unsigned int  MaxHistoryPoint; /* lib/sim/read.c */

/*******************************************************************
**  'storeParamHist()' stores Parameter                           **
*******************************************************************/

int npe_storeParamHist(npe_param_t  *Param, npe_bool_t finalFlag){
  unsigned int i;
  int   HistSubBufDim, HistSubBufInd[MAX_INDEX];
  static unsigned int dataPointNum=1;
  double *ParamHist = NULL;
  static npe_bool_t FirstStore = NPE_TRUE;

  if(finalFlag == NPE_TRUE){
    printf("\t%d points are stored in \"%s\"\n",
            dataPointNum, npe_common->history_file);
  }

  if( finalFlag == NPE_TRUE || (Step%npe_common->history_interval) == 0 ){
    ParamHist = (double*)malloc(sizeof(double)*(npe_common->init_paramnum+1));
    memset(ParamHist, 0, sizeof(double)*(npe_common->init_paramnum+1));
    for(i=0; i < npe_common->init_paramnum ;i++)
      ParamHist[i] = (double)getValue( Param[i] );
    /* write error at the end of the each history */
    DispValue = tmpDisp;
    ParamHist[npe_common->init_paramnum] = DispValue;
    
    HistSubBufDim = 2;
    HistSubBufInd[0]=1;
    HistSubBufInd[1]=npe_common->init_paramnum+1;
    /* first write */
    if( FirstStore == NPE_TRUE ){
      /* new create - must be 8 byte blocksize */
      _WriteFile4(npe_common->history_file, 
                  HistSubBufDim, HistSubBufInd, (char*)ParamHist);
    }else{
      /* append - must be 8 byte blocksize */
      StoreData(npe_common->history_file, dataPointNum-1,
                HistSubBufDim, HistSubBufInd, (char*)ParamHist);
    }
    free(ParamHist);
    if(npe_common->history_interval >= 0)
      dataPointNum++;
  }
  if(finalFlag == NPE_TRUE)
    npe_dataStore( Param );
  FirstStore=NPE_FALSE;
  return 0;
}

#ifdef __cplusplus
}
#endif
