# Ansari-Bradley Test

func stat_evenjud(x){
	a1 = x/2;
	a2 = round(a1);
	if( a2 == a1 ){
		return 0;
	}else{
		return 1;
	}
}

func stat_numberex(d,n1,n2){
	nx = indexsize(d);

	str = typeof(d);
	if(str == "series"){
		def = Snapshot(d);
	}else{
		def = d;
	}

	snapshot lnum[nx];
	snapshot snum[nx];

	for( i = 0; i < nx; i++ ){
		A = def[i];
		cnt = 1;
		flag = 0;
		for( j = 0; j < nx; j++ ){
			B = def[j];
			if( A == B ){
				flag++;
			}else if( A > B ){
				cnt++;
			}
		}
		no = cnt;
		add = 0;
		for( k = flag; k > 0; k--){
			add += no;
			cnt = add  / flag;
			no++
		}
		lnum[i] = cnt;
	}

	for( l = 0; l < nx; l++ ){
		A = lnum[l];
		B = (nx + 1) - A;
		snum[l] = B;
	}

	n = n1 + n2;
	if(stat_evenjud(n) == 0){
		i = n / 2;
		lmin = minpos(lnum, i);
		smin = minpos(snum, i);
		
		for( m = 0; m < i; m++){
			a = lmin:[m];
			aa = Scalar(a);
			snum[aa] = lnum[aa];
		}
	}else{
		i = ( n + 1 ) / 2;
		lmin = minpos(lnum, i);
		smin = minpos(snum, (i - 1));
		
		for( m = 0; m < i; m++){
			a = lmin:[m];
			aa = Scalar(a);
			snum[aa] = lnum[aa];
		}
	}
	return snum;
}

func stat_calansaribradley(x,y,flag){
	if(typeof(x)=="snapshot"){
		xx=Series(x);
	}else{
		xx=x;
	}
	if(typeof(y)=="snapshot"){
		yy=Series(y);
	}else{
		yy=y;
	}

	check1 = stat_checkvartype(xx,"series",0);
	check1 = stat_checkvartype(yy,"series",0);

	xx = reform(xx,indexsize(xx));
	yy = reform(yy,indexsize(yy));

	cntx = indexsize(xx);
	cnty = indexsize(yy);

	if( cntx <= cnty ){ 
		n1data = xx;
		n2data = yy;
	}else{
		n1data = yy;
		n2data = xx;
	}

	mgData = merge(n1data,n2data);

	n1 = indexsize(n1data);
	n2 = indexsize(n2data);

	mgRank= stat_numberex(mgData,n1,n2);
	
	Rank = cut( mgRank, 0 , (n1-1));
	A = sum(Rank);


	if( n1 >= 10 && n2 >= 10 ){
		n = n1 + n2;
		if(stat_evenjud(n) == 0){
			a1 = abs(A - ((n1*(n1 + n2 + 2))/4))-0.5;
			a2 = sqrt(n1*n2*(n1 + n2 - 2)*((n1 + n2 + 2)) / (48*(n1 + n2 - 1)));
		    t = a1/a2;
			p = normcdf(t,0,1);
			series result;
			result = ( A , p );
			return result;
		}else{
			a1 = abs(A - (n1*((n1 + n2 + 1)^2))/(4*(n1 + n2)))-0.5;
			a2 = sqrt((n1*n2*(n1 + n2 - 1)*(((n1 + n2)^2) + 3))/(48*((n1+n2)^2)));
		    t = a1/a2;
			p = normcdf(t,0,1);
			series result;
			result = ( A , p );
			return result;
		}
	}else{
		eflag = 0;
		if(n1 == 1 ){
			eflag = 1;
		}else if(n1 == 2 ){
			if(n2 < 8 || n2 > 18){
			eflag = 1;
			}
		}else if(n1 == 3 ){
			if(n2 < 5 || n2 > 17){
			eflag = 1;
			}
		}else if(n1 == 4 ){
			if(n2 < 5 || n2 > 16){
			eflag = 1;
			}
		}else if(n1 == 5 ){
			if(n2 < 5 || n2 > 15){
			eflag = 1;
			}
		}else if(n1 == 6 ){
			if(n2 < 6 || n2 > 14){
			eflag = 1;
			}
		}else if(n1 == 7 ){
			if(n2 < 7 || n2 > 13){
			eflag = 1;
			}
		}else if(n1 == 8 ){
			if(n2 < 8 || n2 > 12){
			eflag = 1;
			}
		}else if(n1 == 9 ){
			if(n2 < 9 || n2 > 11){
			eflag = 1;
			}
		}
		if(eflag == 1){
			series result;
			printf("Error : This sample size is out of Ansari-Bradley list !\n");
			result = ( A, 0 );
			return result;
		}else{
			series result;
			a = stat_datafile("adata.dat");
			b1 = Snapshot(a[n1][n2]);
			a1 = b1[0];
			a2 = b1[1];

			if( A > a1 && A < a2 ){
				if( flag == 0){
					result = ( A, a1, a2 );
					return result;
				}else if( flag == 1 ){
					printf("p=0.05  %d < %d < %d \n",a1,A,a2);
					result = ( A, a1, a2 );
					return result;
				}
			}else{
				if( flag == 0){
					result = ( A, a1, a2 );
					return result;
				}else if( flag == 1 ){
					printf("p=0.05  %d < %d < %d \n",a1,A,a2);
					result = ( A, a1, a2 );
					return result;
				}
			}
		}
	}
}

func ansaribradley(x,y){
	check1 = stat_checkvartype(x,"either",0);
	check1 = stat_checkvartype(y,"either",0);

	result = stat_calansaribradley(x,y,1);
	return result;
}
