# FUNCTIONS FOR ERROR CHECK

func stat_checkisscalar(x){
	if(typeof(x)!="scalar"){
		printf("Error : Illegal parameter - not scalar type !\n");
		abort();
	}
	return 1;
}

func stat_checkpositive(x){
	if(x <= 0){
		printf("Error : Illegal parameter - not positive value !\n");
		abort();
	}
	return 1;
}

func stat_checkpositiveint(x){
	if(x <= 0 || x != int(x)){
		printf("Error : Illegal parameter - not positive integer !\n");
		abort();
	}
	return 1;
}

func stat_checkpositiveints(x){
	n = indexsize(x);
	sn = Snapshot(reform(x,n));
	for(i=0; i<n; i++){
		check1 = stat_checkpositiveint(sn[i]);
	}
	return 1;
}

func stat_checkpvalue(p){
	if(p <= 0.0 || p >= 1.0){
		printf("Error : Illegal p value ! (0 < p < 1)\n");
		abort();
	}
	return 1;
}

func stat_checkgroupcnt(x,n){
	srx = Series(x);
	srn = Series(n);
	idxx = index(x);
	idxn = index(n);
	errflg = 0;	
	msg = "Error : Illegal parameter - different dimension x or n !\n"

	dim = length(index(srx));
	if(dim==2 || dim==3){
		if(max(srn) != length(srx)){
			errflg = 1;
		}
		if(dim == 2){	/* for anova1,.. */
			if(idxx:[dim-1] != length(srn)){
				errflg = 1;
			}
		} else if(dim == 3){	/* for anova2,.. */
			if((idxx:[dim-1] != idxn:[dim-2]) || (idxx:[dim-2] != idxn:[dim-3])){
				errflg = 1;
			}
		}
	} else {
		errflg = 1;
	}

	if(errflg == 1){
		printf(msg);
		abort();
	}

	return 0;
}

func stat_checkelementcnt(x,y){
	
	if(indexsize(x) != indexsize(y)){
		printf("Error : Illegal parameter - different element count !\n");
		abort();
	}
	return 0;
}

func stat_checkanovatype(way,type){
	const CR_TYPE = "N";
	const RB_TYPE = "P";
	const CRF_TYPE = "N";
	const SPF_TYPE = "NP";
	const RBF_TYPE = "P";
	msg = "Error : Illegal type value !\n";
	if(typeof(type) != "string"){
		printf(msg);
		abort();
	}
	if(way == 1){
		if((type != CR_TYPE) && (type != RB_TYPE)){
			printf(msg);
			abort();
		}
	} else if(way == 2){
		if((type != CRF_TYPE) && (type != SPF_TYPE) && (type != RBF_TYPE)){
			printf(msg);
			abort();
		}
	}
	return 0;
}

func stat_checktype(x, type){
	vartype = typeof(x);
	if(type == "either"){
		if(vartype!="snapshot" && vartype!="series"){
			printf("Error : Illegal parameter - neither series nor snapshot type !\n");
			abort();
		}
	} else {
		if(vartype != type){
			msgp = "Error : Illegal parameter - not " + type + " type !\n"
			printf(msgp);
			abort();
		}
	}
	return 1;
}

func stat_checkdim(vardim, dim){
	if(vardim != dim){
		printf("Error : Illegal parameter - invalid dimension !\n");
		abort();
	}
	return 1;
}

func stat_checkvartype(x, type, dim){
	check1 =  stat_checktype(x, type);
	if(type == "scalar" || type == "series" || type == "either"){
		vardim = length(index(x))-1;
	} else if(type == "string"){
		vardim = length(index(x));
		if(vardim == 1 && index(x)==1){
			vardim = 0;
		}
	} else {
		vardim = length(index(x));
	}
	check2 = stat_checkdim(vardim, dim);
	
	return 1;
}

func stat_checkdivision0(x,msg){
	if(x==0){
		str = "Error : division by zero ! ( during calculating " + msg + " )\n";
		printf(str);
		abort();
	}
	return 1;
}

func stat_checksideflg(type){
	if(type!="O" && type!="T"){
		msg = "Error : Illegal type value !\n";
		printf(msg);
		abort();
	}
	return 1;
}