# INVERSE CUMULATIVE DISTRIBUTION FUNCTION OF THE CHI2 DISTRIBUTION

func stat_calchi2inv(p, v){
	check1 = stat_checkisscalar(p);
	check2 = stat_checkisscalar(v);
	check3 = stat_checkpvalue(p);
	check4 = stat_checkpositiveint(v);
	
	if(v == 1) {
		w = -stat_calnormsinv(p / 2);
		ret = w*w;
		return ret;
	}
	if(v == 2) {
		ret = -2 * log(p);
		return ret;
	}

	x = stat_calnormsinv(p);
	if(v > 10) {
		w = x * x;
		wx = sqrt(2 * v);
		c1 = (w - 7) * x / 9 / wx;
		c2 = ((3 * w + 7) * w - 16) * 2 / 405 / v;
		wx = v + wx * x + 2 * (w - 1) / 3 + c1 - c2;
		if(wx < 0){
			return 0;
		} else {
			return wx;
		}
	}

	w = 2 / 9 / v;
	w = 1 - w + x * sqrt(w);
	wx = v * w * w * w;
	
	if((v % 2) == 0){
		gam = 1;
	} else {
		gam = 1.772453850905516;
	}
	j = (v + 1) / 2 - 1;
	w = v / 2.;
	for(i = 1; i <= j; i++){
		gam *= (w - i);
	}
	
	x = wx / 2;
	c1 = pow(x, w-1);
	c2 = exp(-x) / 2;
	ret = wx + (stat_calchi2cdf(wx, v) - p) * gam / c1 / c2;
	return ret;
}

func chi2inv(x,v){
	if (typeof(x)=="scalar"){
		ret = stat_calchi2inv(x,v);
		return ret;
	} else {
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calchi2inv(y:[i],v);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}