# CUMULATIVE DISTIBUTION FUNCTION OF THE F-DISTIBUTION

func stat_calfcdf(ff,v1,v2,flg){
	check1 = stat_checkisscalar(ff);
	check2 = stat_checkisscalar(v1);
	check3 = stat_checkisscalar(v2);
	check4 = stat_checkisscalar(flg);
	
 	if(flg!=1){
 		check5 = stat_checkpositiveint(v1);
 		check6 = stat_checkpositiveint(v2);
 		
 		if(ff<=0){
			pp=1;
			return pp;
		}
	}
	
	if(ff<10^(-10)){
		ff = 10^(-10);
	}
	
	x = ff * v1/(ff*v1+v2);
	
	if(mod(v1,2)==0){
		if(mod(v2,2)==0){
			u = x * (1-x);
			pp = x;
			ia = 2;
			ib = 2;
			
		} else {
			u = 0.5*x*sqrt(1-x);
			pp=1-sqrt(1-x);
			ia=2;
			ib=1;
			
		}
	} else {
		if(mod(v2,2)==0){
			u = 0.5*sqrt(x)*(1-x);
			pp = sqrt(x);
			ia=1;
			ib =2;
			
		} else {
			u = sqrt(x*(1-x))/PI;
			pp = 1-2*atan2(sqrt(1-x),sqrt(x))/PI;
			ia=1;
			ib=1;
		}
	}

	if(ia != v1){
		for(i = ia; i<=v1-2; i+=2){
			pp -=2*u/i;
			u *= x*(i+ib)/i;
		}
	}

	if(ib != v2){
		for(i=ib; i<=v2-2; i+=2){
			pp += 2*u/i;
			u *=(1-x)*(i+v1)/i;
		}
	}
	
	if(flg==1){
		ans = u/ff;
		return ans;
	}
	
	ans =1-pp;
	return ans;
}

func fcdf(x,v1,v2){
	if (typeof(x)=="scalar"){
		ret = stat_calfcdf(x,v1,v2,0);
		return ret;

	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calfcdf(y:[i],v1,v2,0);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}