# Kolmogorov-Smirnov Goodness-of-Fit Test

func stat_normalize(x){
	avex = ave(x);
	sd = stddev(x);
	y = reform(x,indexsize(x));
	series normscore[indexsize(x)];
	
	check1 = stat_checkdivision0(sd,"D-Value");

	for(i=0;i<indexsize(x);i++){
		normscore[i] = (y:[i] - avex)/sd;
	}
	normscore = reform(normscore,index(x));
	return normscore;
}

func stat_cumfn(x){
	n = indexsize(x);
	series score[indexsize(x)];
	y = reform(x,n);
	
	for(i=0; i<indexsize(x); i++){
		count = 1;
		if(i!=indexsize(x)-1){
			flg = "true";
			while(flg=="true"){
				if(y:[i]==y:[i+count]){
					count ++;
				}else{
					flg="false";
				}
				if(i+count == indexsize(x)){
					flg="false";
				}
			}
		}
		for(j=0; j<count; j++){
			if(i==0){
				score[i+j] = count/n;
			} else{
				score[i+j] = score[i-1] + count/n;
			}
		}
		i+=count-1;
	}
	score = reform(score,index(x));
	return score;
}

func stat_ramdadist(x){
	r=stat_datafile("ramda.dat");
	q=stat_datafile("ramdaq.dat");
	
	indexr = 0;
	for(i=0;i<indexsize(r)-2;i++){
		rams = r[i];
		rams2 = r[i+1]
		minr = rams:[0];
		maxr = rams2:[length(rams2)-1];

		if(x>=minr && x<=maxr){
			indexr = i;
			break;
		}
	}
	
	if(indexr == 0){
		ramda = (r[indexr],r[indexr+1],r[indexr+2]);
		qramda = (q[indexr],q[indexr+1],q[indexr+2]);
		
	} else if(indexr == indexsize(r)-1){
		ramda = (r[indexr-2],r[indexr-1],r[indexr]);
		qramda = (q[indexr-2],q[indexr-1],q[indexr]);
		
	} else{
		ramda = (r[indexr-1],r[indexr],r[indexr+1]);
		qramda = (q[indexr-1],q[indexr],q[indexr+1]);
	}
	
	series ram[2];
	ram[0] = ramda;
	ram[1] = qramda;
	return ram;
}

func stat_adddata(data,x){
	for(i=0;i<indexsize(data);i++){
		if(data:[i] == x){
			return data;
		}
	}
	addx = (data,x);
	return addx;
}

func stat_getsplinedata(xx,yy,k){
	addx = stat_adddata(xx,k);
	sortx = sort(addx);
	
	count = 0;
	for(i=0;i<indexsize(sortx);i++){
		if(sortx:[i]==k){
			count = i;
			break;
		}
	}
	splinex = stat_spline(xx,yy,sortx);
	pp = splinex:[count];
	return pp;
}

func stat_ramdap(x){
	if(x <= 0.32){
		return 1;
	}else if(x >= 2.31){
		return 0;
	}
	
	ramda = stat_ramdadist(x);
	
	ramr = ramda[0];
	ramq = ramda[1];
	for(i=0;i<indexsize(ramr);i++){
		if(ramr:[i]==x){
			p=1-ramq:[i];
			return p;
		}
	}
	
	splinex = stat_getsplinedata(ramda[0],ramda[1],x)
	
	p = 1-splinex;
	return p;
}

func normal(x){
	check1 = stat_checktype(x, "either");
	sortx = sort(x);
	normx = stat_normalize(sortx);
	freqx = stat_cumfn(normx);
	ncdf = 1-normcdf(normx,0,1);
	d = freqx - ncdf;
	dmax = max(d);
	dmin = abs(min(d));

	if(dmax>dmin){
		dd = dmax;
	}else{
		dd = dmin;
	}
	n = indexsize(x);
	ram = sqrt(n) * dd;
	p = stat_ramdap(ram);
	
	ans = (dd,p);
	return ans;
}
