# CUMULATIVE DISTRIBUTION FUNCTION OF THE NORMAL DISTRIBUTION

func stat_calnormscdf(x){
	check1 = stat_checkisscalar(x);
	
	a1 = 0.049867347;
	a2 = 0.0211410061;
	a3 = 0.0032776263;
	a4 = 3.80036*10^(-5);
	a5 = 4.88906*10^(-5);
	a6 = 5.383*10^(-6);;
	absx = abs(x);
	
	pl = 1+absx*(a1 + absx*(a2 + absx*(a3 + absx*(a4 + absx*(a5 + absx*a6)))));
	pl = pow(pl, 16);
	pl = 1 - 0.5/pl;
	pl = 0.5 + (pl-0.5)*sgn(x);
	pu = 1 - pl;
	
	return pu;
}

func stat_normscdf(x){
	check1 = stat_checkisscalar(x);

	if (typeof(x)=="scalar"){
		ret = stat_calnormscdf(x);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			rets[i] = stat_calnormscdf(y:[i]);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}

func normcdf(x,mu,sig){
	check1 = stat_checkisscalar(mu);
	check2 = stat_checkisscalar(sig);
	check3 = stat_checkpositive(sig);
	
	if (typeof(x)=="scalar"){
		xx = (x-mu)/sig;
		ret = stat_calnormscdf(xx);
		return ret;
	}else{
		y=reform(x,(indexsize(x)));
		series rets[indexsize(x)];
		
		for(i=0;i<indexsize(x);i++){
			yy = (y:[i]-mu)/sig;
			rets[i] = stat_calnormscdf(yy);
		}
		
		rets = reform(rets,index(x));
		
		if(typeof(x)=="snapshot"){
			srets = Snapshot(rets);
			return srets;
		} else {
			return rets;
		}
	}
}