# Functions Related to Posthoc Test

func stat_navrs(x,n){
	k = indexsize(n);
	sumx=0;
	for(i=0; i<k; i++){
		xi = x[i];
		ni = n:[i];
		for(j=0; j<ni; j++){
			sumx += xi:[j];
		}
	}
	avrx = sumx/sum(n);
	return avrx;
}

func stat_navr(x,n){
	sumx=0;
	for(i=0; i<n; i++){
		sumx += x:[i];
	}
	av = sumx/n;
	return av;
}

func stat_calssw(x,n){
	k = indexsize(n);
	ssw = 0;
	for(i=0; i<k; i++){
		xi = x[i];
		ni = n:[i];
		avrxi = stat_navr(xi,ni);
		for(j=0; j<ni; j++){
			ssw += (xi:[j]-avrxi)*(xi:[j]-avrxi);
		}
	}
	return ssw;
}

func stat_posthoc(x,n,param){
	check1 = stat_checkvartype(x,"either",1);
	check1 = stat_checkvartype(n,"series",0);
	check1 = stat_checkpositiveints(n);
	check1 = stat_checkgroupcnt(x,n);

	if(typeof(x)=="snapshot"){
		xx=Series(x);
	}else{
		xx=x;
	}

	k = indexsize(n);
	ncount = sum(n);
	dfw = ncount-k;
	check1 = stat_checkdivision0(dfw,"T-Value");
	msw = stat_calssw(xx,n)/dfw;

	series posthocf[k*(k-1)];
	count=0;
	for(i=0; i<k-1; i++){
		xi = xx[i];
		ni = n:[i];
		avrxi = stat_navr(xi,ni);
		
		for(j=i+1;j<k;j++){
			xj = xx[j];
			nj = n:[j];
			avrxj = stat_navr(xj,nj);
			
			w = 1/ni + 1/nj;
			check1 = stat_checkdivision0((msw * w * k),"T-Value");
			
			# ======= Tukey ===========
			if(param=="tukey"){
				fij = abs((avrxi - avrxj)/sqrt(msw * w));
				posthocf[count++] = fij;
				posthocf[count++] = stat_qprob(fij*sqrt(2),k,dfw);
			
			# ======= Scheffe ===========
			}else if(param=="scheffe"){
				fij = (avrxi - avrxj)^2/(k-1)/(msw * w);
				posthocf[count++] = fij;
				posthocf[count++] = fcdf(fij,k-1,dfw);
			
			# ======= Bonferroni ===========
			}else if(param=="bonferroni"){
				fij = abs(avrxi - avrxj)/sqrt(msw * w);
				posthocf[count++] = fij;
				pvalue = tcdf(fij,dfw)*(k*(k-1));
				if(pvalue > 1){
					pvalue = 1;
				}
				posthocf[count++] = pvalue;
			}
		}
	}
	ans = reform(posthocf,(k*(k-1)/2,2));
	return ans;
}

func stat_caldunnetp(n,dfw,type){
	k = indexsize(n);
	controln = n:[k-1];
	
	series ram[k-1];
	for(i=0;i<k-1;i++){
		check1 = stat_checkdivision0((n:[i]+controln),"ramda-Value");
		ram[i] = n:[i]/(n:[i]+controln);
	}
	
	pcount=0;
	pp=0;
	for(i=0;i<k-2;i++){
		for(j=i+1;j<k-1;j++){
			pp = pp + sqrt(ram[i]*ram[j]);
			pcount ++;
		}
	}
	
	check1 = stat_checkdivision0(pcount,"P-Value");
	p = pp/pcount;
	
	if(type=="T"){
		dn1 = stat_datafile("dunnet01.dat");
		dn3 = stat_datafile("dunnet03.dat");
		dn5 = stat_datafile("dunnet05.dat");
		dn7 = stat_datafile("dunnet07.dat");
		dn9 = stat_datafile("dunnet09.dat");
	}else if(type=="O"){
		dn1 = stat_datafile("dunnet1.dat");
		dn3 = stat_datafile("dunnet3.dat");
		dn5 = stat_datafile("dunnet5.dat");
		dn7 = stat_datafile("dunnet7.dat");
		dn9 = stat_datafile("dunnet9.dat");
	}
	
	if(p<=0.3){
		p1 = 0.1;
		p2 = 0.3;
		d1 = Snapshot(dn1);
		d2 = Snapshot(dn3);
	
	} else if(p<=0.5){
		p1 = 0.3;
		p2 = 0.5;
		d1 = Snapshot(dn3);
		d2 = Snapshot(dn5);
	
	} else if(p<=0.7){
		p1 = 0.5;
		p2 = 0.7;
		d1 = Snapshot(dn5);
		d2 = Snapshot(dn7);
		
	} else{
		p1 = 0.7;
		p2 = 0.9;
		d1 = Snapshot(dn7);
		d2 = Snapshot(dn9);
	}
	
	if(k>9){
		printf("Error : This group size is out of Dunnet list ! (group <= 9) \n");
		abort();
	}
	
	scalar dd1,dd2;
	if(dfw<=50){
		dd1 = d1[k-2][dfw];
		dd2 = d2[k-2][dfw];
	}else{
		dx = (50,60,80,100,120,240,360,999);
		dy1 = (d1[k-2][50],d1[k-2][51],d1[k-2][52],d1[k-2][53],d1[k-2][54],d1[k-2][55],d1[k-2][56],d1[k-2][57]);
		dy2 = (d2[k-2][50],d2[k-2][51],d2[k-2][52],d2[k-2][53],d2[k-2][54],d2[k-2][55],d2[k-2][56],d2[k-2][57]);
		dd1 = stat_getsplinedata(dx,dy1,dfw);
		dd2 = stat_getsplinedata(dx,dy2,dfw);
	}
	
	check1 = stat_checkdivision0((1-p)*(1-p1)*(1-p2)*(1/(1-p2)-1/(1-p1)),"P-Value");
	pval = ((1/(1-p2)-1/(1-p)) / (1/(1-p2)-1/(1-p1)) * dd1) + ((1/(1-p)-1/(1-p1)) / (1/(1-p2)-1/(1-p1)) * dd2);
	return pval;
}

func stat_caldunnet(x,n,type){
	check1 = stat_checkgroupcnt(x,n);
	check1 = stat_checkvartype(x,"series",1);
	check1 = stat_checkvartype(n,"series",0);
	check1 = stat_checkpositiveints(n);	
	
	if(typeof(x)=="snapshot"){
		xx = Series(x);
	}else{
		xx = x;
	}

	k = indexsize(n);
	ncount = sum(n);
	dfw = ncount-k;
	check1 = stat_checkdivision0(dfw,"T-Value");
	msw = stat_calssw(xx,n)/dfw;

	controlx = xx[k-1];
	controln = n:[k-1];
	controlavr = stat_navr(controlx,controln);

	series dunnetf[(k-1)*2];
	count=0;
	for(i=0; i<k-1; i++){
		xi = xx[i];
		ni = n:[i];
		avrxi = stat_navr(xi,ni);
		check1 = stat_checkdivision0(controln,"W-Value");
		w = 1/ni + 1/controln;
		check1 = stat_checkdivision0((msw * w * k),"T-Value");
		fij = (controlavr - avrxi)/sqrt((msw * w));
		dunnetf[count++] = abs(fij);
		dunnetf[count++] = stat_caldunnetp(n,dfw,type);
	}
	ans = reform(dunnetf,(k-1,2));
	return ans;
}

func tukey(x,n){
	ret = stat_posthoc(x,n,"tukey");
	return ret;
}

func scheffe(x,n){
	ret = stat_posthoc(x,n,"scheffe");
	return ret;
}

func bonferroni(x,n){
	ret = stat_posthoc(x,n,"bonferroni");
	return ret;
}

func dunnet(x,n){
	ret = stat_caldunnet(x,n,"T");
	return ret;
}

func steeldwass(x,n){
	check1 = stat_checkvartype(A,"series",1);
	check2 = stat_checkvartype(n,"series",0);
	check1 = stat_checkpositiveints(n);
	check3 = stat_checkgroupcnt(A,n);
	
	str = typeof(x);
	if(str=="snapshot"){
		A = Series(x);
	}else{
		A = x;
	}

	scalar nmax;
	idx = index(A);
	nmax = idx:[1];

	scalar nummax
	nummax = 0;
	for(i=0;i<nmax;i++){
		nummax += i;
	}	

	series Z[nummax];
	cnt = 0;
	for(i=0;i<nmax;i++){
		nx = n:[i];
		xi=cut(A[i],0,nx-1);
		for(j=i+1;j<nmax;j++){
			ny = n:[j];
			yj=cut(A[j],0,ny-1);
			N = nx + ny;
			zz = merge(xi,yj);
			
			snapshot zx[N];
			zx = Snapshot(zz);
			
			num = stat_number(zx);
			r = Snapshot(num);
			snapshot ri[nx];
			for(k=0;k<nx;k++){
				ri[k] = r[k];
			}
			Ri = sum(ri) ;
			
			snapshot rj[ny];
			for(k=0;k<ny;k++){
			 	rj[k] = r[k+nx];
			}
			Rj = sum(rj) ;
			
			Ei = (nx*(N+1)) / 2 ;
			v1 = (nx*ny) / (N*(N-1));
			v2 = 0;
			for(k=0;k<nx;k++){
				v2 += ri[k]*ri[k];
			}
			v3 = 0;
			for(k=0;k<ny;k++){
				v3 += rj[k]*rj[k];
			}
			v4 = (N * pow((N+1),2)) / 4;
			V = v1*(v2+v3-v4);

			check1 = stat_checkdivision0(V,"T-Value");
			t = (Ri - Ei) / sqrt(V);

			tt = abs(t);
			p = stat_qprob(tt*sqrt(2),indexsize(n),99999);
			Z[cnt]=(tt,p)

			cnt++;
		}
	}
	tz = trans(Z);
	return tz;
}

func steel(x,n){
	check1 = stat_checkvartype(A,"series",1);
	check1 = stat_checkvartype(n,"series",0);
	check1 = stat_checkpositiveints(n);
	check3 = stat_checkgroupcnt(A,n);
	
	str = typeof(x);
	if(str=="snapshot"){
		A=Series(x);
	}else{
		A=x;
	}

	idx = index(A);
	nmax = idx:[1];
	scalar nummax
	nummax = nmax - 1;
	nparammax = max(n);

	series Z[nummax];
	cnt = 0;
	i = nummax;
	xi = A[i];
	for(j=0;j<nummax;j++){
		yj = A[j];
		nx = n:[i];
		ny = n:[j];
		N = nx+ny;
		
		zz = merge(xi,yj);
		snapshot zx[N];
		zx = Snapshot(zz);
		num = stat_number( zx );
		
		zer = 0;
		zer = nparammax * 2 - N; 

		r = Snapshot(num);
		snapshot ri[nx];
		for(k=0;k<nx;k++){
			ri[k] = r[k] - zer;
		}

		snapshot rj[ny];
		for(k=0;k<ny;k++){
			 rj[k] = r[k + nparammax] - zer;
		}
		Ri = sum(ri);

		Ei = (ny*(N+1)) / 2;
		
		check1 = stat_checkdivision0((N*(N-1)),"T-Value");
		v1 = (nx*ny) / (N*(N-1));
		v2=0;
		for(k=0;k<nx;k++){
			v2 += pow(ri[k],2);
		}
		v3=0;
		for(k=0;k<ny;k++){
			v3 += rj[k]*rj[k];
		}
		v4 = (N * pow((N+1),2)) / 4;
		V = v1*(v2+v3-v4);

		check1 = stat_checkdivision0(sqrt(V),"T-Value");
		t = (Ri - Ei) / sqrt(V);
		
		nflag = 0;
		nidx = index(n);
		for(ni=0;ni<nidx-2;ni++){
			for(nj=ni+1;nj<nidx-1;nj++){
				if(n:[ni]!=n:[nj]){
					nflag=1;
					break;
				}
			}
		}
		
		ik = indexsize(n);
		if(nflag==0){
			check1 = stat_checkdivision0((nx + ny),"P-Value");
			low = ny / (nx + ny);
			p = Series(low)
		}else{
			controln = n:[nummax];
			series ram[ik-1];
			for(ii=0;ii<ik-1;ii++){
				check1 = stat_checkdivision0((n:[ii]+controln),"P-Value");
				ram[ii] = n:[ii]/(n:[ii]+controln);
			}
			pcount = 0;
			series pp
			loopcnt=0;
			for(ii=0;ii<ik-2;ii++){
				for(ij=ii+1;ij<ik-1;ij++){
					pp = pp + sqrt(ram[ii]*ram[ij]);
					loopcnt++;
				}
			}
			check1 = stat_checkdivision0(loopcnt,"P-Value");
			p = pp/loopcnt;
		}
		
		pv=p;
		a = idx:[1];
		if(a > 9 || a < 2){
			printf("Error : This group size is out of Dunnet list ! (group <= 9) \n");
			abort();
		}

		series dn1,dn3,dn5,dn7,dn9;
		# a= 0  1   2     3     4     5     6     7    8      9
		dn1=(0, 0,1.960,2.236,2.386,2.489,2.567,2.629,2.680,2.724);
		dn3=(0, 0,1.960,2.229,2.375,2.475,2.550,2.610,2.660,2.703);
		dn5=(0, 0,1.960,2.212,2.349,2.442,2.511,2.567,2.613,2.652);
		dn7=(0, 0,1.960,2.180,2.298,2.377,2.436,2.483,2.521,2.554);
		dn9=(0, 0,1.960,2.108,2.185,2.237,2.274,2.304,2.328,2.349);
			
		if(pv < 0.0){
			check4 = stat_checkpvalue(pv);
		}else if(pv <= 0.1){
			dpa= (dn1:[a]);
			tt = abs(t);	
			Z[cnt]=(tt,dpa);
		}else if(pv == 0.3){
			dpa = (dn3:[a]);
			tt = abs(t);	
			Z[cnt]=(tt,dpa);
		}else if(pv == 0.5){
			dpa = (dn5:[a]);
			tt = abs(t);	
			Z[cnt]=(tt,dpa);
		}else if(pv == 0.7){
			dpa = (dn7:[a]);
			tt = abs(t);	
			Z[cnt]=(tt,dpa);
		}else if(pv >= 0.9){
			dpa = (dn9:[a]);
			tt = abs(t);	
			Z[cnt]=(tt,dpa);
		}else {
			if(pv > 0.1 && pv < 0.3){
				p1=0.1;
				p2=0.3;
				dp1 = dn1:[a];
				dp2 = dn1:[a];
			}else if(pv > 0.3 && pv < 0.5){
				p1=0.3;
				p2=0.5;
				dp1 = dn3:[a];
				dp2 = dn5:[a];
			}else if(pv > 0.5 && pv < 0.7){
				p1=0.5;
				p2=0.7;
				dp1 = dn5:[a];
				dp2 = dn7:[a];
			}else if(pv > 0.7 && pv < 0.9){
				p1=0.7;
				p2=0.9;
				dp1 = dn7:[a];
				dp2 = dn9:[a];
			}
			check1 = stat_checkdivision0(((1-p1)*(1-p2)*(1-pv)),"P-Value");
			check1 = stat_checkdivision0((1/(1-p2)-1/(1-p1))*(1/(1-p2)-1/(1-p1)),"P-Value");
			series dpb[1];
			dpb[0] =((1/(1-p2)-1/(1-pv)) / (1/(1-p2)-1/(1-p1)) * dp1) + ((1/(1-pv)-1/(1-p1)) / (1/(1-p2)-1/(1-p1)) * dp2);
			tt = abs(t);
			Z[cnt]=(tt,dpb[0]);
		}
		cnt++;
	}
	tz = trans(Z);
	return tz;
}