# Probability of Studentized Range

func stat_qerfc(x){
	const pv= 1.8296570980424689847157930974106706835e+01;
	const ph= 8.9588287394342176848213494031807385567e+00;
	const p0= 2.1226887418241545314975570224238841543e-01;
	const p1= 1.6766968820663231170102487414107148110e-01;
	const p2= 1.0461429607758480243524362040994242137e-01;
	const p3= 5.1557963860512142911764627378588661742e-02;
	const p4= 2.0070986488528139460346647533434778000e-02;
	const p5= 6.1717726506718148117513762897928828534e-03;
	const p6= 1.4990611906920858646769185063310410160e-03;
	const p7= 2.8760540416705806615617926157307107830e-04;
	const p8= 4.3585593590380741491013549969419946961e-05;
	const p9= 5.2174364856655433775383935118049845471e-06;
	const p10= 4.9333351722974670085736982894474122277e-07;
	const p11= 3.6846914376723888190666722894010079935e-08;
	const p12= 2.1729515092764086499231043367920037215e-09;
	const p13= 9.9870022842895735663712411206346261651e-11;
	const p14= 3.1775163189596489863458236395414830880e-12;
	const p15= 4.5657943993597540327708145643160878201e-14;
	const p16= 1.1940964427370412648558173558044106203e-16;
	const q0= 2.9482230394292049252878077330764031337e-02;
	const q1= 2.6534007354862844327590269604581049764e-01;
	const q2= 7.3705575985730123132195272141160572532e-01;
	const q3= 1.4446292893203104133929687855854497896e+00;
	const q4= 2.3880606619376559912235584857800710490e+00;
	const q5= 3.5673498777093386979273977202889759348e+00;
	const q6= 4.9824969366355296879760903991854492762e+00;
	const q7= 6.6335018387405633238409855625402006223e+00;
	const q8= 8.5203645862651289478197632097553870199e+00;
	const q9= 1.0643085317662274170216548777166393329e+01;
	const q10= 1.3001669850030489723387515813223808078e+01;
	const q11= 1.5596282517377690399267249728222735970e+01;
	const q12= 1.8429903207271748464995406180854691072e+01;
	const q13= 2.1533907893494593530979123915138686107e+01;
	const q14= 2.5076752889217226137869837117288885077e+01;
	const q15= 2.9515380437412601845256918753602002410e+01;
	const q16= 3.5792848810704122499184545805923520658e+01;

	scalar y;
	y=x*x;
	y=exp(-y)*x*(p16/(y+q16)+p15/(y+q15)+p14/(y+q14)+p13/(y+q13)+p12/(y+q12)+p11/(y+q11)+p10/(y+q10)+p9/(y+q9)+p8/(y+q8)+p7/(y+q7)+p6/(y+q6)+p5/(y+q5)+p4/(y+q4)+p3/(y+q3)+p2/(y+q2)+p1/(y+q1)+p0/(y+q0));
	if(x<ph){
		y=y+2/(exp(pv*x)+1);
	}
	return y;
}

func stat_qerf(x){
	const p0= 1.1283791670955125738961589031215451638e+00;
	const p1=-3.7612638903183752463205296770705954644e-01;
	const p2= 1.1283791670955125738961588999935886077e-01;
	const p3=-2.6866170645131251759432042514961432313e-02;
	const p4= 5.2239776254421878419519215904293747973e-03;
	const p5=-8.5483270234508523548393236134016747257e-04;
	const p6= 1.2055332981788774687616425024649090688e-04;
	const p7=-1.4925650357342418486127546759864765351e-05;
	const p8= 1.6462113548558693746378431523719715229e-06;
	const p9=-1.6365454692461428822012524459668520250e-07;
	const p10= 1.4701966650809284594534032908988195691e-08;

	scalar y;
	y=abs(x);
	if(y > 0.125e0){
		if(x>0){
			res = 1-stat_qerfc(y);
			return res;
		}else{
			res = -(1-stat_qerfc(y)); 
			return res;
		}
	}else{
		y=x*x;
		res =((((((((((p10*y+p9)*y+p8)*y+p7)*y+p6)*y+p5)*y+p4)*y+p3)*y+p2)*y+p1)*y+p0)*x;
		return res;
	}
}

func stat_wprob(W, RR, CC,IR){
	const  BB = 8.00000000000000000000000;
	const  EPS = 1.00000000000000000000000;
	const  NLEG = 12;
	const  WLAR = 3.00000000000000000000000;
	const  WINCR1 = 2.00000000000000000000000;
	const  WINCR2 = 3.00000000000000000000000;
	const  EPS1 = -30.00000000000000000000000;
	const  EPS2 = -50.00000000000000000000000;
	const  EPS3 = 60.00000000000000000000000;

	const  SQ2PII=0.3989422804014326779399461;
	const  QSQR2=1.41421356237309504880168872421;

	const xleg =(0.981560634246719250690549090149e+00, 0.904117256370474856678465866119e+00, 0.769902674194304687036893833213e+00, 0.587317954286617447296702418941e+00, 0.367831498998180193752691536644e+00, 0.125233408511468915472441369464e+00);
	const aleg =(0.471753363865118271946159614850e-01, 0.106939325995318430960254718194e+00, 0.160078328543346226334652529543e+00, 0.203167426723065921749064455810e+00, 0.233492536538354808760849898925e+00, 0.249147045813402785000562436043e+00);

	scalar QSQZ;
	scalar blb,binc,bub,einsum,cc1;
	scalar elsum,a,b,c,ac,xx;
	scalar QEXPO,PPLUS,PMINUS,RINSUM;

	IR = 0;
	QSQZ = W * 0.5;
	result = 1.0;

	if (QSQZ >= BB){
		return result;
	}
	
	result = stat_qerf(QSQZ / QSQR2);
	
	if (result >= exp(EPS2 / CC)) {
		result = pow(result,CC);
	} else {
		result = 0.0;
	}
	
	if (W > WLAR) {
		WINCR = round(WINCR1);
	} else {
		WINCR = round(WINCR2);
	}

	BLB = QSQZ;
	BINC = (BB - QSQZ) / WINCR;
	BUB = BLB + BINC;
	EINSUM = 0.0;
	CC1 = CC - 1.0;
	IHALF =6;

	for(WI=1;WI <= WINCR;WI++){
		ELSUM = 0.0;
		A = 0.5 * (BUB + BLB);
		B = 0.5 * (BUB - BLB);
		for(JJ= 1;JJ <= NLEG;JJ++){
			if(IHALF < JJ){
				J = NLEG - JJ;
				XX = xleg:[J];
			}else{
				J = JJ;
				XX = -(xleg:[J-1]);
			}

			C = B * XX;
			AC = A + C;
			QEXPO = AC * AC;

			if (QEXPO > EPS3){
				break;
			} 

			if (AC > 0.0) {
				PPLUS = 1.0 + stat_qerf(AC / QSQR2)
			}else{
				PPLUS = stat_qerfc(-AC / QSQR2);
			}

			if (AC > W) {
				PMINUS = 1.0 + stat_qerf(AC / QSQR2 - W / QSQR2);
			}else{
				PMINUS = stat_qerfc(W / QSQR2 - AC / QSQR2);
			}

			RINSUM = PPLUS * 0.5 - PMINUS * 0.5;

			if (RINSUM >= exp (EPS1 / CC1)) {
				RINSUM = aleg:[J-1] * exp (-0.5 * QEXPO)* pow(RINSUM,CC1);
				ELSUM = ELSUM + RINSUM;
			}
		}
		ELSUM = 2.0 * B * CC * SQ2PII * ELSUM;
		EINSUM = EINSUM + ELSUM;
		BLB = BUB;
		BUB = BUB + BINC;
	}

	result = EINSUM + result;
	if (result <= exp(EPS1 / RR)) {
		result = 0.0;
		return result;
	}
	result = pow(result, RR);
	if (result > EPS) {
		IR = 1;
		return IR;
	}
	if (result > 1.0 && result <= EPS) {
		result = 1.0;
		return result;
	}
	return result;
}

func stat_qprob(Q, CC, DF){
	const NLEGQ = 16;
	const EPS = 1.00000000000000000000000;
	const EPS1 = -30.00000000000000000000000;
	const EPS2 = 10.0e-14;
	const DHAF = 100.00000000000000000000000;
	const DQUAR = 800.00000000000000000000000;
	const DEIGH = 5000.00000000000000000000000;
	const DLARG = 25000.00000000000000000000000;
	const ULEN1 = 1.00000000000000000000000;
	const ULEN2 = 0.50000000000000000000000;
	const ULEN3 = 0.250000000000000000000000;
	const ULEN4 = 0.1250000000000000000000000;
	const R2 = 0.693147180559945309417232121458;
	const xlegq=(0.989400934991649932596154173450e+00, 0.944575023073232576077988415535e+00, 0.865631202387831743880467897712e+00, 0.755404408355003033895101194847e+00, 0.617876244402643748446671764049e+00, 0.458016777657227386342419442984e+00, 0.281603550779258913230460501460e+00, 0.950125098376374401853193354250e-01);
	const alegq=(0.271524594117540948517805724560e-01, 0.622535239386478928628438369944e-01, 0.951585116824927848099251076022e-01, 0.124628971255533872052476282192e+00, 0.149595988816576732081501730547e+00, 0.169156519395002538189312079030e+00, 0.182603415044923588866763667969e+00, 0.189450610455068496285396723208e+00);

	scalar f2,F2LF,f21,ff4;
	scalar OTSUM,twa1,t1;
	scalar qsqz,rotsum,ulen,WPRB;

	IHALFQ =8;
	IT = 0;
	RR = 1.0;
	IR1 = 0;
	IR2 = 0;

	if (DF > DLARG){
		result = stat_wprob(Q, RR, CC, IT);
		if (IT == 1){
			IR1 = 1;
			return IR1
		}  
	}

	F2 = DF * 0.5;
	F2LF = F2 * log (DF) - DF * R2 - stat_lggamma(F2);
	F21 = F2 - 1.0;
	FF4 = DF * 0.25;

	if (DF <= DHAF) {
		ULEN = ULEN1
	}else if (DF <= DQUAR){
		ULEN = ULEN2
	}else if (DF <= DEIGH) {
		ULEN = ULEN3;
	}else{
		ULEN = ULEN4;
	}

	F2LF = F2LF + log(ULEN);

	result = 0.0;

	for(I= 1; I< 50;I++){
		OTSUM = 0.0;
		TWA1 = (2. * I - 1.0) * ULEN;

		for(JJ = 1;JJ<=NLEGQ;JJ++){
			if (IHALFQ < JJ){
				J = JJ  - IHALFQ;
				T1= F2LF + F21 * log(TWA1 + xlegq:[J-1] * ULEN) - (xlegq:[J-1] * ULEN + TWA1) * FF4;
			}else{
				J = JJ;
				T1 = F2LF + F21 * log(abs(TWA1 - xlegq:[J-1] * ULEN)) + (xlegq:[J-1] * ULEN - TWA1) * FF4;
			}

			if (T1 >= EPS1) {
				if (IHALFQ < JJ){ 
					QSQZ = Q * sqrt((xlegq:[J-1] * ULEN + TWA1) * 0.5);
				}else{
					QSQZ = Q * sqrt(abs(-xlegq:[J-1] * ULEN + TWA1) * 0.5);
				}
				
				WPRB = stat_wprob(QSQZ, RR, CC, IT);

				if (IT == 1) {
					IR1 = 1;
				}  
				ROTSUM = WPRB * alegq:[J-1] * exp(T1);
				OTSUM = ROTSUM + OTSUM;
			}
		}
		if (I * ULEN >= 1.0 && OTSUM <= EPS2) {
			break;
		}
		result = result + OTSUM;
	}
	
	if (result > EPS) {
		IR2 = 1;
		return (1-IR2);
	}  
	if (result > 1.0 && result <= EPS) {
		result = 1.0;
		return (1-result);
	}
	return (1-result);
}