/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SYSTEM.cpp,v 1.2 2005/03/28 15:10:00 orrisroot Exp $ */

#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

static sl4_stack_t *proc_stack;

DLLEXPORT const char *SetupCommand(){
  static char *setup_command="system_setup";
  return setup_command;
}

DLLEXPORT const char *CleanCommand(){
  static char *clean_command="system_clean";
  return clean_command;
}

DLLEXPORT int system_setup(){
  proc_stack = sl4_stack_new();
  if(proc_stack == NULL)
    return -1;
  return 0;
}

int procstack_regist(int pid){
  int *tmp; 
  tmp = (int*)malloc(sizeof(int));
  if(tmp == NULL) return -1;
  *tmp = pid;
  if(sl4_stack_push(proc_stack, tmp) != 0){
    free(tmp);
    return -1;
  }
  return 0;
}

DLLEXPORT int system_clean(){
  int *pid, code;
  while(sl4_stack_empty(proc_stack) == 0){
    code = 0;
    pid = (int*)sl4_stack_top(proc_stack);
    wait_child_process(*pid, &code);
    /* printf("pid : %d - %d\n", *pid, code); */
    sl4_stack_pop(proc_stack);
    free(pid);
  }
  free(proc_stack);
  return 0;
}

#ifdef __cplusplus
}
#endif
