/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: fill.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : fill           *
*    ( Ver 1.0 : 1993/04/10 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_fill(){
  int index1[MAX_INDEX], index2[MAX_INDEX], index3[MAX_INDEX];
  int index4[MAX_INDEX], index5[MAX_INDEX];
  int pos[MAX_INDEX];
  int dim1, dim2, dim3, m, i, dpt;
  Buffer  *x, *y, *z;
  double v;

  if (( x = GetSeries( 0, &dim1, index1 ) ) == NULL )
    return (4);
  if (( y = GetSeries( 1, &dim2, index2 ) ) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(1);
    index2[0] = 1;
  }
  if (( z = GetSeries( 2, &dim3, index3 ) ) == NULL ) {
    z = AllocBuffer(1);
    z[0] = GetScalar(2);
    index3[0] = 1;
  }
  v = GetScalar( 3 );

  if ( index2[0] != dim1 || index3[0] != index2[0] )
    return (16);

  for ( i = 0; i < dim1; i++ ) {
    if ( (int)z[i] < (int)y[i] || index1[i] <= (int)z[i] )
      return (7);
    index4[i] = (int)y[i];
    index5[i] = (int)z[i]-(int)y[i]+1;
  }

  if ( dim1 == 1 ) {
    m = index4[0]+index5[0];
    for ( i = index4[0]; i < m; i++ )
      x[ i ] = v;
  } else {
    for ( i = 0; i < dim1; i++ )
      pos [i] = index4[i];
    do {
      dpt = Index( pos, dim1, index1 );
      m = dpt + index5[dim1-1];
      for ( i = dpt; i < m; i++ )
	x[ i ] = v;

      pos [dim1-2]++;
      for ( i = dim1-2; i > 0; i-- )
	if ( pos[i] > z[i] ) {
	  pos [i-1]++;
	  pos [i] = (int) y[i];
	}
    } while ( pos[0] <= z[0] );
  }
  ReturnSeries( x, dim1, index1 );
  //FreeBuffer( x );
#if defined(_DEBUG)
  printf("debug mode...\n");
  FreeBuffer( y );
  FreeBuffer( z );
#endif

  return 0;
}

#ifdef __cplusplus
}
#endif
