/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: find.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#include "system_sub.h"
/************************************************
*      FIND   IB, VAL, NUM, IOUT                *
*             IB   : buffer number              *
*             VAL  : value                      *
*             IOUT : output                     *
************************************************/

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_find(){
	register int    i, j;
	Buffer         *data, *positions;
	float          *points, *diff;
	int             num, nn, p, dmaxlen, imaxlen;
	double          val;
	int             dim1, index1[MAX_INDEX];
	int             dim2, index2[MAX_INDEX];
	char		tmp[6];

	/*-------< Load System Parameter >---------------*/
	data = GetSeries(0, &dim1, index1);
	val = GetScalar(1);
	num = (int) GetScalar(2);

	/*-------< Check Parameter >-----------------------*/
	if (data == NULL)
      return (17);
	if (num < 1)
      return (2);

	nn = IndexSize(dim1, index1);
	diff = (float *) emalloc(nn * sizeof(float));
	points = (float *) emalloc(nn * sizeof(float));
	if (diff == NULL || points == NULL)
      return (8);

	/*-------< Exection >----------------------------*/

	/* Sorting */
	for (i = 0; i < nn; i++)
		diff[i] = (float) fabs(data[i] - val);
    
	sort(diff, points, nn);

	/* Points to Positions */
	positions = AllocBuffer(num * dim1);
	for (i = 0; i < num; i++) {
		rIndex((int) points[i], index2, dim1, index1);
		for (j = 0; j < dim1; j++)
			positions[i * dim1 + j] = (Buffer) index2[j];
	}

	/* Caluculation of Pirint Width */
	imaxlen = dmaxlen = 0;
	for (i = 0; i < num; i++) {
		p = (int) points[i];
		sprintf(tmp, "%g", data[p]);
		if((unsigned int)dmaxlen < strlen(tmp))
			dmaxlen = strlen(tmp);

		rIndex(p, index2, dim1, index1);
		for (j = 0; j < dim1; j++) {
			sprintf(tmp, "%d", index2[j]);
			if((unsigned int)imaxlen < strlen(tmp))
				imaxlen = strlen(tmp);
		}
	}

	/* Print Value and Position */
	for (i = 0; i < num; i++) {
		p = (int) points[i];
		printf("\t DATA[ %*.7g ] -- POINT:", dmaxlen, data[p]);
		rIndex(p, index2, dim1, index1);
		for (j = 0; j < dim1; j++)
			printf("[%*d]", imaxlen, index2[j]);
		printf("\n")/*puts(" ")*/;
	}

	/* Return Object to SATELLITE Language */
	if (num == 1 && dim1 == 1) {
		ReturnScalar(positions[0]);
	} else {
		dim2 = 2;
		index2[0] = num;
		index2[1] = dim1;
		ReturnSeries(positions, dim2, index2);
	}

	/* Free Memory */
#if 0
	FreeBuffer(positions);
	FreeBuffer(data);
#endif
	efree(diff);
	efree(points);

	return 0;
}

#ifdef __cplusplus
}
#endif
