/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: header.cpp,v 1.2 2005/03/28 03:41:35 orrisroot Exp $ */

/**********************************************************
     file name : header.c

	Format ) HEADER FILENAME,TY
            TY : Operation
               = 0  : Print Only
               = 1  : Print & Modify

	                      Coded by Shigeru HITOMI
***********************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#define TWOBYTE  0
#define ONEBYTE  1
#define ONE_LINE 256

#ifdef __cplusplus
extern "C" {
#endif

static char *header_getstr(char *str,int siz){
  static char tmp[ONE_LINE];
  int len;
  printf("            ---------> ");
  syscom->console->tty_gets(tmp, ONE_LINE-1);
  len=strlen(tmp);
  tmp[len-1] = '\0';
  if(*tmp == '\0'){ strcpy(tmp,str); return tmp; }
  if(siz < len+1) return NULL;
  strcpy(str,tmp);
  return str;
}

static int header_getint(int n){
  char  str[ONE_LINE];
  printf("            ---------> ");
  syscom->console->tty_gets(str, ONE_LINE-1);
  str[strlen(str)-1] = '\0';
  return (*str != '\0') ? atoi(str) : n;
}

static double header_getreal(double d){
  char  str[ONE_LINE];
  printf("            ---------> ");
  syscom->console->tty_gets(str, ONE_LINE-1);
  return (*str != '\n') ? atof(str) : d;
}

static void modify_date(char *date, int onebyte){
  short int i, tmp[3];
  char      str[ONE_LINE];
  printf("            ---------> ");
  syscom->console->tty_gets(str, ONE_LINE-1);
  if (*str != '\n') {
    sscanf(str,"%4hd%*1c%2hd%*1c%2hd", tmp, tmp + 1, tmp + 2);
    if(onebyte) {
      date[0] = (char)(tmp[0]-1900);
      for(i=1;i<3;i++)
        date[i] = (char)tmp[i];
    } else {
      ((short *)date)[0] = tmp[0]-1900;
      for(i=1;i<3;i++)
        ((short *)date)[i] = tmp[i];
    }
  }
}

static void new_header(char *f_name, int modify){
  Header head;
  int    i;
  
  printf("   ****  NEW FILE TYPE ****\n");
  LoadHeader(f_name, &head);
  printf("   Byte order        : %s \n",
         (head.type_flag == SL2_DATAFILE_TYPE_BIGENDIAN) ? 
         "BigEndian" : "LittleEndian");
  printf("   Data size         : %d byte\n", head.data_size);
  printf("   Owner             : %s \n", head.opr_name);
  if(modify) strcpy(head.opr_name, header_getstr(head.opr_name, 19));
  printf("   Date              : %4d/%2d/%2d \n",
         head.date[0]+1900, head.date[1], head.date[2]);
  if(modify) modify_date(head.date, ONEBYTE);
  printf("   Comment           : %s \n", head.comment);
  if(modify) strcpy(head.comment, header_getstr(head.comment, 128));
  printf("   Sampling frequncy : %.1f [Hz]\n", head.samf);
  if(modify) head.samf = (float)header_getreal((float)head.samf);
  printf("   Dimension         : %d \n", head.dim);
  if(modify) head.dim = header_getint(head.dim);
  printf("   Index             : ");
  printf("[%d]", head.index[0]);
  for(i=1; i<head.dim; i++) {
    if(i==1) printf(" x ");
    printf("[%d]", head.index[i]);
  }
  printf("\n");
  if(modify) StoreHeader(f_name, &head);
}


static void old_header(char *f_name, int modify){
  h_type head;
  printf("   ****  OLD FILE TYPE ****\n");
  load_header(f_name, &head);
  printf("   FILE FORMAT       : %s Format\n",
	 (head.type_flag != 0) ? "MS-DOS" : "UNIX");
  printf("   DATA TYPE         : %s Data\n",
	 (head.data_flag != 0) ? "INTEGER" : "FLOAT");
  printf("   OWNER             : %s \n", head.opr_name);
  if(modify) strcpy(head.opr_name, header_getstr(head.opr_name, 19));
  printf("   DATE              : %2d/%2d/%2d \n",
	 head.date[0], head.date[1], head.date[2]);
  if(modify) modify_date((char*)head.date, TWOBYTE);
  printf("   COMMENT           : %s \n", head.comment);
  if(modify) strcpy(head.comment, header_getstr(head.comment, 256));
  printf("   SAMPLING FREQUNCY : %.1f [Hz]\n", head.samf);
  if(modify) head.samf = (float)header_getreal(head.samf);
  printf("   RECORD LENGTH     : %d [blocks/record] \n", head.rec_leng);
  if(modify) head.rec_leng = header_getint(head.rec_leng);
  printf("   TOTAL RECORDS     : %d [records]\n", head.rec_num);
  if(modify) head.rec_num = header_getint(head.rec_num);
  printf("   DATA POINTS       : %d [data/record] \n", head.data_num);
  if(modify) head.data_num = header_getint(head.data_num);
  if(modify) stor_header(f_name, &head);
}


DLLEXPORT int mod_system_header(){
  Header new_head;
  int     modify;
  char   *f_name;

  f_name = GetString(0);
  modify = (int)GetScalar(1);

  if(LoadHeader(f_name, &new_head) == -1){
    return (2);
  }
 switch(new_head.type_flag){
 case 0: 
 case 1:
   old_header(f_name, modify);
   break;
 default:
   new_header(f_name,modify);
   break;
 }
 return 0;
}

#ifdef __cplusplus
}
#endif
