/* 
 * Copyright (c) 2003-2005 RIKEN, Japan. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: help.cpp,v 1.1 2005/03/28 15:10:00 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#ifdef HAVE_WINDOWS_H
# include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#ifdef HAVE_IO_H
# include <io.h>
#endif

#include "SL_macro.h"
#include "SL_cmd.h"

#include "libsatellite.h"

#define CONSOLE(x) syscom->console->x
#ifndef _MAX_PATH
# ifdef  MAXPATHLEN
#  define _MAX_PATH  MAXPATHLEN
# else
#  define _MAX_PATH  1024
# endif
#endif

#ifdef WIN32
# define DIRSEP "\\"
# define R_OK 04
#else
# define DIRSEP "/"
#endif

#ifdef __cplusplus
extern "C" {
#endif

int procstack_regist(int pid); /* SYSTEM.cpp */

static int get_htmldir(char *buf, size_t len);
static int find_htmlfile(const char *cmd, char *buf, size_t len);
static int open_htmlfile(const char *file);

DLLEXPORT int mod_system_help(){
  char *cmd, buf[_MAX_PATH];
  int   argc, code;
  argc = GetArgNum();
  if(argc == 0)
    return 2; /* illegal parameter */
  cmd = GetString(0);
  if(cmd == NULL || *cmd=='\0')
    return 2; /* illegal parameter */
  code = find_htmlfile(cmd, buf, _MAX_PATH);
  switch(code){
  case -1: printf("reference html directory not found\n"); break;
  case -2: printf("not find keyword %s\n", cmd); break;
  case  0: /* found */
    if(open_htmlfile(buf) != 0)
      printf("web browser not found\n");
    break;
  }
  return 0;
}

static int get_htmldir(char *buf, size_t len){
#ifdef WIN32
  int i, slen;
  char var[_MAX_PATH];
  GetModuleFileName(NULL, var, _MAX_PATH);
  slen = (int)strlen(var);
  for(i=slen-1;i>0;i--){ if(var[i] == '\\'){ var[i]='\0'; break; } }
  if(var[i]=='\\') var[i]='\0';
  snprintf(buf, len, "%s\\doc\\reference-ja", var);
#else
  const char *docdir = SL4_DOC_DIR;
  const char *refdir = "reference-ja";
  snprintf(buf, len, "%s/%s", docdir, refdir);
#endif
  return 0;
}

static int find_htmlfile(const char *cmd, char *buf, size_t len){
  char dir[_MAX_PATH];
  if(get_htmldir(dir, _MAX_PATH) != 0)
    return -1; /* could not get html dir */
  snprintf(buf, len, "%s%sfunction_%s.html", dir, DIRSEP, cmd);
  if(access(buf, R_OK) != 0){
    memset(buf, 0, len);
    return -2; /* not found keyword */
  }
  return 0; 
}

static int open_htmlfile(const char *file){
#ifdef WIN32
  HINSTANCE hi;
  hi = ShellExecute(NULL, "open", file, NULL, NULL, SW_SHOWNORMAL);
  if((DWORD)hi <= 32)
    return -1;
  return 0;
#else
  char buf[_MAX_PATH], cmd[_MAX_PATH], **p;
  char *browser[] = {"mozilla", "firefox", "netscape", NULL};
  for(p = browser; *p!=NULL; p++){
    if(is_executable_command(*p, buf, _MAX_PATH) != 0){
      int pid, status, code;
      /* found */
      snprintf(cmd, _MAX_PATH, "%s \"%s\"", buf, file);
      pid = create_child_process(cmd, CONSOLE(ifd), CONSOLE(ofd), CONSOLE(efd),
                                 NULL);
      if(pid == -1)
        return -1; /* could not create process */
      procstack_regist(pid);
      return 0;
    }
  }
  /* not found */
  return -1;
#endif
}

#ifdef __cplusplus
}
#endif
