/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: merge.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#include <stdio.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/**************************************
*        buffer merge                 *
**************************************/
#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_merge(){
  register int    i, j, k, l;
  Buffer         *data1, *data2, *output;
  static int      dim1, index1[MAX_INDEX];
  static int      dim2, index2[MAX_INDEX];
  int             siz, aBlockSize;
  
  /***** Load System Parameter *****/
  data1 = GetSeries(0, &dim1, index1);
  data2 = GetSeries(1, &dim2, index2);
  if (data1 == NULL || data2 == NULL) 
    return (4);

  if (dim1 != dim2)
    return (19);

  if (!EqualIndex(SubIndex(index1), SubIndex(index2), dim1-1))
    return (24);

  aBlockSize = IndexSize(dim1 - 1, SubIndex(index1));
  if (aBlockSize == 0)
    aBlockSize = 1;
  siz = IndexSize(dim1, index1) + IndexSize(dim2, index2);
  if (( output = AllocBuffer(siz) ) == NULL )
    return (8);
  
  for (i = 0; i < index1[0]; i++) {
    for (j = 0; j < aBlockSize; j++) {
      k = i * aBlockSize + j;
      output[k] = data1[k];
    }
  }
  for (i = 0; i < index2[0]; i++) {
    for (j = 0; j < aBlockSize; j++) {
      k = (i + index1[0]) * aBlockSize + j;
      l = i * aBlockSize + j;
      output[k] = data2[l];
    }
  }
  index1[0] += index2[0];
  ReturnSeries(output, dim1, index1);
  return 0;
}

#ifdef __cplusplus
}
#endif
