/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: put.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

/*******************************
* Visual Process Command Lib.  *
* ( Extra Dimension Version )  *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : put            *
*    ( Ver 1.0 : 1993/03/09 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_put(){
  int idx[MAX_INDEX], idx2[MAX_INDEX];
  int idx3[MAX_INDEX], idx4[MAX_INDEX];
  int pos[MAX_INDEX], pos2[MAX_INDEX];
  int dim, dim2, dim3, dim_const, m, l, dpt, dpt2, i, st;
  Buffer  *x, *y, *z;

  if (( x = GetSeries( 0, &dim, idx ) ) == NULL )
    return (4);
  if (( z = GetSeries( 1, &dim3, idx3 ) ) == NULL ) {
    z = AllocBuffer(1);
    z[0] = GetScalar( 1 );
    dim3 = 1;
    idx3[0] = 1;
  }
  if (( y = GetSeries( 2, &dim2, idx2 ) ) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(2);
    idx2[0] = 1;
  }
  if ( idx2[0] != dim || dim3 > dim )
    return (16);

  for ( i = 0; i < dim; i++ )
    if ( ( idx4[i] = (int)y[i] ) >= idx[i] ) {
      return (7);
    }
  if ( dim3 != dim ) {
    idx3[dim-1] = idx3[dim3-1];
    for ( i = 0; i < (dim-dim3); i++ )
      idx3[i] = 1;
    dim3 = dim;
  }

  if ( dim == 1 ) {
    m = idx4[0]+idx3[0];
    if ( m > idx[0] ) 
      m = idx[0];
    for ( l = 0, i = idx4[0]; i < m; i++, l++ )
      x[ i ] = z[ l ];
  } else {
    dim_const = dim-1;

    m = ((idx4[dim_const]+idx3[dim_const]) > idx[dim_const] )? 
      ( idx[dim_const] - idx4[dim_const] ) : idx3[dim_const];

    for ( i = 0; i < dim; i++ ) {
      pos [i] = idx4[i];
      pos2[i] = 0;
    } 

    do {
      dpt  = Index( pos , dim , idx );
      dpt2 = Index( pos2, dim3, idx3 );
      st   = m + dpt;
      for ( l = dpt2, i = dpt; i < st; i++, l++ )
	x[ i ] = z[ l ];
      
      pos2[dim-2]++;
      pos [dim-2]++;
      
      for ( i = dim-2; i > 0; i-- )
	if ( pos2[i] >= idx3[i] || pos[i] >= idx[i] ) {
	  pos2[i-1]++;
	  pos [i-1]++;
	  pos [i] = idx4[i];
	  pos2[i] = 0;
	}
    } while ( pos2[0] < idx3[0] && pos[0] < idx[0] );
  }
  ReturnSeries( x, dim, idx );
  //FreeBuffer( x );
  //FreeBuffer( y );
  //FreeBuffer( z );
  return 0;
}

#ifdef __cplusplus
}
#endif
