/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: reform.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

/**********************************************************
     file name : reform.c
	                      Coded by Shigeru HITOMI
			               Keisuke TAKEBE
***********************************************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_reform(){
  int dim, dim2, len1, len2;
  int idx[MAX_INDEX], idx2[MAX_INDEX], idx3[MAX_INDEX];
  Buffer *x, *y, *xx, *yy, *newidx, *max;

  if (( x = GetSeries(0,&dim,idx) ) == NULL )
    return (4);

  if (( newidx = GetSeries(1, &dim2, idx2) ) == NULL ) {
    dim2 = 1;
    idx2[0] = 1;
    newidx = AllocBuffer( 1 );
    newidx[0]  = GetScalar(1);
  }

  {
    register int i;
    for ( i = 0; i < idx2[0]; i++ )
      idx3[i] = (int)newidx[i];
    len1 = IndexSize( dim , idx  );
    len2 = IndexSize( idx2[0], idx3 );

    if ( len2 == 0 ) 
      return (7);

    if ( len1 < len2 ) {
      if ( ( y = AllocBuffer( len2 ) ) == NULL )
	return (8);

      max = x +len1;
      for ( xx = x, yy = y; xx < max; xx++, yy++ )
	(*yy) = (*xx);
      max = y +len2;
      for ( yy = y+len1; yy < max; yy++ )
	(*yy) = 0.0;

      ReturnSeries( y, idx2[0], idx3 );
      //FreeBuffer(y);
    } else 
      ReturnSeries( x, idx2[0], idx3);

//    FreeBuffer(x);
    //FreeBuffer( newidx );
  }
  return 0;
}

#ifdef __cplusplus
}
#endif
