/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: rotate.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

/*******************************
* Visual Process Command Lib.  *
*       ( n-D Version )        *
*        Presented By K.Takebe *
********************************
********************************
*  Prog. Name : rotate         *
*    ( Ver 1.0 : 1993/03/17 )  *
*    ( Ver 1.1 : 1993/04/14 )  *
*    ( Ver 2.0 : 1993/08/25 )  *
*******************************/

#include <stdio.h>
#include <math.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_rotate(){
  Buffer *x, *y, *z, *xx, *zz, *m1, *m2, *max;
  int    idx[MAX_INDEX],idx2[MAX_INDEX], idx3[MAX_INDEX];
  int    dpt1, dim, dim2, dim_const;
  int    diff, pos[MAX_INDEX];
  int    i, l, m, max_size;

  if (( x = GetSeries( 0, &dim, idx ) ) == NULL )
    return (4);
  if (( y = GetSeries( 1, &dim2, idx2 ) ) == NULL ) {
    y = AllocBuffer(1);
    y[0] = GetScalar(1);
    idx2[0] = 1;
  }
  if ( dim != idx2[0] )
    return (24);

  for ( i = 0; i < dim; i++ ) {
    if ( abs( idx3[i] = (int)y[i] ) >= idx[i] )
      return (7);
    if ( idx3[i] < 0 )
      idx3[i] += idx[i];
  }

  dim_const = dim-1;
  l = idx [dim_const];
  m = idx3[dim_const];
  diff = l - m;

  max_size = IndexSize( dim, idx );
  if (( z = AllocBuffer( max_size ) ) == NULL )
    return (8);
  
  if ( dim == 1 ) {
    m1 = x + m;
    m2 = x + l;
    for ( zz = z, xx = m1; xx < m2; xx++, zz++ )
      (*zz) = (*xx);
    for ( zz = z+diff, xx = x; xx < m1; xx++, zz++ )
      (*zz) = (*xx);
  } else {
    for ( i = 0; i < dim; i++ ) {
      pos[i] = idx3[i];
    }
    max = z+max_size;
    for ( zz = z; zz < max; ) {
      dpt1 = Index( pos, dim, idx );
      m1 = x + dpt1;
      m2 = x + dpt1+diff;
      for ( xx = x+dpt1; xx < m2; xx++, zz++ )
	(*zz) = (*xx);
      for ( xx = x+dpt1-m; xx < m1; xx++, zz++ )
	(*zz) = (*xx);

      if ( dim > 1 ) {
	i = dim_const-1;
	pos[i]++;
	pos[i] %= idx[i];
	for ( i = dim_const-1; i > 0 && pos[i] == idx3[i]; i-- ) {
	  pos[i-1]++;
	  pos[i-1] %= idx[i-1];
	}
      }
    }
  }
  ReturnSeries( z, dim, idx );
#if defined(_DEBUG)
  FreeBuffer( z );
  FreeBuffer( x );
  FreeBuffer( y );
#endif
  return 0;
}

#ifdef __cplusplus
}
#endif
