/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: thin.cpp,v 1.1.1.1 2004/03/31 08:15:06 orrisroot Exp $ */

#include <stdio.h>
#include <math.h>
#include <string.h>
#include "SL_macro.h"
#include "SL_cmd.h"

/******************************************
*      thin  B1,B2,I                      *
*            B1 : INPUT BUFFER            *
*            I  : INTERVAL                *
*					  *
*	     Coding by I.Akagi            *
*		~~~     1991.Oct.22th	  *
*            Modified by K.Takebe         *
*			1993, 4,16	  *
*******************************************/

#ifdef __cplusplus
extern "C" {
#endif

DLLEXPORT int mod_system_thin(){
  Buffer *data, *Data, *dat, *Dat, *max, *step;
  int j, dpt, dpt2, i, k, st;
  int dim1, index1[MAX_INDEX], dim2, index2[MAX_INDEX];
  int dim3, index3[MAX_INDEX];
  
  /*** Read Data ***/
  if (( data = GetSeries( 0, &dim1, index1 ) ) == NULL )
    return (4);
  if ( dim1 > 0 ) {
    if (( step = GetSeries( 1, &dim3, index3 )) == NULL ) {
      step = AllocBuffer(1);
      step[0] = GetScalar(1);
      dim3 = 1;
      index3[0] = 1;
    }
    if ( dim1 != index3[0] )
      return (16);

    for ( i = 0; i < index3[0]; i++ ) {
      if ( (int)step[i]  == 0 )
	step[i] = 1.0;
      else if ( (int)step[i] < 0 || (int)step[i] >= index1[i] ) {
	return (2);
      }
      index2[i] = ( index1[i] + (int)step[i]-1 )/(int)step[i];
    }
    dim2 = dim1;
  } else
    return (16);

  for ( i = 0; i < index3[0]; i++ )
    printf("[%d]",index1[i]);
  printf("->");
  for ( i = 0; i < index3[0]; i++ )
    printf("[%d]",index2[i]); 
  printf("\n");

  dpt  = IndexSize( dim1, index1 );
  dpt2 = IndexSize( dim2, index2 );

  if ((Data = AllocBuffer( dpt2 )) == NULL )
    return (8);

  st = (int)step[dim1-1];
  k = index2[dim1-1];
  for ( Dat = Data, i = 0; i < dpt2; i+= k ) {
    rIndex( i, index3, dim1, index2 );
    for ( j = 0; j < dim1-1; j++ )
      index3[j] *= (int)step[j];
    dat = data+Index(index3,dim1,index1);
    max = dat+index1[dim1-1];
    for( ; dat < max; dat+= (int)st , Dat++ ) {
      *Dat = *dat;
    }
  }    

  ReturnSeries( Data, dim2, index2 );

  FreeBuffer( step );
  FreeBuffer( Data );
  FreeBuffer( data );
  return 0;
}

#ifdef __cplusplus
}
#endif
