/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: bm.h,v 1.2 2004/04/09 02:17:51 orrisroot Exp $ */
/*
 * bm.h
 *
 * Copyright (c) 2002 by DSP Technology Co.,Ltd. All Rights Reserved.
 * $Revision: 1.1.1.1 $
 *
 */

/////////////////////////////////////////////////////////////////////////////
// BufferMonitor class

class BufferMonitor
{
  // constructor and destructor
public:
  BufferMonitor();
  ~BufferMonitor();

  // attribute
public:
  // method of foreground background colors configuration

  // operation
public:
  BOOL  Init(int win, char *title, int index, double *x);
  BOOL  Update(int win, char *title, int index, double *x);
  BOOL  InitRegWin( HINSTANCE hCurInst );
  BOOL  InitCreateWin( int win, 
                       HINSTANCE hCurInst, int iCmdShow );
  void  Display(HWND hwnd, HDC hdc);

  // member variables
public:
  int       m_index;
  double   *m_buffer;
  HANDLE    m_hThread;
  HWND      m_hChild;
  char      m_title[128];
  HDC       m_hdc;
  HINSTANCE m_hinst;
  char      m_ymax[32];
  char      m_ymin[32];
  int       m_autoscale;
  int       m_lwidth;
};
