/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: sprintf.cpp,v 1.1.1.1 2004/03/31 08:15:05 orrisroot Exp $ */

#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "SL_macro.h"
#include "SL_cmd.h"

#ifdef __cplusplus
extern "C" {
#endif

static char* _check_param(char *format, char *fmt, int *type );

DLLEXPORT int slutil_sprintf(){
  int i, max_arg, dim, index[MAX_INDEX], type;
  int dat;
  char   *format, *p, fmt[128], *string, res[256], plate[1024];
  Buffer param, *temp;

  max_arg = GetArgNum();
  p = format = GetString(0);

  plate[0] = '\0';
  for ( i = 1; i < max_arg; i++ ) {
    p = _check_param( p, fmt, &type );
    switch( type ) {
    case 0:
    case 2:
      if (( temp = GetSeries(i,&dim,index)) != NULL ) {
	param = temp[0];
      } else {
	param = GetScalar(i);
      }
      if ( type == 2 ) {
	dat = (int)param;
	sprintf( res, fmt, dat );
      } else {
	sprintf( res, fmt, param );
      }
      break;
    case 1:
      string = GetString(i);
      sprintf( res, fmt, string );
      break;
    }
    strcat( plate, res );
  }
  ReturnString( plate );
  return 0;
}

static char* _check_param(char *format, char *fmt, int *type ){
  register int	i = 0;
  char	*p;
  p = format;

  while ( *p != '%' && *p != '\0' )
    fmt[i++] = *p++;
  if ( *p != '\0' ) {
    fmt[i++] = *p++;	/* % */
    if(*p == '-')
      fmt[i++] = *p++;
    while(isdigit(*p) || *p == '.')
      fmt[i++] = *p++;
    switch(*p){
    case 'l':
      fmt[i++] = *p++; /* break through*/
    case 'e':
    case 'f':
    case 'g':
    case 'd':
    case 's':
    case 'c':
    case 'x':
      *type = 0;
      if ( *p == 's' || *p == 'c' )
	*type = 1;
      else if ( *p == 'x' || *p == 'd' )
	*type = 2;
      fmt[i++] = *p++;
      break;
    default:
      fmt[i++] = *p++;
    }
    while ( *p != '%' && *p != '\0' )
      fmt[i++] = *p++;
    fmt[i] = '\0';
  }
  return p;
}

#ifdef __cplusplus
}
#endif
