/* 
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: terminal.h,v 1.2 2005/03/01 14:30:58 orrisroot Exp $ */

#ifndef WIN32

#ifndef __SL4_TERMINAL_H__
#define __SL4_TERMINAL_H__

#include  <stdio.h>

#define SL4_KEYPAD_UP     0x0100
#define SL4_KEYPAD_DOWN   0x0200
#define SL4_KEYPAD_RIGHT  0x0300
#define SL4_KEYPAD_LEFT   0x0400
#define SL4_KEYPAD_HOME   0x0500
#define SL4_KEYPAD_END    0x0600

#define TTY_MODE_NORMAL 0
#define TTY_MODE_RAW    1
#define TTY_MODE_COOK   2
#define TTY_MODE_QUOTE  3

#ifdef __cplusplus
extern "C" {
#endif

int   sl4_tty_setmode(int mode);
int   sl4_term_init(FILE *fin, FILE *fout, FILE *ferr);
int   sl4_term_quit();
int   sl4_term_putc(int c);
int   sl4_term_puts(const char *str);
int   sl4_term_getc();
int   sl4_term_keypad_getc();
char *sl4_term_gets(char *buf, int size);
int   sl4_term_cursor_up(int y);
int   sl4_term_cursor_down(int y);
int   sl4_term_cursor_right(int x);
int   sl4_term_cursor_left(int x);
int   sl4_term_cursor_bol();
int   sl4_term_cursor_newline();
int   sl4_term_cursor_invisible();
int   sl4_term_cursor_normal();
int   sl4_term_bell();
int   sl4_term_vbell();
int   sl4_term_attr_normal();
int   sl4_term_attr_bold();
int   sl4_term_attr_underline();
int   sl4_term_attr_reverse();
int   sl4_term_clear_screen();
int   sl4_term_clear_eol(int xpos);
int   sl4_term_getmaxyx(int *y, int *x);

#ifdef __cplusplus
}
#endif

#endif /* __SL4_TERMINAL_H__ */

#endif /* WIN32 */
