@echo off

rem
rem  Build tools directory configuration
rem
rem  $Id: tools.bat,v 1.3 2005/03/03 13:40:13 orrisroot Exp $
rem 

rem
rem check 'SL4TOOLSDIR' environment variable
rem

:CheckSL4TOOLS

set PWD=%cd%
cd %~p0\..\..\tools
set SL4TOOLSDIR=%cd%
cd %PWD%
set PWD=

set PATH=%SL4TOOLSDIR%\bin;%PATH%

rem
rem bison 1.875 - GNU Project parser generator (Yacc replecement)
rem

set BISON=%SL4TOOLSDIR%\bin\bison.exe

rem
rem flex 2.5.4a - Fast lexical analyzer generator
rem

set FLEX=%SL4TOOLSDIR%\bin\flex.exe

rem
rem sed 4.0.9 - A Stream Editor
rem

set SED=%SL4TOOLSDIR%\bin\sed.exe

rem
rem ----------- Don't edit under this lines ----------
rem

rem
rem Check buiild tools
rem

rem
rem bison
rem

if not exist %BISON% goto BisonNotFound

rem
rem flex
rem

if not exist %FLEX% goto FlexNotFound

rem
rem sed
rem

if not exist %SED% goto SedNotFound


:AllCheckingPass
exit /b 0

:NoSL4TOOLS
echo Error: SL4TOOLSDIR environment variable is not defined.
exit /b 1

:NoSL4TOOLSDIR
echo Error: build tools directory not found.
exit /b 1

:BisonNotFound
echo Error: build tools 'bison' not found : %BISON%
exit /b 1

:FlexNotFound
echo Error: build tools 'flex' not found : %FLEX%
exit /b 1

:SedNotFound
echo Error: build tools 'sed' not found : %SED%
exit /b 1

