/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: BlockView.h,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#if !defined(AFX_BLOCKVIEW_H__3840F1C0_4357_4557_A4CD_0FA93EFF4ADE__INCLUDED_)
#define AFX_BLOCKVIEW_H__3840F1C0_4357_4557_A4CD_0FA93EFF4ADE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CBlockView r[

class CBlockView : public CListView
{
protected:
	CBlockView();           // IɎgpveNg RXgN^
	DECLARE_DYNCREATE(CBlockView)

// Agr[g
public:
	int	m_nSelectedItem;

// Iy[V
public:
	int Refresh (int group/*LPCTSTR pszPath*/);
	CImageList * m_DragImage;
private:
	void ModuleAppend(MODULEINFO* pItem);
	int GetGroupIndex(CString group);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(CBlockView)
	public:
	virtual void OnInitialUpdate();
	protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	virtual ~CBlockView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// ꂽbZ[W }bv֐
protected:
	CPoint m_OfsCursor2Icon;
	int m_iItemDrag;
	BOOL m_bImageList;
	void ClearImageList();
	void FreeItemMemory();
	BOOL AddItem (int nIndex, BLOCKINFO *pItem);
	int RefreshCell (LPCTSTR pszPath);
	int RefreshSynapse (LPCTSTR pszPath);
	int RefreshGap (LPCTSTR pszPath);
	int RefreshIo (LPCTSTR pszPath);
	int RefreshMath (LPCTSTR pszPath);	int m_moduleType;
	BYTE * GetBitmapBits( void *bitmap );
	void * LoadBitmapFile(LPCTSTR lpszPathName, DWORD *bfOffBits);
	void InitialImagelist();
	CImageList * m_pImageList;
	CBitmap * m_pBitmap[MAX_BITMAP_IMAGE];
	//{{AFX_MSG(CBlockView)
	afx_msg void OnDestroy();
	afx_msg void OnGetdispinfo(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnBegindrag(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnModelDelete();
	afx_msg void OnUpdateModelDelete(CCmdUI* pCmdUI);
	afx_msg void OnModelEdit();
	afx_msg void OnUpdateModelEdit(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_BLOCKVIEW_H__3840F1C0_4357_4557_A4CD_0FA93EFF4ADE__INCLUDED_)
