/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CodeComp.cpp,v 1.3 2004/07/16 09:36:16 yoshihiko Exp $ */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "ScopeWnd.h"
#include "SubsysDoc.h"
#include "SubsysWnd.h"
#include "SubsysView.h"
#include "ModelDoc.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
#include <io.h>
#include <direct.h>
#include "libsatellite.h"
//
//O[o
extern CExtncsMain* g_pExtncsMain;

BOOL CALLBACK EnumChildProc(HWND hwndChild, LPARAM lParam) 
{
	char szWindowName[256];

	// EBhEeLXg̎擾
	GetWindowText(hwndChild, szWindowName, sizeof(szWindowName));
    // Make sure the child window is visible. 
	if(szWindowName[0] != '\0') { 
	    //ShowWindow(hwndChild, SW_SHOW);
		if(strcmp(szWindowName, "ConsoleViewer") == NULL) {
			//ret = ::SetForegroundWindow(hwndChild);
			//hPrevWnd = ::SetActiveWindow(hwndChild);
	    //ShowWindow(hwndChild, SW_SHOW);
			//SetFocus(hwndChild);
			::PostMessage(hwndChild, CONSOLE_ACTIVE, 0, 0L);
		}
	}
 
    return TRUE; 
} 

BOOL CExtncsDoc::CodeCompile() 
{
	char	modelpath[_MAX_PATH];
	char	scriptpath[_MAX_PATH];
	char	modelname[_MAX_PATH];
	char	*cptr;
	char	slfile[_MAX_PATH];
	FILE	*fp;
	int		i,ch,len;
	DWORD	size;
	const char* tmpdir;
	char	tmppath[_MAX_PATH];

	//CConsoleViewergbv
	//AfxGetMainWnd()->PostMessage(CONSOLE_ACTIVE, 0, 0L);
	AfxGetMainWnd()->SetActiveWindow();

	//e|쐬
	tmpdir = get_tmpdir();
	if(GetShortPathName(tmpdir, tmppath, _MAX_PATH) == NULL)
		strcpy(tmppath, tmpdir);

	//Jgmdlt@C݂Ă邩
#if 0
	strcpy(modelpath, m_ExtncsName);
	cptr = strstr(modelpath, ".sig");
	if(!cptr) {
		AfxMessageBox("Extncs not exist.",MB_OK, NULL);
		return FALSE;
	}
	*cptr = '\0';
	strcat(modelpath, ".mdl");
	_splitpath(modelpath, NULL, NULL, modelname, NULL);
	if(_access(modelpath, 0) == -1) {
		AfxMessageBox("Model not exist.",MB_OK, NULL);
		return FALSE;
	}
#else
	strcpy(modelpath, tmppath);
	strcat(modelpath, "\\");
	strcpy(modelname, m_ModelName/*m_ExtncsName*/);
	cptr = strstr(modelname, ".sig");
	*cptr = '\0';
	strcat(modelpath, modelname);
	strcat(modelpath, ".mdl");
	if(_access(modelpath, 0) == -1) {
		AfxMessageBox("Model not exist.",MB_OK, NULL);
		return FALSE;
	}
#endif
	
	//NPPs
#if 0
	strcpy(scriptpath, modelpath);
	cptr = strstr(scriptpath, ".mdl");
	*cptr = '\0';
	strcat(scriptpath, ".sl");
	fp = fopen(scriptpath, "w");
	fprintf(fp,"nassign(\"%s\")\n",modelname);
	fprintf(fp,"npp()\n");
	fprintf(fp,"nlink()\n");
	fclose(fp);
#else
	sprintf(scriptpath, "%s/%s.sl",tmppath,modelname);
	fp = fopen(scriptpath, "w");
	if(!fp) {
		AfxMessageBox("Script error.",MB_OK, NULL);
		return FALSE;
	}
	fprintf(fp,"nassign(\"%s\")\n",modelname);
	fprintf(fp,"npp()\n");
	//e[uȂǂ̖ߍ
	ModifyTableModule( fp );
	fprintf(fp,"nlink()\n");
	fclose(fp);
#endif

	//inline߂ɂĔM
#if 0
	strcpy(slfile, "inline(\"");
	strcat(slfile, modelname);
	strcat(slfile, ".sl");
	strcat(slfile, "\")\n");
#else
	//sprintf(slfile, "inline(\"%s/%s.sl\")\n",tmppath,modelname);
	sprintf(slfile, "inline(\"%s.sl\")\n",modelname);
#endif
	//RpC󋵂OutViewɕ\
	//A command is transmitted. 
	_chdir(tmpdir);
	len = (int)strlen(slfile);
	for(i=0; i<len; i++){
		ch = (unsigned char)slfile[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
		if(slfile[i] == '\\') {
			WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
		}
	}

#if 0
	//NLINKs
	sprintf(scriptpath, "%s/%s.sl",tmppath,modelname);
	fp = fopen(scriptpath, "w");
	if(!fp) {
		AfxMessageBox("Script error.",MB_OK, NULL);
		return FALSE;
	}
	fprintf(fp,"nlink()\n");
	fclose(fp);
	//inline
	sprintf(slfile, "inline(\"%s.sl\")\n",modelname);
	//A command is transmitted. 
	len = (int)strlen(slfile);
	for(i=0; i<len; i++){
		ch = (unsigned char)slfile[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
		if(slfile[i] == '\\') {
			WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
		}
	}
#endif

	return TRUE;
}

void CExtncsDoc::ModifyTableModule(FILE* fp)
{
	CWidget* pWidget;
	int nCount,id,i, nParam;
	CPtrArray*	p;
	PARAMINFO *pItem;

	nCount = (int)m_arrWidgets.GetSize ();
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) m_arrWidgets[i];
		id = pWidget->GetId();
		if(id == M_SHELL) {
			p = pWidget->GetParamPointer();
			nParam = (int)p->GetSize();
			if(nParam == 1) {
				pItem = (PARAMINFO*) p->GetAt (0);
				fprintf(fp,"nrtclk(\"T\",\"%s\",\"%s\")\n",pWidget->GetName(), pItem->strValue);
			}
		}
		if(id == M_SUBSYSTEM) {	// Subsystem
			ModifyTableModuleSubsystem(fp, pWidget);
		}
	}
}

// SubsytemT[`
void CExtncsDoc::ModifyTableModuleSubsystem(FILE* fp, CWidget* pTargetWidget)
{
	CString str,strSubname,name;
	char buf[_MAX_PATH];
	CPtrArray* pArrWidgets;
	CWidget* pWidget;
	int i,id,nCount,nParam;
	CPtrArray*	p;
	PARAMINFO *pItem;

	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	nCount = (int)pArrWidgets->GetSize();
	if(!nCount)
		return;

	// ͂
	// SubsysteḿASɃxt
	// ŁAႦS1AS2
	// x́AŏWidget擾
	pWidget = (CWidget*)pArrWidgets->GetAt(0);
	sprintf(buf,"S%d_", pWidget->GetLevel());
	strSubname = _T(buf);
	// Cell
	for(i = 0; i < nCount; i++) {
		pWidget = (CWidget*) pArrWidgets->GetAt(i);
		id = pWidget->GetId();
		if(id == M_SHELL) {
			p = pWidget->GetParamPointer();
			nParam = (int)p->GetSize();
			if(nParam == 1) {
				pItem = (PARAMINFO*) p->GetAt (0);
				fprintf(fp,"nrtclk(\"T\",\"%s\",\"%s\")\n",strSubname+pWidget->GetName(), pItem->strValue);
			}
		}
		if(id == M_SUBSYSTEM) {	// Subsystem
			ModifyTableModuleSubsystem(fp, pWidget);
		}
	}
}


