/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ColorEdit.cpp,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"
#include "ColorEdit.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CColorEdit

CColorEdit::CColorEdit()
{
	//
	m_hBrBack =  NULL;
	//ftHg̐Fݒ
	SetColors(RGB(0,0,0),RGB(255,255,255));
}

CColorEdit::~CColorEdit()
{
	//wiuV폜
	if(m_hBrBack != NULL) {
		::DeleteObject(m_hBrBack);
	}
}

void CColorEdit::SetColors(COLORREF fore,COLORREF back)
{
	//oϐݒ
	m_fore = fore;
	m_back = back;
	//wiuV폜
	if(m_hBrBack != NULL) {
		::DeleteObject(m_hBrBack);
	}
	//wiuVݒ
	m_hBrBack = ::CreateSolidBrush(back);
}

void CColorEdit::GetColors(COLORREF& fore,COLORREF& back)
{
	fore = m_fore;
	back = m_back;
}


BEGIN_MESSAGE_MAP(CColorEdit, CEdit)
	//{{AFX_MSG_MAP(CColorEdit)
	ON_WM_CTLCOLOR_REFLECT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorEdit bZ[W nh

HBRUSH CColorEdit::CtlColor(CDC* pDC, UINT nCtlColor) 
{
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	pDC->SetTextColor(m_fore);	//OiF̕ύX
	pDC->SetBkColor(m_back);	//wiF̕ύX
	return m_hBrBack;		//wiuVԂ

	// TODO: enhĂяoȂꍇ͂ŃuṼnhƂ NULL ȊOԂ悤ɂĂ
//	return NULL;
}

void CColorEdit::Print(const char *str)
{
	CString strout;

	strout = _T(str);
	strout += _T("\r\n");
	SetSel(-1, -1);
	ReplaceSel(strout);
}
/////////////////////////////////////////////////////////////////////////////
// CColorStatic

CColorStatic::CColorStatic()
{
	//
	m_hBrBack = NULL;
	//ftHgF
	SetColors(RGB(0,0,0), GetSysColor(COLOR_MENU));
}

CColorStatic::~CColorStatic()
{
	//wiuV폜
	if(m_hBrBack != NULL) {
		::DeleteObject(m_hBrBack);
	}
}

void CColorStatic::SetColors(COLORREF fore, COLORREF back)
{
	//oϐݒ
	m_fore = fore;
	m_back = back;

	if(m_hBrBack != NULL) {
		::DeleteObject(m_hBrBack);
	}
	//wiuVݒ
	m_hBrBack = ::CreateSolidBrush(back);
	//if(m_hwnd)	InvalidateRect(NULL);
}

void CColorStatic::GetColors(COLORREF& fore, COLORREF& back)
{
	fore = m_fore;
	back = m_back;
}

BEGIN_MESSAGE_MAP(CColorStatic, CStatic)
	//{{AFX_MSG_MAP(CColorStatic)
	ON_WM_CTLCOLOR_REFLECT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorStatic bZ[W nh

HBRUSH CColorStatic::CtlColor(CDC* pDC, UINT nCtlColor) 
{
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	pDC->SetTextColor(m_fore);
	pDC->SetBkColor(m_back);
	return m_hBrBack;
	// TODO: enhĂяoȂꍇ͂ŃuṼnhƂ NULL ȊOԂ悤ɂĂ
	//return NULL;
}
/////////////////////////////////////////////////////////////////////////////
// CColorComboBox

CColorComboBox::CColorComboBox()
{
	//
	m_hBrBack =  NULL;
	//ftHg̐Fݒ
	SetColors(RGB(0,0,0),RGB(255,255,255));
}

CColorComboBox::~CColorComboBox()
{
	//wiuV폜
	if(m_hBrBack != NULL) {
		::DeleteObject(m_hBrBack);
	}
}

void CColorComboBox::SetColors(COLORREF fore,COLORREF back)
{
	//oϐݒ
	m_fore = fore;
	m_back = back;
	//wiuV폜
	if(m_hBrBack != NULL) {
		::DeleteObject(m_hBrBack);
	}
	//wiuVݒ
	m_hBrBack = ::CreateSolidBrush(back);
}

void CColorComboBox::GetColors(COLORREF& fore,COLORREF& back)
{
	fore = m_fore;
	back = m_back;
}

BEGIN_MESSAGE_MAP(CColorComboBox, CComboBox)
	//{{AFX_MSG_MAP(CColorComboBox)
	ON_WM_CTLCOLOR_REFLECT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorComboBox bZ[W nh

HBRUSH CColorComboBox::CtlColor(CDC* pDC, UINT nCtlColor) 
{
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	pDC->SetTextColor(m_fore);
	pDC->SetBkColor(m_back);
	return m_hBrBack;
	
	// TODO: enhĂяoȂꍇ͂ŃuṼnhƂ NULL ȊOԂ悤ɂĂ
	//return NULL;
}

/////////////////////////////////////////////////////////////////////////////
// CColorSpinButton

CColorSpinButton::CColorSpinButton()
{
}

CColorSpinButton::~CColorSpinButton()
{
}


BEGIN_MESSAGE_MAP(CColorSpinButton, CSpinButtonCtrl)
	//{{AFX_MSG_MAP(CColorSpinButton)
	ON_WM_CTLCOLOR_REFLECT()
	ON_WM_NCHITTEST()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorSpinButton bZ[W nh

void CColorSpinButton::SetColors(COLORREF fore,COLORREF back)
{
	//oϐݒ
	m_fore = fore;
	m_back = back;
	//wiuV폜
	if(m_hBrBack != NULL) {
		::DeleteObject(m_hBrBack);
	}
	//wiuVݒ
	m_hBrBack = ::CreateSolidBrush(back);
}

void CColorSpinButton::GetColors(COLORREF& fore,COLORREF& back)
{
	fore = m_fore;
	back = m_back;
}

HBRUSH CColorSpinButton::CtlColor(CDC* pDC, UINT nCtlColor) 
{
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	pDC->SetTextColor(m_fore);
	pDC->SetBkColor(m_back);
	return m_hBrBack;
	
	// TODO: enhĂяoȂꍇ͂ŃuṼnhƂ NULL ȊOԂ悤ɂĂ
	//return NULL;
}

UINT CColorSpinButton::OnNcHitTest(CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	return CSpinButtonCtrl::OnNcHitTest(point);
}

