/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Extncs.cpp,v 1.5 2004/09/03 10:11:05 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "ScopeView.h"
#include "ScopeWnd.h"
#include "SubsysDoc.h"
#include "SubsysWnd.h"
#include "SubsysView.h"
#include "ExtncsWnd.h"
#include "ExtncsDoc.h"
#include "ExtncsView.h"
#include "ModelWnd.h"
#include "ModelDoc.h"
#include "ModelView.h"
#include "ExtncsMain.h"
#include "ScopeList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CSingleDocTemplate* g_pExtncsTemplate;
CSingleDocTemplate* g_pModelTemplate;
CMultiDocTemplate* g_pScopeTemplate;
CMultiDocTemplate* g_pSubsysTemplate;
CExtncsMain*	g_pExtncsMain = NULL;
CSingleDocTemplate* g_pXyTemplate;

#include "afxdllx.h"    // standard MFC Extension DLL routines

static AFX_EXTENSION_MODULE NEAR extensionDLL = { NULL, NULL };

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		// Extension DLL one-time initialization.
		if (!AfxInitExtensionModule(extensionDLL, hInstance))
		   return 0;

		// Other initialization could be done here, as long as
		// it doesn't result in direct or indirect calls to AfxGetApp.
		// This extension DLL needs to add doc templates to the
		// app object, so it waits for the application to boot
		// and call an initialization function (see below).
	}

   else if (dwReason == DLL_PROCESS_DETACH)
   {
	   if(g_pExtncsMain) {
			g_pExtncsMain->UpdateBlockFile();
			g_pExtncsMain->SetBlockClear();
			delete g_pExtncsMain;
	   }
	   return 0;
   }
	return 1;   // ok
}

#ifdef __cplusplus
extern "C" {
#endif

// Exported DLL initialization is run in context of running application
//extern "C" void WINAPI ExtncsInit()
__declspec(dllexport) void ExtncsInit(CWinApp* pWinApp)
{
	// create a new CDynLinkLibrary for this app
	new CDynLinkLibrary(extensionDLL);

	// Register the doc templates we provide to the app
	CWinApp* pApp = pWinApp/*AfxGetApp()*/;
	ASSERT(pApp != NULL);
	//ExtncsAL[LeN`
	g_pExtncsTemplate = new CSingleDocTemplate(
		IDR_EXTNCS,
		RUNTIME_CLASS(CExtncsDoc),
		RUNTIME_CLASS(CExtncsWnd), // JX^ MDI qt[
		RUNTIME_CLASS(CExtncsView));
	pApp->AddDocTemplate(g_pExtncsTemplate);
	//ModelAL[LeN`
	g_pModelTemplate = new CSingleDocTemplate(
		IDR_MODEL,
		RUNTIME_CLASS(CModelDoc),
		RUNTIME_CLASS(CModelWnd),
		RUNTIME_CLASS(CModelView));
	pApp->AddDocTemplate(g_pModelTemplate);
	//SubsysAL[LeN`
	g_pSubsysTemplate = new CMultiDocTemplate(
		/*IDR_SUBSYS*/IDR_EXTNCS,
		RUNTIME_CLASS(CSubsysDoc),
		RUNTIME_CLASS(CSubsysWnd),
		RUNTIME_CLASS(CSubsysView));
	pApp->AddDocTemplate(g_pSubsysTemplate);

	// add other initialization here
}

//extern "C" BOOL WINAPI ExtncsExec()
__declspec(dllexport) BOOL ExtncsExec(CWinApp* pWinApp, CView* pView, HANDLE hStdinW)
{
	//@Cf[^ێNX
	g_pExtncsMain = new CExtncsMain();
	g_pExtncsMain->SetBlockData();

	//AfxMessageBox("ExtncsExec1.", MB_OK, NULL);
	// set pApp and pView
	g_pExtncsMain->m_pApp = pWinApp;
	g_pExtncsMain->m_pConsoleView = pView;
	g_pExtncsMain->m_hStdinW = hStdinW;
	//c[{bNX̕\
	CModelDoc*	pModelDoc;
	CModelWnd*	pModelWnd;
	pModelDoc = (CModelDoc *)g_pModelTemplate->CreateNewDocument();
	if(pModelDoc) {
		//lȂ
		//pDocument->m_pTtyWnd = this;
		g_pExtncsMain->m_pModelDoc = pModelDoc;
	}
	else {	// error
		AfxMessageBox("create Extncs error 1.", MB_OK, NULL);
		return FALSE;
	}
	pModelWnd = (CModelWnd *)g_pModelTemplate->CreateNewFrame(pModelDoc, NULL);
	if(pModelWnd) {
		g_pModelTemplate->InitialUpdateFrame(pModelWnd, pModelDoc, TRUE);
		//if(!m_pModelWnd) {
		//	m_pModelWnd = pWnd;
		//}
	}
	else {	// error
		AfxMessageBox("create model error 2.", MB_OK, NULL);
		return FALSE;
	}

	//AfxMessageBox("ExtncsExec2.", MB_OK, NULL);
	//VXe\zEBhE\
	CExtncsDoc*	pExtncsDoc;
	CExtncsWnd*	pExtncsWnd;
	pExtncsDoc = (CExtncsDoc *)g_pExtncsTemplate->CreateNewDocument();
	if(pExtncsDoc) {
		//lȂ
		//pExtncsDoc->m_pTtyWnd = this;
		g_pExtncsMain->m_pExtncsDoc = pExtncsDoc;
	}
	else {	// error
		AfxMessageBox("ceate Extncs error.", MB_OK, NULL);
		return FALSE;
	}
	pExtncsWnd = (CExtncsWnd *)g_pExtncsTemplate->CreateNewFrame(pExtncsDoc, NULL);
	if(pExtncsWnd) {
		g_pExtncsTemplate->InitialUpdateFrame(pExtncsWnd, pExtncsDoc, TRUE);
		g_pExtncsMain->m_pExtncsWnd = pExtncsWnd;
	}
	else {	// error
		AfxMessageBox("ceate Extncs error.", MB_OK, NULL);
		return FALSE;
	}

	return TRUE;
}
#ifdef __cplusplus
}
#endif


