/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ExtncsMain.cpp,v 1.3 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "ScopeWnd.h"
#include "SubsysDoc.h"
#include "SubsysWnd.h"
#include "SubsysView.h"
#include "ModelDoc.h"
#include "ExtncsDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
#define  __IMPORTSYMBOL__
#include "libsatellite.h"
#undef   __IMPORTSYMBOL__

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CExtncsMain::CExtncsMain()
{
	int	i,nCount,j,siz;
	BLOCKINFO* pInfo;
	NAMEINFO* nInfo;

	// m_blockArraym_paramArray폜
	nCount = (int)m_blockArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pInfo =  (BLOCKINFO*) m_blockArray.GetAt (i);
			siz = (int)pInfo->inpname.GetSize();
			if(siz) {
				for(j = 0; j < siz; j++) {
					nInfo =  (NAMEINFO*) pInfo->inpname.GetAt (j);
					delete nInfo;
				}
				pInfo->inpname.RemoveAll();
			}
			siz = (int)pInfo->outpname.GetSize();
			if(siz) {
				for(j = 0; j < siz; j++) {
					nInfo =  (NAMEINFO*) pInfo->outpname.GetAt (j);
					delete nInfo;
				}
				pInfo->outpname.RemoveAll();
			}
			delete pInfo;
		}
		m_blockArray.RemoveAll();
	}
	//ϐf[^x[Xp
	nCount = (int)m_varArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (VARINFO*) m_varArray.GetAt (i);
		m_varArray.RemoveAll();
	}

	m_nFormat = ::RegisterClipboardFormat (_T ("Widget"));

}

CExtncsMain::~CExtncsMain()
{
	// m_nDefaultSizem_blockArraỹTCYƈقȂꍇblock.ini
	// XV
	if(m_nDefaultSize != m_blockArray.GetSize())
	UpdateBlockFile();
	// m_blockArraym_paramArray폜
	SetBlockClear();
}

//ǉCfbNX擾
int CExtncsMain::GetModuleIndex()
{
	int nCount,i,index=0;
	BLOCKINFO* pInfo;

	nCount = (int)m_blockArray.GetSize();
	for (i=0; i<nCount; i++) {
		pInfo = (BLOCKINFO*) m_blockArray.GetAt (i);
		if(pInfo->nBitmap < nCount) {
			index++;
		}
	}
	return index;
}

void CExtncsMain::UpdateBlockFile()
{
	FILE *fp;
	char path[_MAX_PATH],fname[_MAX_PATH];
	int nCount,i;
	BLOCKINFO *pInfo;

	if(m_nDefaultSize == m_blockArray.GetSize())
		return;		//ύXKvȂ

	if(GetModuleDirectory(path, _MAX_PATH)) {
		sprintf(fname, "%s\\ncs\\block.ini", path);
	}
	else
		return;
	nCount = (int)m_blockArray.GetSize();
	if(!nCount)
		return;
	if((fp = fopen(fname,"w")) == NULL)
		return;
	for (i=0; i<nCount; i++) {
		pInfo = (BLOCKINFO*) m_blockArray.GetAt (i);
		if(pInfo->nBitmap < nCount) {
			fprintf(fp,"{\n");
			fprintf(fp,"%s\n",pInfo->name);
			fprintf(fp,"%d\n",pInfo->type);
			fprintf(fp,"%s\n",pInfo->fBitmap);
			fprintf(fp,"%d\n",pInfo->nBitmap);
			fprintf(fp,"%s\n",pInfo->model);
			fprintf(fp,"}\n");
		}
	}
	fclose(fp);	
}

void CExtncsMain::SetBlockClear()
{
	int nCount,i,siz,j;
	BLOCKINFO* pInfo;
	NAMEINFO* nInfo;

	// m_blockArraym_paramArray폜
	nCount = (int)m_blockArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pInfo = (BLOCKINFO*) m_blockArray.GetAt (i);
			siz = (int)pInfo->inpname.GetSize();
			if(siz) {
				for(j = 0; j < siz; j++) {
					nInfo =  (NAMEINFO*) pInfo->inpname.GetAt (j);
					delete nInfo;
				}
				pInfo->inpname.RemoveAll();
			}
			siz = (int)pInfo->outpname.GetSize();
			if(siz) {
				for(j = 0; j < siz; j++) {
					nInfo =  (NAMEINFO*) pInfo->outpname.GetAt (j);
					delete nInfo;
				}
				pInfo->outpname.RemoveAll();
			}
			delete pInfo;
		}
		m_blockArray.RemoveAll();
	}
	//ϐf[^x[Xp
	nCount = (int)m_varArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (VARINFO*) m_varArray.GetAt (i);
		m_varArray.RemoveAll();
	}

}

// indexŎw肳ꂽmodule폜
BOOL CExtncsMain::DelBlockData(int index)
{
	BLOCKINFO* pItem;
	pItem = (BLOCKINFO*) m_blockArray.GetAt (index);
	if(pItem)
		delete pItem;
	m_blockArray.RemoveAt(index);
	return TRUE;
}

// m_blockArrayModuleViewerpf[^x[X쐬
BOOL CExtncsMain::SetBlockData()
{
	int i,nCount;
    BLOCKINFO* pItem;
	FILE *fp;
	char linebuf[256];
	char path[_MAX_PATH],fname[_MAX_PATH];

	// m_blockArraym_paramArray폜
	nCount = (int)m_blockArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (BLOCKINFO*) m_blockArray.GetAt (i);
		m_blockArray.RemoveAll();
	}
	//ϐf[^x[Xp
	nCount = (int)m_varArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (VARINFO*) m_varArray.GetAt (i);
		m_varArray.RemoveAll();
	}

	//
	// Blockblock.iniǂݍ
	//
	nCount = 0;
	if(GetModuleDirectory(path, _MAX_PATH)) {
		sprintf(fname, "%s\\ncs\\block.ini", path);
	}
	else
		return FALSE;
	if((fp = fopen(fname,"r")) != NULL) {
		while(!feof(fp)) {
			if(fgets(linebuf, 256, fp) == NULL)
				break;
			if(strstr(linebuf, "{") != NULL) {
				//KvǂݍŐݒ
				try {
					pItem = new BLOCKINFO;
				}
				catch (CMemoryException* e) {
					e->Delete ();
					return FALSE;
				}
				//Block name
				fgets(linebuf, 256, fp);
				linebuf[strlen(linebuf)-1] = '\0';
				pItem->name = _T(linebuf);
				//Block type (Cu)
				fgets(linebuf, 256, fp);
				linebuf[strlen(linebuf)-1] = '\0';
				pItem->type = atoi(linebuf);
				//Bitmap file
				fgets(linebuf, 256, fp);
				linebuf[strlen(linebuf)-1] = '\0';
				pItem->fBitmap = _T(linebuf);
				//Bitmap index
				fgets(linebuf, 256, fp);
				linebuf[strlen(linebuf)-1] = '\0';
				pItem->nBitmap = atoi(linebuf);
				//Model name
				fgets(linebuf, 256, fp);
				linebuf[strlen(linebuf)-1] = '\0';
				pItem->model = _T(linebuf);
				//Direction
				pItem->direction = DIR_RIGHT;
				//Matrix tH[}bg
				pItem->matrix = CString(_T("1:1"));

				//W[f[^x[Xɓo^
				m_blockArray.InsertAt( nCount, pItem );
				nCount++;
			}

		}
		fclose(fp);
	}

	// fǂ݃|[gݒ
	nCount = (int)m_blockArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (BLOCKINFO*) m_blockArray.GetAt (i);
			sprintf(fname, "%s\\ncs\\model\\%s", path,(LPCTSTR)pItem->model);
			if(Access(fname, SL_FATTR_FOK) != 0){
				//ǉW[Ƃ
				strcpy(fname, pItem->model);
			}
			GetPortInfo( fname, pItem );
		}
	}

	//nCountWubN
	m_nDefaultSize = nCount;

	return TRUE;

}

/*
 * Port(,)𒲂ׂă|[g
 */
BOOL CExtncsMain::GetPortInfo(const char *name, BLOCKINFO *pItem)
{
	//ftHgl
	pItem->inport = 0;
	pItem->outport = 0;

	CString str,strLeft,strRight;
	char *cptr;
	int	pos;
	char linebuf[256];
	CString infoStr[256];
	int infoNum,i;
	BOOL setfg = FALSE;

	//̈CStringzɎ擾
	infoNum = GetModelInfo((char *)name, infoStr);
	// Port(1,1)̋LqT
	for(i = 0; i < infoNum; i++) {
		strcpy(linebuf, infoStr[i]);
		cptr = strstr(linebuf, "Port(");
		if(cptr) {
			cptr += 5;
			str = _T(cptr);
			pos = str.Find(",");
			strLeft = str.Left(pos);
			pItem->inport = atoi(strLeft);
			strRight = str.Mid(pos+1);
			pos = strRight.Find(")");
			strLeft = strRight.Left(pos);
			pItem->outport = atoi(strLeft);
			setfg = TRUE;
			break;
		}
	}
	//ǉW[̏ꍇ́APortLq݂Ȃꍇ
	if(!setfg) {
		pItem->inport = -1;
		pItem->outport = -1;
	}
	//|[g擾
	GetModelInOut((char *)name, pItem);
	return TRUE;

}

//
//f̓o
//
BOOL CExtncsMain::GetModelInOut(char *fname, BLOCKINFO *pItem)
{
	FILE *fp;
	char line[MAX_PATH];
	BOOL flag,hitfg;
	char *cptr;
	int inport,outport,pos;
	CString str;

	if((fp = fopen(fname, "r")) == NULL)
		return FALSE;
	flag = FALSE;
	for(;;) {
		if(fgets(line, MAX_PATH, fp) == NULL)
			break;
		cptr = line;
		if(strstr(line, "exinput:")) {
			cptr += strlen("exinput:");
			//O
			inport = GetModelInInfo( cptr, pItem );
			if(pItem->inport == -1)
				pItem->inport = inport;
		}
		if(strstr(line, "input:")) {
			//ĊmF
			str = _T(line);
			pos = str.Find(_T("input:"));
			if(pos == 0)
				hitfg = TRUE;
			else {
				if(str.GetAt(pos-1) == ' ')
					hitfg = TRUE;
				else
					hitfg = FALSE;
			}
			if(hitfg) {
				cptr += strlen("input:");
				//input
				inport = GetModelInInfo( cptr, pItem );
				if(pItem->inport == -1)
					pItem->inport = inport;
			}
		}
		if(strstr(line, "output:")) {
			cptr += strlen("output:");
			//o
			outport = GetModelOutInfo( cptr, pItem );
			if(pItem->outport == -1)
				pItem->outport = outport;
		}
		if(strstr(line, "observable:")) {
			cptr += strlen("observable:");
			//observable
			//GetModelObsInfo( cptr );
		}
		if(strstr(line, "parameter:")) {
			break;
		}
	}
	fclose(fp);
	return TRUE;
}

int CExtncsMain::GetModelOutInfo(char *line, BLOCKINFO *pItem)
{
	char buf[_MAX_PATH],name[32];
	int	i,addr,nCount = 0;
	NAMEINFO* tmpItem;

	strcpy(buf, line);
	i = 0; addr = 0;
	while(buf[i] != '\n') {
		if(buf[i] != ' ' && buf[i] != '\t') {
			if(buf[i] == ',' || buf[i] == ';') {
				//1parameter
				name[addr] = '\0';
				addr = 0;
				//add
				try {
					tmpItem = new NAMEINFO;
				}
				catch (CMemoryException* e) {
					e->Delete ();
					return 0;
				}
				tmpItem->strName = _T(name);
				nCount = (int)pItem->outpname.GetSize();
				pItem->outpname.InsertAt( nCount, tmpItem );

			}
			else {
				name[addr++] = buf[i];
			}
		}
		i++;
	}
	//parameterŃ|[ggĂꍇ
	nCount = (int)pItem->outpname.GetSize();
	if(nCount != pItem->outport) {
		for(i=1; i < pItem->outport; i++) {
			try {
				tmpItem = new NAMEINFO;
			}
			catch (CMemoryException* e) {
				e->Delete ();
				return 0;
			}
			sprintf(name,"%d",i);
			tmpItem->strName = _T(name);
			nCount = (int)pItem->outpname.GetSize();
			pItem->outpname.InsertAt( nCount, tmpItem );
		}
	}
	//o^Ԃ
	nCount = (int)pItem->outpname.GetSize();
	return nCount;
}

//TODO:̂悤ȏɑΉłȂ
//exinput:
//		In1;
//
int CExtncsMain::GetModelInInfo(char *line, BLOCKINFO *pItem)
{
	char buf[256],name[32];
	int	i,addr,nCount;
	NAMEINFO *tmpItem;

	strcpy(buf, line);
	i = 0; addr = 0;
	while(buf[i] != '\n') {
		if(buf[i] != ' ' && buf[i] != '\t') {
			if(buf[i] == ',' || buf[i] == ';' || buf[i] == '(') {
				//1parameter
				name[addr] = '\0';
				addr = 0;
				//add
				try {
					tmpItem = new NAMEINFO;
				}
				catch (CMemoryException* e) {
					e->Delete ();
					return 0;
				}
				tmpItem->strName = _T(name);
				nCount = (int)pItem->inpname.GetSize();
				pItem->inpname.InsertAt( nCount, tmpItem );
				//TODO : in(0.0,0)̂悤ȋLqւ̑Ή
				if(buf[i] == '(')
					break;
			}
			else {
				name[addr++] = buf[i];
			}
		}
		i++;
	}
	//parameterŃ|[ggĂꍇ
	nCount = (int)pItem->inpname.GetSize();
	if(nCount != pItem->inport) {
		for(i=1; i < pItem->inport; i++) {
			try {
				tmpItem = new NAMEINFO;
			}
			catch (CMemoryException* e) {
				e->Delete ();
				return 0;
			}
			sprintf(name,"%d",i);
			tmpItem->strName = _T(name);
			nCount = (int)pItem->inpname.GetSize();
			pItem->inpname.InsertAt( nCount, tmpItem );
		}
	}
	//o^Ԃ
	nCount = (int)pItem->inpname.GetSize();
	return nCount;
}

//
// WW[̏ꍇɓKp
// /**/܂ł̃Xgǂݍ
//
int CExtncsMain::GetModelInfo(char *name, CString info[])
{
	FILE *fp;
	char linebuf[256];
	BOOL flag;
	int i = 0;

	if((fp = fopen(name, "r")) == NULL)
		return i;

	flag = FALSE;
	while(!feof(fp)) {
		if(fgets(linebuf, 256, fp) == NULL)
			break;
		if(strstr(linebuf, "/*") != NULL) {
			flag = TRUE;
		} else if(strstr(linebuf, "*/") != NULL) {
			break;
		} else {
			if(flag)
				info[i++] = _T(linebuf);
		}		
	}
	fclose(fp);
	return i;	

}

UINT CExtncsMain::GetClipboardFormat()
{
	return m_nFormat;
}

//
// NCSō쐬ꂽfo^́A
// m_blockArrayւ̒ǉ֐ōs
//
int CExtncsMain::SetBlockDataAppend(char * path, char *name, int group, int nBitmap)
{
	int nCount;
    BLOCKINFO* pItem;
	char fname[_MAX_PATH];

	try {
		pItem = new BLOCKINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return FALSE;
	}
	//Block name
	pItem->name = _T(name);
	//Block type (Cu)
	pItem->type = group;
	//Bitmap file
	pItem->fBitmap = _T("default.bmp");
	//Bitmap index
	if(nBitmap == -1)
		pItem->nBitmap = 9999;
	else
		pItem->nBitmap = nBitmap;
	//Model naméAgW[̂߃tpXݒ
	pItem->model = _T(path);
	//Direction
	pItem->direction = DIR_RIGHT;
	//Matrix tH[}bg
	pItem->matrix = CString(_T("1:1"));

	//W[f[^x[Xɓo^
	nCount = (int)m_blockArray.GetSize();
	m_blockArray.InsertAt( nCount, pItem );
	// fǂ݃|[gݒ
	pItem->inport = -1;
	pItem->outport = -1;
	pItem = (BLOCKINFO*) m_blockArray.GetAt (nCount);
	sprintf(fname, "%s", path);
	GetModelInOut( fname, pItem );

	return nCount;
}
