/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ExtncsTree.cpp,v 1.2 2004/08/02 07:16:12 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "ExtncsDoc.h"
#include "ExtncsTree.h"
#include "ModelDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//O[o
extern CExtncsMain* g_pExtncsMain;

// Image indexes
#define ILI_ROOT		0
#define ILI_SUB			1
#define ILI_SUB1		2

/////////////////////////////////////////////////////////////////////////////
// CExtncsTree

IMPLEMENT_DYNCREATE(CExtncsTree, CTreeView)

CExtncsTree::CExtncsTree()
{
	m_hRootItem = NULL;
}

CExtncsTree::~CExtncsTree()
{
}


BEGIN_MESSAGE_MAP(CExtncsTree, CTreeView)
	//{{AFX_MSG_MAP(CExtncsTree)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExtncsTree `

void CExtncsTree::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: ̈ʒuɕ`p̃R[hǉĂ
}

/////////////////////////////////////////////////////////////////////////////
// CExtncsTree ff

#ifdef _DEBUG
void CExtncsTree::AssertValid() const
{
	CTreeView::AssertValid();
}

void CExtncsTree::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}
#endif //_DEBUG

CExtncsDoc* CExtncsTree::GetDocument()
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CExtncsDoc)));
	return (CExtncsDoc*)m_pDocument;
}

/////////////////////////////////////////////////////////////////////////////
// CExtncsTree bZ[W nh

BOOL CExtncsTree::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CTreeView::PreCreateWindow (cs))
		return FALSE;

    cs.style |= TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS |
        TVS_SHOWSELALWAYS;
	return TRUE;

}

void CExtncsTree::OnInitialUpdate() 
{
	CTreeView::OnInitialUpdate();
	BOOL bRet;
	CExtncsDoc* pDoc = GetDocument();
	
	// Initialize the image list.
    bRet = m_ilSystems.Create (IDB_SYSTEMIMAGES, 16, 3, RGB (255, 0, 255));
	CImageList* pImg;
    pImg = GetTreeCtrl ().SetImageList (&m_ilSystems, TVSIL_NORMAL);

	// pDocthiso^
	pDoc->m_pExtncsTree = this;
	// Populate the tree view.
    Initialize ();	
	
}

void CExtncsTree::Initialize()
{
	CExtncsDoc* pDoc = GetDocument();

	// Tree쐬
    m_hRootItem = GetTreeCtrl ().InsertItem (pDoc->m_ModelName, ILI_ROOT,
        ILI_ROOT,TVGN_ROOT);
	GetTreeCtrl ().SetItemData(m_hRootItem, (DWORD)0);

	//size = pDoc->GetWidgetCount();
	//for(i = 0; i < size; i++) {
	//	pWidget = pDoc->GetWidget(i);
	//	if(pWidget->GetId() == M_SUBSYSTEM)
	//		AddItem(pWidget->GetName());
	//}
}

// TreeSubsystemǉ
HTREEITEM CExtncsTree::AddItem(HTREEITEM hParent, CWidget *pWidget)
{
	HTREEITEM hItem;
	hItem = GetTreeCtrl ().InsertItem (pWidget->GetName(), ILI_SUB,
			ILI_SUB, hParent);
	GetTreeCtrl ().SetItemData(hItem, (DWORD)pWidget);
	return hItem;
}

// SubsystemW[ExtncsViewɒǉꂽ
void CExtncsTree::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CWidget* pWidget;
	CWidget* pSaveWidget;
	HTREEITEM hItem;
	CExtncsDoc* pDoc = GetDocument();

	if(lHint != 0x6A && lHint != 0x6B && lHint != 0x6C)
		return;
	if(lHint == 0x6B) {
		//root^Cg
		GetTreeCtrl ().SetItemText(m_hRootItem, (LPCTSTR)pHint);
	}
	else {
		if(lHint == 0x6C) {
			pWidget = (CWidget *)pHint;
			hItem = pWidget->GetHitem();
		}
		else {
			hItem = GetTreeCtrl ().GetSelectedItem();
		}
		//TreeXV
		if(!hItem)
			return;
		//All delete
		DeleteAllItem(hItem);
		//All update
		pSaveWidget = pDoc->m_pTargetWidget;
		UpdateAllItem(hItem);
		pDoc->m_pTargetWidget = pSaveWidget;
		
	}
}

void CExtncsTree::UpdateAllItem(HTREEITEM hParent)
{
	int size,i;
	CWidget* pSaveWidget;
	CWidget* pWidget;
	HTREEITEM hChild;
	CExtncsDoc* pDoc = GetDocument();

	size = pDoc->GetWidgetCount();
	if(size) {
		for(i = 0; i < size; i++) {
			pWidget = pDoc->GetWidget(i);
			if(pWidget->GetId() == M_SUBSYSTEM) {
				hChild = AddItem(hParent, pWidget);
				pWidget->SetHitem(hChild);
				//Subsystem
				pSaveWidget = pDoc->m_pTargetWidget;
				pDoc->m_pTargetWidget = pWidget;
				UpdateAllItem(hChild);
				pDoc->m_pTargetWidget = pSaveWidget;
			}
		}
		GetTreeCtrl ().Expand(hParent, TVE_EXPAND);
	}
}

void CExtncsTree::DeleteAllItem(HTREEITEM hParent)
{
    HTREEITEM hItem,hNextItem;

	//SĂ폜
	if(!hParent)
		return;
    if ((hItem = GetTreeCtrl ().GetChildItem (hParent)) == NULL)
        return;
  	do {
		hNextItem = GetTreeCtrl ().GetNextSiblingItem (hItem);
		DeleteAllItem(hNextItem);
		GetTreeCtrl ().DeleteItem (hItem);
		hItem = hNextItem;
	} while (hItem != NULL);
}

void CExtncsTree::OnAppExit() 
{
	//SATELLITEIAExitj[
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	
}

//TreeIꂽAExtncsViewɒʒm
void CExtncsTree::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	//m_pTargetWidgeťo
	HTREEITEM hSelItem;
	CExtncsDoc* pDoc = GetDocument();
	hSelItem = pNMTreeView->itemNew.hItem;
	pDoc->m_pTargetWidget = (CWidget *)GetTreeCtrl ().GetItemData(hSelItem);
    CString strPath = GetTreeCtrl ().GetItemText (hSelItem);	
    pDoc->UpdateAllViews (this, 0x5B, (CObject*) (LPCTSTR)strPath);
	
	*pResult = 0;
}
