/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ExtncsView.cpp,v 1.13 2004/09/14 07:22:21 yoshihiko Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "stdafx.h"
#include "Extncs.h"
#include "shell/satellite4.h"		//TODO:syscomQƂ̂

#include "WidgetObj.h"
#include "ScopeWnd.h"
#include "SubsysDoc.h"
#include "SubsysWnd.h"
#include "ExtncsDoc.h"
#include "ExtncsView.h"
#include "ModelDoc.h"
#include "ExtncsWnd.h"
#include "ExtncsMain.h"
#include "ParamWnd.h"
#include "LineProp.h"
#include "WidgetExtend.h"
#include "SimuWnd.h"
#include "ScopeList.h"
#include "ScopeFrame.h"
#include "MoniWnd.h"
#include "XyWnd.h"
#include <io.h>
#include <direct.h>
#include ".\extncsview.h"

using namespace std;
#define printf          syscom->console->tty_printf

extern CExtncsMain*	g_pExtncsMain;
extern CMultiDocTemplate* g_pScopeTemplate;
void __cdecl SyncThread( CExtncsView * pView );
extern CMultiDocTemplate* g_pSubsysTemplate;
extern	BOOL	simu_exit;		//~tO

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// ParamWnd
typedef struct tagPARAMWNDINFO {
	//Window
	CParamWnd*	pWnd;
	//id
	CWidget*	pWidget;
} PARAMWNDINFO;

/////////////////////////////////////////////////////////////////////////////
// CExtncsView

IMPLEMENT_DYNCREATE(CExtncsView, CScrollView)

CExtncsView::CExtncsView()
{
	m_bHitRLine = FALSE;
	m_bHitLLine = FALSE;
	m_bLineMode = FALSE;
	m_hCross = NULL;
	m_hArrow = NULL;
	m_hRSize = NULL;
	m_hLSize = NULL;

	//m_paramArray
	int nCount,i;
	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
		m_paramArray.RemoveAll();
	}
	//V~[VXe[^X
	m_pSimuWnd = NULL;
	m_fSimuState = FALSE;
	//Subsystem֌W
	for(i = 0; i < MAX_SUBSYSTEM; i++) {
		m_pSubsysDoc[i] = NULL;
		m_pSubsysWnd[i] = NULL;
	}
	m_nSubsysMax = 0;
	m_bCtrlKey = FALSE;
	//Resize
	m_nSizePoint = -1;
	m_bSizeMode = FALSE;
	//Region
	m_bAreaMode = FALSE;
	//CWidgetExtend
	m_pWidgetExtend = NULL;
	//CLineProp
	m_pLineProp = NULL;
	//ڑ_Ȃ
	m_connectPoint[0].x = -1; m_connectPoint[0].y = -1;
}

CExtncsView::~CExtncsView()
{
}


BEGIN_MESSAGE_MAP(CExtncsView, CScrollView)
	//{{AFX_MSG_MAP(CExtncsView)
	ON_WM_CREATE()
	ON_WM_LBUTTONDOWN()
	ON_COMMAND(ID_EDIT_CUT, OnEditCut)
	ON_UPDATE_COMMAND_UI(ID_EDIT_CUT, OnUpdateEditCut)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_UPDATE_COMMAND_UI(ID_EDIT_COPY, OnUpdateEditCopy)
	ON_COMMAND(ID_EDIT_PASTE, OnEditPaste)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PASTE, OnUpdateEditPaste)
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_UPDATE_COMMAND_UI(ID_EDIT_DELETE, OnUpdateEditDelete)
	ON_WM_KILLFOCUS()
	ON_WM_SETFOCUS()
	ON_WM_SETCURSOR()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_WIDGET_LINE, OnWidgetLine)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_LINE, OnUpdateWidgetLine)
	ON_COMMAND(ID_EXTNCS_START, OnExtncsStart)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_START, OnUpdateExtncsStart)
	ON_COMMAND(ID_EXTNCS_STOP, OnExtncsStop)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_STOP, OnUpdateExtncsStop)
	ON_COMMAND(ID_EXTNCS_CONDITION, OnExtncsCondition)
	ON_UPDATE_COMMAND_UI(ID_EXTNCS_CONDITION, OnUpdateExtncsCondition)
	ON_WM_LBUTTONDBLCLK()
	ON_COMMAND(ID_WIDGET_PARAM, OnWidgetParam)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_PARAM, OnUpdateWidgetParam)
	ON_COMMAND(ID_WIDGET_SCOPE, OnWidgetScope)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_SCOPE, OnUpdateWidgetScope)
	ON_COMMAND(ID_WIDGET_0, OnWidget0)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_0, OnUpdateWidget0)
	ON_COMMAND(ID_WIDGET_90, OnWidget90)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_90, OnUpdateWidget90)
	ON_COMMAND(ID_WIDGET_180, OnWidget180)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_180, OnUpdateWidget180)
	ON_COMMAND(ID_WIDGET_270, OnWidget270)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_270, OnUpdateWidget270)
	ON_COMMAND(ID_WIDGET_EXTEND, OnWidgetExtend)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_EXTEND, OnUpdateWidgetExtend)
	ON_WM_KEYDOWN()
	ON_WM_KEYUP()
	ON_COMMAND(ID_LINE_PROP, OnLineProp)
	ON_UPDATE_COMMAND_UI(ID_LINE_PROP, OnUpdateLineProp)
	ON_COMMAND(ID_APP_EXIT, OnAppExit)
	ON_WM_DESTROY()
	ON_COMMAND(ID_AREA_DELETE, OnAreaDelete)
	ON_UPDATE_COMMAND_UI(ID_AREA_DELETE, OnUpdateAreaDelete)
	ON_COMMAND(ID_AREA_SUBSYSTEM, OnAreaSubsystem)
	ON_UPDATE_COMMAND_UI(ID_AREA_SUBSYSTEM, OnUpdateAreaSubsystem)
	ON_COMMAND(ID_AREA_MODULE, OnAreaModule)
	ON_UPDATE_COMMAND_UI(ID_AREA_MODULE, OnUpdateAreaModule)
	ON_COMMAND(ID_WIDGET_LIB, OnWidgetLib)
	ON_UPDATE_COMMAND_UI(ID_WIDGET_LIB, OnUpdateWidgetLib)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_EXTNCS_PARAM, OnParamChange)
	ON_MESSAGE(WM_DELETE_EXTEND, OnDeleteExtend)
	ON_MESSAGE(WM_DELETE_LINEPROP, OnDeleteLineprop)
	ON_MESSAGE(WM_DELETE_PARAM, OnDeleteParam)
	ON_MESSAGE(WM_DELETE_SIMU, OnDeleteSimu)
	ON_MESSAGE(WM_DELETE_SCOPEFRAME, OnDeleteScopeFrame)
	ON_MESSAGE(WM_DELETE_SUBSYSTEM, OnDeleteSubsystem)
	ON_MESSAGE(WM_EXTNCS_START, ExtncsStart)
	ON_MESSAGE(WM_EXTNCS_CONDITION, ExtncsCondition)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExtncsView `

void CExtncsView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	SetScrollSizes(MM_TEXT, CSize (1280, 1024));
	m_pTempWidget = NULL;
	m_pTempLine = NULL;
	m_nSel = -1;
	m_lSel = -1;
}

void CExtncsView::OnDraw(CDC* pDC)
{
	CExtncsDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	//////////////////////////////////////////////////////////////////////////
	//̫Đݒ
	CFont	font;
	CFont*	pOldFont;
	CWidget* pWidget;
	CLine* pLine;
	int	junc,type,nCount,i;
	CPoint mpt,spt,ept;
	CRect rect;

#if 0
	font.CreateFont(MulDiv(7, -pDC->GetDeviceCaps(LOGPIXELSY), 72),
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS P"));
#else
	font.CreateFont(12,
		0,0,0,FW_NORMAL,0,0,0,SHIFTJIS_CHARSET,
		OUT_STROKE_PRECIS,CLIP_DEFAULT_PRECIS,DRAFT_QUALITY,
		DEFAULT_PITCH,_T("MS P"));
#endif
	pOldFont = pDC->SelectObject(&font);
	//\ݒ
	pDC->SetBkMode( TRANSPARENT );
    pDC->SetTextColor(0x0);

	// Widget\
	nCount = pDoc->GetWidgetCount ();
	if (nCount) {
		// Draw all widgets.
		for (i=0; i<nCount; i++) {
			pWidget = pDoc->GetWidget (i);
			//id = pWidget->GetId();
			//if(id != M_GAP && id != M_SYNAPSE)
			type = pWidget->GetType();
			if(type != MODULE_GAP && type != MODULE_SYNAPSE)
				pWidget->Draw (pDC);
		}

		// Draw the selected widget if this view has the input focus.
		if(m_bAreaMode) {
			for (i=0; i<nCount; i++) {
				pWidget = pDoc->GetWidget (i);
				//id = pWidget->GetId();
				type = pWidget->GetType();
				if(pWidget->GetSel()) {
					//if(id != M_GAP && id != M_SYNAPSE)
					if(type != MODULE_GAP && type != MODULE_SYNAPSE)
						pWidget->DrawSelected (pDC);
				}
			}
		}
		else {
			if (m_nSel != -1 && CWnd::GetFocus () == this) {
				pDoc->GetWidget (m_nSel)->DrawSelected (pDC);
			}
		}
	}
	// Line\
	nCount = pDoc->GetLineCount ();
	if (nCount) {
		// Draw all lines.
		for (i=0; i<nCount; i++) {
			pLine = pDoc->GetLine (i);
			//Junction`
			junc = pLine->GetJunction();
			if(junc != -1) {
				//W[̏oɔzu
				//if(pLine->GetType() == LINE_START) {
				//	//ʒuKv
				//	spt = pLine->GetSpos();
				//	ept = pLine->GetEpos();
				//	if(spt.x == ept.x)
				//		mpt = CPoint(spt.x-8, spt.y+(ept.y-spt.y)/2-8);
				//	else
				//		mpt = CPoint(spt.x+(ept.x-spt.x)/2-8, spt.y);
				//	rect = CRect(mpt, CSize(16,16));
				//	pDoc->GetWidget (junc)->SetRect(rect);
				//	pDoc->GetWidget (junc)->Draw(pDC);
				//}

				//W[̓ɔzu
				if(pLine->GetType() == LINE_STOP) {
					//ʒuKv
					spt = pLine->GetSpos();
					ept = pLine->GetEpos();
					if(spt.x == ept.x)
						mpt = CPoint(ept.x-8, ept.y-8);
					else
						mpt = CPoint(spt.x+(ept.x-spt.x)/2-8, ept.y);
					rect = CRect(mpt, CSize(16,16));
					pDoc->GetWidget (junc)->SetRect(rect);
					pDoc->GetWidget (junc)->Draw(pDC);
				}
			}
			//Line`
			pLine->Draw (pDC);
		}
	}

    pDC->SelectObject(pOldFont);
	font.DeleteObject();

}

/////////////////////////////////////////////////////////////////////////////
// CExtncsView ff

#ifdef _DEBUG
void CExtncsView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CExtncsView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CExtncsView bZ[W nh

void CExtncsView::InvalObj(CDC *pDC, CWidget *pWidget)
{
	CRect rect = pWidget->GetRect();
	//DocToClient(rect);
	rect.left -= 4;
	rect.top -= 5;
	rect.right += 5;
	rect.bottom += 4;
	//rect.InflateRect(1, 1); // handles CDrawOleObj objects
	rect.NormalizeRect();
	pDC->DrawFocusRect(rect);

	//InvalidateRect(rect, FALSE);
}

CExtncsDoc* CExtncsView::GetDocument()
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CExtncsDoc)));
	return (CExtncsDoc*)m_pDocument;
}

int CExtncsView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	m_oleDropTarget.Register (this);
	m_hCross = LoadCursor(NULL, MAKEINTRESOURCE(IDC_CROSS));
	m_hArrow = LoadCursor(NULL, MAKEINTRESOURCE(IDC_ARROW));
	m_hRSize = LoadCursor(NULL, MAKEINTRESOURCE(IDC_SIZENESW));	//Eオ
	m_hLSize = LoadCursor(NULL, MAKEINTRESOURCE(IDC_SIZENWSE));	//オ
	
	return 0;
}

DROPEFFECT CExtncsView::OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	CScrollView::OnDragEnter(pDataObject, dwKeyState, point);

	//
	// If a widget is available from the drop source, create a temporary
	// widget for drag imaging.
	//
	CExtncsDoc* pDoc = GetDocument();
	UINT nFormat;
	CPoint newpoint,spt,ept;
	int x,y,id,cx,cy,sbk,ebk,index,arrow,inport,outport,type,junction;
	COLORREF color;
	char name[256];

	nFormat = g_pExtncsMain->GetClipboardFormat ();
	HGLOBAL hData = pDataObject->GetGlobalData (nFormat);

	if (hData != NULL) {
		if(m_nSel != -1) {
			// Widgetړ
			WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
			x = point.x - pWidgetInfo->cx;
			y = point.y - pWidgetInfo->cy;
			m_offset.cx = pWidgetInfo->cx;
			m_offset.cy = pWidgetInfo->cy;
			color = pWidgetInfo->color;
			strcpy(name, pWidgetInfo->name);
			id = pWidgetInfo->id;
			::GlobalUnlock (hData);
			::GlobalFree (hData);

			newpoint.x = x; newpoint.y = y;
			m_pTempWidget = new CWidget (newpoint, id, pWidgetInfo->width, pWidgetInfo->height);
			m_pointLastImage.x = m_pointLastImage.y = -32000;
			m_pointLastMsg = point;
		}
		else {
			// Lineړ
			LINEINFO* pLineInfo = (LINEINFO*) ::GlobalLock (hData);
			spt = pLineInfo->spt;
			ept = pLineInfo->ept;
			cx = ept.x-spt.x;
			//if(cx == 0)	cx = 1;
			cy = ept.y-spt.y;
			//if(cy == 0)	cy = 1;
			if(spt.x == ept.x) {
				spt.x = point.x;
				ept.x = point.x;
			}
			else {
				spt.y = point.y;
				ept.y = point.y;
			}
			m_offset.cx = point.x-spt.x;
			m_offset.cy = point.y-spt.y;
			arrow = pLineInfo->arrow;
			color = pLineInfo->color;
			sbk = pLineInfo->sblk;
			ebk = pLineInfo->eblk;
			index = pLineInfo->index;
			inport = pLineInfo->inport;
			outport = pLineInfo->outport;
			type = pLineInfo->type;
			junction = pLineInfo->junction;
			::GlobalUnlock (hData);
			::GlobalFree (hData);

			//spt.x = x; spt.y = y;
			//ept.x = x - cx; ept.y = y - cy;
			m_pTempLine = new CLine (spt, ept, sbk, ebk, color, arrow, index,
				inport, outport, type, junction);
			m_pointLastImage.x = m_pointLastImage.y = -32000;
			m_pointLastMsg = point;
		}

		//
		// Return DROPEFFECT_COPY if the Ctrl key is down, or DROPEFFECT_MOVE
		// if it is not.
		//
		return (dwKeyState & MK_CONTROL) ?
			DROPEFFECT_COPY : DROPEFFECT_MOVE;
	}
	//
	// The cursor isn't carrying a widget. Indicate that the drop target will
	// not accept a drop.
	//
	m_pTempWidget = NULL;
	m_pTempLine = NULL;
	return DROPEFFECT_NONE;
}

DROPEFFECT CExtncsView::OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point) 
{
	CScrollView::OnDragOver(pDataObject, dwKeyState, point);

	// Return now if the object being dragged is not a widget.
    if (m_pTempWidget == NULL && m_pTempLine == NULL)
        return DROPEFFECT_NONE;

	// Convert the drag point to logical coordinates.
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	// If the cursor has moved, erase the old drag image and draw a new one.
	if (point != m_pointLastMsg) {
		CPoint pt;
		if(m_pTempWidget) {
			pt.x = point.x - m_offset.cx;
			pt.y =  point.y - m_offset.cy;
			m_pTempWidget->DrawDragImage (&dc, m_pointLastImage);
			m_pTempWidget->DrawDragImage (&dc, pt);
		}
		else {
			CPoint spt,ept;
			spt = m_pTempLine->GetSpos();
			ept = m_pTempLine->GetEpos();
			if(spt.x == ept.x) {
				//x̂݋
				pt.x = point.x;
				pt.y = spt.y;
			}
			else {
				//ŷ݋
				pt.x = spt.x;
				pt.y =  point.y;
			}
			m_pTempLine->DrawDragImage (&dc, m_pointLastImage);
			m_pTempLine->DrawDragImage (&dc, pt);
		}
		m_pointLastImage = pt;
		m_pointLastMsg = point;
	}

	// Return DROPEFFECT_COPY if the Ctrl key is down, or DROPEFFECT_MOVE
	// if it is not.
    return (dwKeyState & MK_CONTROL) ?
        DROPEFFECT_COPY : DROPEFFECT_MOVE;
}

void CExtncsView::OnDragLeave() 
{
	CScrollView::OnDragLeave();

	//
	// Erase the last drag image and delete the temporary widget.
	//
	if (m_pTempWidget != NULL || m_pTempLine != NULL) {
		CClientDC dc (this);
		OnPrepareDC (&dc);
		if(m_pTempWidget) {
			m_pTempWidget->DrawDragImage (&dc, m_pointLastImage);
			delete m_pTempWidget;
			m_pTempWidget = NULL;
		}
		else {
			m_pTempLine->DrawDragImage (&dc, m_pointLastImage);
			delete m_pTempLine;
			m_pTempLine = NULL;
		}
	}
}

BOOL CExtncsView::OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point) 
{
	CScrollView::OnDrop(pDataObject, dropEffect, point);

	// Convert the drop point to logical coordinates.
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	// Erase the last drag image and delete the temporary widget.
	if (m_pTempWidget != NULL || m_pTempLine != NULL) {
		if(m_pTempWidget) {
			m_pTempWidget->DrawDragImage (&dc, m_pointLastImage);
			delete m_pTempWidget;
			m_pTempWidget = NULL;
		}
		else {
			m_pTempLine->DrawDragImage (&dc, m_pointLastImage);
			delete m_pTempLine;
			m_pTempLine = NULL;
		}
	}

	// Retrieve the HGLOBAL from the data object and create a widget.
	CExtncsDoc* pDoc = GetDocument ();
	CPoint newpoint,spt,ept;
	CWidget* pWidget;
	CLine* pLine;
	int x,y,id,direction,cx,cy,arrow,index,sblk,eblk,inport,outport,type,junction,connect;
	CString matrix,bmpName;
	COLORREF color;
	char name[256];
	int row,column,width,height;
	CPtrArray* pSubsysArray;
	CSubsysDoc* pSubsysDoc;
	CPtrArray*	pParamArray;
	int i,nLine;
	CPtrArray* pInOut;
	CPtrArray* pScopeArray;
	CWnd* pScopeWnd;

	UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
	HGLOBAL hData = pDataObject->GetGlobalData (nFormat);

	if (hData != NULL) {
		if(m_nSel != -1) {
			WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
			x = point.x - pWidgetInfo->cx;
			y = point.y - pWidgetInfo->cy;
			color = pWidgetInfo->color;
			id = pWidgetInfo->id;
			direction = pWidgetInfo->direction;
			strcpy(name, pWidgetInfo->name);
			matrix = pWidgetInfo->matrix;
			row = pDoc->GetMatrixRow(pWidgetInfo->matrix);
			column = pDoc->GetMatrixColumn(pWidgetInfo->matrix);
			width = pWidgetInfo->width;
			height = pWidgetInfo->height;
			inport = pWidgetInfo->inport;
			outport = pWidgetInfo->outport;
			// Subsystem
			pSubsysArray = pWidgetInfo->pSubsysArray;
			pSubsysDoc = (CSubsysDoc *)pWidgetInfo->pDoc;
			bmpName = pWidgetInfo->bmp;
			// Parameter
			pParamArray = pWidgetInfo->pParamArray;
			junction = pWidgetInfo->junction;
			connect = pWidgetInfo->connect;
			//matrixl傫ɂ
			if(row*column != 1) {
				width = pWidgetInfo->width / column;
				height = pWidgetInfo->height / row;
			}
			//Scope
			pScopeArray = pWidgetInfo->pScopeArray;
			pScopeWnd = pWidgetInfo->pScopeWnd;
			//̈폜
			::GlobalUnlock (hData);
			::GlobalFree (hData);
			//ړVʒu
			newpoint.x = x; newpoint.y = y;
//TODO:
			if(!pDoc->m_pTargetWidget)
				m_nSel = pDoc->AddWidget (id, newpoint, name, direction,
					matrix, width, height);
			else
				m_nSel = pDoc->AddSubWidget (pDoc->m_pTargetWidget, id, newpoint, name, direction,
					matrix, width, height);

			//|[gݒ肵Ă
			pWidget = (CWidget*)pDoc->GetWidget(m_nSel);
			//ړꍇłA|[gԂ͕ێĂ
			pWidget->SetInport(inport);
			pInOut = pWidget->GetInportName();
			if(inport != pInOut->GetSize())		//͐`FbN
				pWidget->ChangeInportName();
			pWidget->SetOutport(outport);
			pInOut = pWidget->GetOutportName();
			if(outport != pInOut->GetSize())	//o͐`FbN
				pWidget->ChangeOutportName();
			//Subsystemt
			if(pWidget->GetId() == M_SUBSYSTEM) {
				//ǉ
				CopySubsystem(pWidget, pSubsysArray);
				//JĂSubsystemEBhEւ̑Ή
				//if(pSubsysDoc)
				//	pSubsysDoc->m_pWidget = pWidget;
			}
			//Bitmap
			if(bmpName.IsEmpty() == 0)	//bitmapݒ肳Ă
				pWidget->SetBitmap(bmpName);
			//p[^[
			CopyParam(pWidget, pParamArray);
			// XyW[ɊւĕύXKv
			if(id == M_XY) {
				pWidget->ChangeXyScope();
			}
			//gCELL
			pWidget->SetJunction(junction);
			pWidget->SetConnect(connect);
			//ScopeĐݒ
			pWidget->ChangeScopeInfo(pWidget, pScopeWnd, pScopeArray);
#if 0
pWidget->SetScope(pScopeWnd);
if(id == M_XY)
((CXyWnd*)pScopeWnd)->m_pWidget = pWidget;
else
((CScopeFrame*)pScopeWnd)->m_pWidget = pWidget;
SCOPEINFO* pinfo;
CPtrArray* pScope = pWidget->GetScopePointer();
for(i=0;i<pScopeArray->GetSize();i++) {
	sinfo = (SCOPEINFO*)pScopeArray->GetAt(i);
	pinfo = (SCOPEINFO*)pScope->GetAt(i);
	//Xɐݒ肷
	pinfo->pScopeWnd = sinfo->pScopeWnd;
	if(pinfo->pScopeWnd) {
		if(id == M_XY)
		((CXyWnd*)pinfo->pScopeWnd)->m_pWidget = pWidget;
		else
		((CScopeWnd*)pinfo->pScopeWnd)->m_pWidget = pWidget;
	}
}
#endif
		}
		else {
			LINEINFO* pLineInfo = (LINEINFO*) ::GlobalLock (hData);
			spt = pLineInfo->spt;
			ept = pLineInfo->ept;
			cx = abs(ept.x-spt.x);
			//if(cx == 0)	cx = 1;
			cy = abs(ept.y-spt.y);
			//if(cy == 0)	cy = 1;
			if(cx == 0) {
				spt.x = point.x;
				ept.x = point.x;
			}
			else {
				spt.y = point.y;
				ept.y = point.y;
			}
			arrow = pLineInfo->arrow;
			color = pLineInfo->color;
			sblk = pLineInfo->sblk;
			eblk = pLineInfo->eblk;
			index = pLineInfo->index;
			inport = pLineInfo->inport;
			outport = pLineInfo->outport;
			type = pLineInfo->type;
			junction = pLineInfo->junction;
			//̈폜
			::GlobalUnlock (hData);
			::GlobalFree (hData);
			//ύX
			//spt.x = x; spt.y = y;
			//ept.x = x + cx; ept.y = y + cy;
			//InsertOɗTChύX
			if(arrow == 2) {
				//r
				pLine = pDoc->GetLine(m_lSel+1);
				pLine->SetSpos(ept);
			}
			else {
				//Ԑ
				pLine = pDoc->GetLine(m_lSel-1);
				pLine->SetEpos(spt);
				pLine = pDoc->GetLine(m_lSel+1);
				pLine->SetSpos(ept);
			}
			//Insert
			m_lSel = pDoc->AtLine(m_lSel+1, spt, ept, sblk, eblk, color, arrow, index,
				inport, outport, type, junction);
			//LinȇI
			m_lSel = -1;
			nLine = pDoc->GetLineCount();
			for(i = 0; i < nLine; i++) {
				pLine = pDoc->GetLine(i);
				if(pLine->GetSel())
					pLine->SetSel(FALSE);
			}

		}
		//f炵Ȃ
		//ăRpC
		pDoc->m_bCodeGen = FALSE;
		pDoc->m_bCodeCompile = FALSE;
		//!!!! dv
		//ExtncsTree̍XVi0x6Aj͍sȂ
		pDoc->UpdateAllViews (NULL);
		return TRUE;
	}
	return FALSE;
}

//Widgetړɂ郉C̈ړ
void CExtncsView::LoadWidgetLine(int widget, int index)
{
	CExtncsDoc* pDoc = GetDocument();
	int nCount,i,inport,outport,sblk,eblk,junc,lSel;
	CPoint spt,ept;
	CWidget* pWidget;
	MOVELINE* pItem;
	CRect rect;

	nCount = (int)m_moveArray.GetSize();
	//Widgetւ̓̓C
	for(i = 0; i < nCount; i++) {
		pItem = (MOVELINE *)m_moveArray.GetAt(i);
		junc = pItem->junction;
		if(pItem->type == 0) {
			//Srcʒu
			sblk = pItem->sblk;
			if(sblk > index)
				sblk -= 1;
			outport = pItem->outport;
			if(outport == -1) {
				spt = pItem->bpt;
				//Desʒu
				pWidget = pDoc->GetWidget( widget );
				inport = pItem->inport;
				ept = pWidget->GetInportPos( inport );
				//Rect쐬
				rect = CRect(spt, ept);
				//Line
				pDoc->InsertDivide (rect, pItem->btype, sblk,  widget, inport, junc);
			}
			else {
				pWidget = pDoc->GetWidget( sblk );
				spt = pWidget->GetOutportPos( outport );
				//Desʒu
				pWidget = pDoc->GetWidget( widget );
				inport = pItem->inport;
				ept = pWidget->GetInportPos( inport );
				//Rect쐬
				rect = CRect(spt, ept);
				//Line
				pDoc->InsertLine (rect, sblk, widget, inport, outport, junc);
			}
			//LiněAŌɏꂽLinẽCfbNX
			lSel = pDoc->GetLineCount();
			if(pItem->s_arrow == 3 && pItem->e_arrow == 1)
				pDoc->ChangeLine(lSel-1, 2);
			else if(pItem->s_arrow == 3 && pItem->e_arrow == 0)
				pDoc->ChangeLine(lSel-1, 1);
		}
	}
	//Widget̏o̓C
	for(i = 0; i < nCount; i++) {
		pItem = (MOVELINE *)m_moveArray.GetAt(i);
		junc = pItem->junction;
		if(pItem->type == 1) {
			pWidget = pDoc->GetWidget( widget );
			outport = pItem->outport;
			if(outport == -1) {
				//outporẗʒúH
				//o͂镪򃉃C͍폜
			}
			else {
				//Srcʒu
				spt = pWidget->GetOutportPos( outport );
				//Desʒu
				eblk = pItem->eblk;
				if(eblk > index)
					eblk -= 1;
				inport = pItem->inport;
				pWidget = pDoc->GetWidget( eblk );
				ept = pWidget->GetInportPos( inport );
				//Rect쐬
				rect = CRect(spt, ept);
				//Line
				pDoc->InsertLine (rect, widget, eblk, inport, outport, junc);
			}
			//LiněAŌɏꂽLinẽCfbNX
			lSel = pDoc->GetLineCount();
			if(pItem->s_arrow == 3 && pItem->e_arrow == 1)
				pDoc->ChangeLine(lSel-1, 2);
			else if(pItem->s_arrow == 3 && pItem->e_arrow == 0)
				pDoc->ChangeLine(lSel-1, 1);
		}
	}
}

void CExtncsView::CopyScope(CWidget* pWidget, CWnd* pWnd, CPtrArray* p)
{
#if 0
	SCOPEINFO* pItem;
	SCOPEINFO* sItem;
	CPtrArray*	pScopeArray;
	int	i,nScope;
	CScopeWnd* pScopeWnd;
	CXyWnd* pXyWnd;

	// WidgetScopeWndݒ
	pWidget->SetScope(pWnd);
	// WidgetScopeJĂ΁AWidgeto^
	if(pWidget->GetId() == M_XY)
		((CXyWnd*)pWnd)->m_pWidget = pWidget;
	else
		((CScopeFrame*)pWnd)->m_pWidget = pWidget;
	// WidgetScope|C^[
	pScopeArray = pWidget->GetScopePointer();
	// o^Scope
	nScope = (int)p->GetSize();
	for(i = 0; i < nScope; i++) {
		// o^
		sItem = (SCOPEINFO*) p->GetAt(i);
		pItem = (SCOPEINFO*) pScopeArray->GetAt(i);
		//Rs[
		pItem = sItem;
		if(pItem->pScopeWnd) {
			if(pWidget->GetId() == M_XY) {
				pXyWnd = (CXyWnd*)pItem->pScopeWnd;
				pXyWnd->m_pWidget = pWidget;
			}
			else {
				pScopeWnd = (CScopeWnd*)pItem->pScopeWnd;
				pScopeWnd->m_pWidget = pWidget;
			}
		}
	}
#endif
}

void CExtncsView::CopyParam(CWidget* pWidget, CPtrArray* p)
{
	PARAMINFO* pItem;
	PARAMINFO* sItem;
	CPtrArray*	pParam;
	int	i,nParam;

	pParam = pWidget->GetParamPointer();
	nParam = (int)p->GetSize();
	for(i = 0; i < nParam; i++) {
		sItem = (PARAMINFO*) p->GetAt(i);
		pItem = (PARAMINFO*) pParam->GetAt(i);
		//l̂ݓo^
		pItem->strValue = sItem->strValue;
	}
}

// pSrcWidget̓epTargetWidgetɃRs[
void CExtncsView::CopySubsystem(CWidget* pTargetWidget, CPtrArray* pSrcWidget)
{
	CWidget* pSaveWidget;
	CWidget* pWidget;
	CWidget* pSubWidget;
	CWidget* pCopyWidget = (CWidget*)pSrcWidget;
	CExtncsDoc *pDoc = GetDocument();
	CPtrArray* pTarget;
	CPtrArray* pCopy;
	int i,j,nWidget,id,cx,cy,direction,nParam,nIndex,nLine;
	int inport,outport,connect,junction;
	int idx,type,sblk,eblk,arrow;
	COLORREF color;
	CRect rect;
	CPoint spos,epos;
	CString matrix,name;
	char strValue[100][16];
	CLine* pLine;
	CPtrArray* pInOut;
	CPtrArray* pParamArray;
	PARAMINFO* pItem;
	
	//e폜
	pDoc->SubDeleteContents(pTargetWidget);
	//Widget̃Rs[
	pTarget = pTargetWidget->GetWidgetsPointer();
	pCopy = pCopyWidget->GetWidgetsPointer();
	nWidget = (int)pCopy->GetSize();
	for(i = 0; i < nWidget; i++) {	// nSizewidgetǂ
		//copyWidget
		pWidget = (CWidget*)pCopy->GetAt(i);	
		//moduleʂindexȂǁA
		id = pWidget->GetId();
		rect = pWidget->GetRect();
		spos = CPoint(rect.left, rect.top);
		cx = rect.Width();
		cy = rect.Height();
		direction = pWidget->GetDirection();
		matrix = pWidget->GetMatrix();
		//parameter
		pParamArray = pWidget->GetParamPointer();
		nParam = (int)pParamArray->GetSize();
		for(j = 0; j < nParam; j++) {
			pItem = (PARAMINFO*)pParamArray->GetAt(j);
			strcpy(strValue[j], pItem->strValue);
		}
		//Subsystem\WidgetɃRs[
		if(nParam > 0) {
			nIndex = pDoc->AddSubWidget2(pTargetWidget, id, spos, NULL, direction, matrix, nParam, strValue, cx, cy);
		}
		else {
			nIndex = pDoc->AddSubWidget(pTargetWidget, id, spos, NULL, direction, matrix, cx, cy);
		}
		//o̓|[g
		pSubWidget = (CWidget*) pTarget->GetAt(nIndex);
		inport = pWidget->GetInport();
		pSubWidget->SetInport(inport);
		//pSubWidget->ChangeInportName();
		pInOut = pWidget->GetInportName();
		pSubWidget->SetInportName(pInOut);
		outport = pWidget->GetOutport();
		pSubWidget->SetOutport(outport);
		//pSubWidget->ChangeOutportName();
		pInOut = pWidget->GetOutportName();
		pSubWidget->SetOutportName(pInOut);
		//Name
		name = pWidget->GetName();
		pSubWidget->SetName(_T(name));
		//gCELL
		connect = pWidget->GetConnect();
		pSubWidget->SetConnect(connect);
		junction = pWidget->GetJunction();
		pSubWidget->SetJunction(junction);
		//Subsystemt
		if(pWidget->GetId() == M_SUBSYSTEM) {
			//SubsystemSubsystem
			CopySubsystem(pSubWidget, (CPtrArray*)pWidget);
		}
	}

	//Rs[Widgetw肵ALinẽRs[
	pSaveWidget = pDoc->m_pTargetWidget;
	pDoc->m_pTargetWidget = pTargetWidget;
	pTarget = pTargetWidget->GetLinesPointer();
	pCopy = pCopyWidget->GetLinesPointer();
	nLine = (int)pCopy->GetSize();
	for(i = 0; i < nLine; i++) {
		pLine = (CLine*) pCopy->GetAt(i);
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		sblk = pLine->GetSblk();
		eblk = pLine->GetEblk();
		color = pLine->GetColor();
		arrow = pLine->GetArrow();
		idx = pLine->GetIndex();
		inport = pLine->GetInport();
		outport = pLine->GetOutport();
		type = pLine->GetType();
		junction = pLine->GetJunction();
		pDoc->AddLine(spos, epos, sblk, eblk, color, arrow, idx, inport, outport, type, junction);
		pTargetWidget->IncLineIndex(1);
	}
	pDoc->m_pTargetWidget = pSaveWidget;

}

void CExtncsView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉ邩܂̓ftHg̏ĂяoĂ
	
	CScrollView::OnLButtonDown(nFlags, point);

	// Get ExtncsDoc
	CExtncsDoc *pDoc = GetDocument();
	int nCount = pDoc->GetWidgetCount ();
	int lCount = pDoc->GetLineCount();

	// Convert the click point to logical coordinates.
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	CPoint pos;
	CWidget* pWidget;
	CRect rect;
	int outport,hstep,i,sbk,nMouse,row,column;
	BOOL bHit;
	CLine* pLine;
	HANDLE hData;
	COleDataSource ods;

	//C`惂[h
	if(m_bHitRLine) {
		//\[XWidget烉C
		pos = point;
		pWidget = pDoc->GetWidget (m_nWidgetRLine);
		ASSERT (pWidget != NULL);
		rect = pWidget->GetRect ();
		outport = pWidget->GetOutport();
		row = pWidget->GetCellRow();
		column = pWidget->GetCellColumn();

		if(row*column != 1 && m_outIndex > 1) {
			//gCELL̏ꍇAS߂
			pos = pWidget->GetWidgetCenter(point);
		}
		else {
			//SINGLE_CELL̏ꍇ́Ǎ_w肷
			switch(pWidget->GetDirection()) {
			case	DIR_RIGHT:
				pos.x = rect.right;
				hstep = (rect.bottom - rect.top) / (outport + 1);
				pos.y = rect.top + hstep * m_outIndex;
				break;
			case	DIR_UP:
				pos.y = rect.top;
				hstep = (rect.right - rect.left) / (outport + 1);
				pos.x = rect.left + hstep * m_outIndex;
				break;
			case	DIR_LEFT:
				pos.x = rect.left;
				hstep = (rect.bottom - rect.top) / (outport + 1);
				pos.y = rect.top + hstep * m_outIndex;
				break;
			case	DIR_DOWN:
				pos.y = rect.bottom;
				hstep = (rect.right - rect.left) / (outport + 1);
				pos.x = rect.left + hstep * m_outIndex;
				break;
			}
		}
		m_ptFrom = pos;
		m_ptTo = pos;

		//SetCapturesOnSetCursorɂȂ̂ŁAŕύX
		//SetCursor (m_hArrow);
		SetCapture ();

		//C`惂[h
		m_bLineMode = TRUE;
		nMouse = (int)m_mouseArray.GetSize();
		if(nMouse > 0) {
			for (i=0; i<nMouse; i++)
				delete (PARAMWNDINFO*) m_mouseArray.GetAt (i);
			m_mouseArray.RemoveAll();
		}

		m_bHitRLine = m_bHitLLine = FALSE;
		return;
	}

	//򃉃C`惂[h
	if (m_nSel != -1 && m_nSizePoint != -1) {
		pos = point;
		pWidget = pDoc->GetWidget (m_nSel);
		ASSERT (pWidget != NULL);
		rect = pWidget->GetRect ();

		//ResizëɃJ[\
		switch(m_nSizePoint) {
		case	0:
			m_ptFrom = CPoint(rect.right, rect.bottom);
			break;
		case	1:
			m_ptFrom = CPoint(rect.right, rect.top);
			break;
		case	2:
			m_ptFrom = CPoint(rect.left, rect.top);
			break;
		case	3:
			m_ptFrom = CPoint(rect.left, rect.bottom);
			break;
		}
		m_ptTo = pos;
		SetCapture ();
		m_bSizeMode = TRUE;
		return;
	}

	//WidgetI[h
	if (!m_bLineMode && nCount) {
		// Find out whether a widget was clicked.
		bHit = FALSE;
		for (i=nCount - 1; i>=0 && !bHit; i--) {
			pWidget = pDoc->GetWidget (i);
			if (pWidget->PtInWidget (point)) {
				bHit = TRUE;
				pWidget->SetSel( TRUE );
			}
			else
				pWidget->SetSel( FALSE );
		}

		// If no widget was clicked, change the selection to NULL and exit.
		if (!bHit) {
			//ubNO
			m_nSel = -1;
			pDoc->UpdateAllViews (NULL);
			//InvalidateRect (NULL, FALSE);
		}
		else {
			// Select the widget that was clicked.
			int nWidgetIndex = i + 1;

			if (m_nSel != nWidgetIndex) {
				m_nSel = nWidgetIndex;
				pDoc->UpdateAllViews (NULL);
			}

			// Begin a drag-and-drop operation involving the selected widget.
			hData = ::GlobalAlloc (GMEM_MOVEABLE, sizeof (WIDGETINFO));

			WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
			pWidget = pDoc->GetWidget (nWidgetIndex);
			ASSERT (pWidget != NULL);
			rect = pWidget->GetRect ();
			pWidgetInfo->cx = point.x - rect.left;
			pWidgetInfo->cy = point.y - rect.top;
			pWidgetInfo->id = pWidget->GetId();
			char name[256];
			pWidget->GetName(pWidgetInfo->id, name);
			strcpy(pWidgetInfo->name, name);
			pWidgetInfo->color = pWidget->GetColor ();
			pWidgetInfo->direction = pWidget->GetDirection();
			strcpy(pWidgetInfo->matrix, (LPCTSTR)pWidget->GetMatrix());
			pWidgetInfo->width = rect.Width();
			pWidgetInfo->height = rect.Height();
			pWidgetInfo->inport = pWidget->GetInport();
			pWidgetInfo->outport = pWidget->GetOutport();
			strcpy(pWidgetInfo->bmp ,(LPCTSTR)pWidget->GetBitmap());
			//ړɂp[^[ۑ
			pWidgetInfo->pParamArray = pWidget->GetParamPointer();
			//ړɂ郉Cۑ
			SaveWidgetLine(nWidgetIndex);
			//Subsystem
			if(pWidget->GetId() == M_SUBSYSTEM) {
				pWidgetInfo->pDoc = NULL;
				pWidgetInfo->pSubsysArray = (CPtrArray*)pWidget/*->GetSubsysPointer()*/;
			}
			else {
				pWidgetInfo->pDoc = NULL;
				pWidgetInfo->pSubsysArray = NULL;
			}
			//CELLg
			pWidgetInfo->junction = pWidget->GetJunction();
			pWidgetInfo->connect = pWidget->GetConnect();
			//Scope
			pWidgetInfo->pScopeWnd = pWidget->GetScope();
			pWidgetInfo->pScopeArray = pWidget->GetScopePointer();

			::GlobalUnlock (hData);

			//TODO:`FbNKv
			UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
			//nFormat = pDoc->m_nFormat;
			ods.CacheGlobalData (nFormat, hData);

			int nOldSel = m_nSel;
			DROPEFFECT de = ods.DoDragDrop (DROPEFFECT_COPY | DROPEFFECT_MOVE);

			if (de == DROPEFFECT_MOVE) {
				pDoc->RemoveWidget (nWidgetIndex);
				nCount = pDoc->GetWidgetCount ();
				if (nOldSel == m_nSel || nCount == 0)
					m_nSel = -1;
				else if (m_nSel >= nCount)
					m_nSel = nCount - 1;
				//WidgetړɊ֌W郉C`
				if(m_moveArray.GetSize() > 0) {
					LoadWidgetLine(m_nSel, nWidgetIndex);
				}
				//!!!! dv
				//ړÎőIƋɁA
				//ExtncsTreeĕ`悷
				m_nSel = -1;
				pDoc->UpdateAllViews (NULL, 0x6A);
			}
			return;
		}
	}
	//CI[h
	if (!m_bLineMode && lCount) {
		// Find out whether a line was clicked.
		bHit = FALSE;
		for (i=lCount - 1; i>=0 && !bHit; i--) {
			pLine = pDoc->GetLine (i);
			if (pLine->PtInLine (point)) {
				if(m_bCtrlKey) {
					bHit = TRUE;
					pLine->SetSel( TRUE );
				}
				else {
					if(pLine->GetType() == LINE_MIDST) {
						bHit = TRUE;
						pLine->SetSel( TRUE );
					}
					else
						pLine->SetSel(FALSE);
				}
			}
			else
				pLine->SetSel( FALSE );
		}

		// If no widget was clicked, change the selection to NULL and exit.
		if (!bHit) {
			//CO
			m_lSel = -1;
			pDoc->UpdateAllViews (NULL);
			//InvalidateRect (NULL, FALSE);
		}
		else {
			//CtrlL[̏ԂŏقȂ
			if(m_bCtrlKey) {
				//ApLineɂ́AsourceubN񂪂
				m_lSel = i + 1;		//iԖڂ̃CI
				m_nWidgetRLine = pLine->GetSblk();
				pos = point;
				m_ptFrom = pos;
				m_ptTo = pos;
				//I+J[\
				SetCursor (m_hCross);
				SetCapture ();
				//Line`惂[h
				m_bLineMode = TRUE;
				nMouse = (int)m_mouseArray.GetSize();
				if(nMouse > 0) {
					for (i=0; i<nMouse; i++)
						delete (PARAMWNDINFO*) m_mouseArray.GetAt (i);
					m_mouseArray.RemoveAll();
				}
			}
			else {
				//iԖڂ̃CI
				int nLineIndex = i + 1;
				if (m_lSel != nLineIndex) {
					m_lSel = nLineIndex;
					pDoc->UpdateAllViews (NULL);
				}
				//ڑ̂̂I
				sbk = pLine->GetSblk();
				for(i = 0; i < lCount; i++) {
					pLine = pDoc->GetLine (i);
					if(sbk == pLine->GetSblk())
						pLine->SetSel( TRUE );
				}
				InvalidateRect (NULL, FALSE);
				// Begin a drag-and-drop operation involving the selected widget.
				hData = ::GlobalAlloc (GMEM_MOVEABLE, sizeof (LINEINFO));

				LINEINFO* pLineInfo = (LINEINFO*) ::GlobalLock (hData);
				pLine = pDoc->GetLine (nLineIndex);
				ASSERT (pLine != NULL);
				pLineInfo->spt = pLine->GetSpos();
				pLineInfo->ept = pLine->GetEpos();
				pLineInfo->arrow = pLine->GetArrow();
				pLineInfo->color = pLine->GetColor ();
				pLineInfo->sblk = pLine->GetSblk();
				pLineInfo->eblk = pLine->GetEblk();
				pLineInfo->index = pLine->GetIndex();
				pLineInfo->inport = pLine->GetInport();
				pLineInfo->outport = pLine->GetOutport();
				pLineInfo->type = pLine->GetType();
				pLineInfo->junction = pLine->GetJunction();

				::GlobalUnlock (hData);

				//TODO:`FbN
				UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
				//nFormat = pDoc->m_nFormat;
				ods.CacheGlobalData (nFormat, hData);

				int nOldSel = m_lSel;
				DROPEFFECT de = ods.DoDragDrop (DROPEFFECT_COPY | DROPEFFECT_MOVE);

				if (de == DROPEFFECT_MOVE) {
					//pDoc->RemoveLine (nLineIndex);
					pDoc->RemoveLineAt (nLineIndex);
					lCount = pDoc->GetLineCount ();
					if (nOldSel == m_lSel || lCount == 0)
						m_lSel = -1;
					else if (m_lSel >= lCount)
							m_lSel = lCount - 1;
					pDoc->UpdateAllViews (NULL);
				}
				return;

			}
		}
	}
	//̈I[h
	m_ptFrom = point;
	m_ptTo = point;
	SetCapture ();
	m_bAreaMode = TRUE;
}

void CExtncsView::SaveWidgetLine(int widget)
{
	CExtncsDoc* pDoc = GetDocument();
	CLine* pLine;
	int i,lCount,sblk,eblk,inport,outport,index,port;
	MOVELINE* pItem;
	CPoint epos;

	//NA
	lCount = (int)m_moveArray.GetSize();
	if(lCount > 0) {
		for (i=0; i<lCount; i++)
			delete (MOVELINE*) m_moveArray.GetAt (i);
		m_moveArray.RemoveAll();
	}

	//	Widgetւ̓̓C
	//	C̏o͐悪widgetł̂
	lCount = pDoc->GetLineCount();
	inport = -1;
	for(i = 0; i < lCount; i++) {
		pLine = pDoc->GetLine( i );
		eblk = pLine->GetEblk();	//C̏o͒[ĂCELL
		if(eblk == widget) {
			port = pLine->GetInport();
			if(port != inport) {
				inport = port;
				try {
					pItem = new MOVELINE;
				}
				catch (CMemoryException* e) {
					AfxMessageBox (_T ("Out of memory"));
					if (pItem != NULL)
						delete pItem;
					e->Delete ();
					return;
				}
				//ݒ
				pItem->type = 0;		//Widgetւ̓͂
				pItem->eblk = eblk;
				pItem->sblk = pLine->GetSblk();
				pItem->s_arrow = pLine->GetArrow();
				pItem->inport = pLine->GetInport();
				pItem->outport = pLine->GetOutport();
				if(pItem->outport == -1) {	//_̃C
					pItem->bpt = pLine->GetSpos();
					epos = pLine->GetEpos();
					if(pItem->bpt.x == epos.x)
						pItem->btype = HORZ_LINE;
					else
						pItem->btype = VERT_LINE;
				}
				else
					pItem->bpt = CPoint(-1,-1);
				pItem->junction = pLine->GetJunction();
				//widget͍폜̂ŁA傫ꍇ͏C
				if(pItem->junction > widget)
					pItem->junction -= 1;
				index = (int)m_moveArray.Add (pItem);
			}
			else {
				pItem->e_arrow = pLine->GetArrow();
			}
		}
	}
	//indexWidget̏o̓C
	outport = -1;
	for(i = 0; i < lCount; i++) {
		pLine = pDoc->GetLine( i );
		sblk = pLine->GetSblk();
		if(sblk == widget) {
			port = pLine->GetOutport();
			if(port != outport) {
				outport = port;
				try {
					pItem = new MOVELINE;
				}
				catch (CMemoryException* e) {
					AfxMessageBox (_T ("Out of memory"));
					if (pItem != NULL)
						delete pItem;
					e->Delete ();
					return;
				}
				//ݒ
				pItem->type = 1;		//Widgetւ̓͂
				pItem->eblk = pLine->GetEblk();
				pItem->sblk = sblk;
				pItem->s_arrow = pLine->GetArrow();
				pItem->inport = pLine->GetInport();
				pItem->outport = pLine->GetOutport();
				if(pItem->outport == -1) {
					pItem->bpt = pLine->GetSpos();
					epos = pLine->GetEpos();
					if(pItem->bpt.x == epos.x)
						pItem->btype = HORZ_LINE;
					else
						pItem->btype = VERT_LINE;
				}
				else
					pItem->bpt = CPoint(-1,-1);
				pItem->junction = pLine->GetJunction();
				//widget͍폜̂ŁA傫ꍇ͏C
				if(pItem->junction > widget)
					pItem->junction -= 1;
				index = (int)m_moveArray.Add (pItem);	
			}
			else {
				pItem->e_arrow = pLine->GetArrow();
			}
		}
	}

}

void CExtncsView::OnEditCut() 
{
	if (m_nSel != -1 || m_lSel != -1) {
		OnEditCopy ();
		OnEditDelete ();
	}	
}

void CExtncsView::OnUpdateEditCut(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (m_nSel != -1 || m_lSel != -1);
}

void CExtncsView::OnEditCopy() 
{
	if (m_nSel != -1) {
		//
		// Copy data describing the currently selected widget to a
		// global memory block.
		//
		HANDLE hData = ::GlobalAlloc (GMEM_MOVEABLE, sizeof (WIDGETINFO));

		WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
		CExtncsDoc* pDoc = GetDocument ();
		CWidget* pWidget = pDoc->GetWidget (m_nSel);
		ASSERT (pWidget != NULL);
		CRect rect = pWidget->GetRect ();
		rect = pWidget->GetRect ();
		pWidgetInfo->x = rect.left + rect.Width() / 2;
		pWidgetInfo->y = rect.top + rect.Height() / 2;
		pWidgetInfo->cx = rect.right - rect.left;
		pWidgetInfo->cy = rect.bottom - rect.top;
		pWidgetInfo->id = pWidget->GetId();
		char name[_MAX_PATH];
		pWidget->GetName(pWidgetInfo->id, name);
		strcpy(pWidgetInfo->name, name);

		pWidgetInfo->color = pWidget->GetColor ();
		pWidgetInfo->direction = pWidget->GetDirection();
		strcpy(pWidgetInfo->matrix, (LPCTSTR)pWidget->GetMatrix());
		pWidgetInfo->width = rect.Width();
		pWidgetInfo->height = rect.Height();
		pWidgetInfo->inport = pWidget->GetInport();
		pWidgetInfo->outport = pWidget->GetOutport();
		strcpy(pWidgetInfo->bmp ,(LPCTSTR)pWidget->GetBitmap());
		//p[^[
		pWidgetInfo->pParamArray = pWidget->GetParamPointer();
		//ړɂ郉Cۑ
		//SaveWidgetLine(nWidgetIndex);
		//Subsystem
		if(pWidget->GetId() == M_SUBSYSTEM) {
			pWidgetInfo->pDoc = NULL;
			pWidgetInfo->pSubsysArray = (CPtrArray*)pWidget/*->GetSubsysPointer()*/;
		}
		else {
			pWidgetInfo->pDoc = NULL;
			pWidgetInfo->pSubsysArray = NULL;
		}

		::GlobalUnlock (hData);

		//
		// Place the widget on the clipboard.
		//
		COleDataSource* pods = new COleDataSource;
		//TODO:`FbN
		UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
		//UINT nFormat = pDoc->m_nFormat;
		pods->CacheGlobalData (nFormat, hData);
		pods->SetClipboard ();
	}
	
}

void CExtncsView::OnUpdateEditCopy(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (m_nSel != -1);		
}

void CExtncsView::OnEditPaste() 
{
	// Local
	int	x,y,id,direction,row,column,width,height,inport,outport;
	char name[_MAX_PATH];
	CString matrix, bmpName;
	COLORREF color;
	CPtrArray* pSubsysArray;
	CSubsysDoc* pSubsysDoc;
	CWidget* pWidget;
	CPoint newpoint;
	CPtrArray* pInOut;
	CPtrArray* pParamArray;
	int i,nParam;
	char strValue[100][16];
	PARAMINFO* pItem;
	CWidget* pTargetWidget;

	//
	// Create a COleDataObject and attach it to the clipboard.
	//
	COleDataObject odo;
	odo.AttachClipboard ();

	//
	// Retrieve the HGLOBAL from the clipboard and create a widget.
	//
	CExtncsDoc* pDoc = GetDocument ();
	//TODO:`FbN
	UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
	//UINT nFormat = pDoc->m_nFormat;
	HGLOBAL hData = odo.GetGlobalData (nFormat);

	if (hData != NULL) {
		WIDGETINFO* pWidgetInfo = (WIDGETINFO*) ::GlobalLock (hData);
		x = pWidgetInfo->x;
		y = pWidgetInfo->y;
		color = pWidgetInfo->color;
		id = pWidgetInfo->id;
		direction = pWidgetInfo->direction;
		strcpy(name, pWidgetInfo->name);
		//OAO݂΃CfbNXt
		strcat(name, "_");
		pDoc->ChangeName(name);
		matrix = pWidgetInfo->matrix;
		row = pDoc->GetMatrixRow(pWidgetInfo->matrix);
		column = pDoc->GetMatrixColumn(pWidgetInfo->matrix);
		width = pWidgetInfo->width;
		height = pWidgetInfo->height;
		inport = pWidgetInfo->inport;
		outport = pWidgetInfo->outport;
		pParamArray = pWidgetInfo->pParamArray;		//parameter
		pSubsysArray = pWidgetInfo->pSubsysArray;	//subsystem
		pSubsysDoc = (CSubsysDoc *)pWidgetInfo->pDoc;
		bmpName = pWidgetInfo->bmp;

		::GlobalUnlock (hData);
		::GlobalFree (hData);

		//parameterɊւ鏈
		nParam = (int)pParamArray->GetSize();
		if(nParam > 0) {
			for (i=0; i<nParam; i++) {
				//RootVXéAl̂
				pItem = (PARAMINFO*) pParamArray->GetAt (i);
				strcpy(strValue[i], pItem->strValue);
			}
		}

		//matrixl傫ɂ
		if(row*column != 1) {
			width = pWidgetInfo->width / column;
			height = pWidgetInfo->height / row;
		}
		newpoint.x = x; newpoint.y = y;
		//rootsubsystemmFadd
		pTargetWidget = pDoc->m_pTargetWidget;
		if(!pTargetWidget) {
			if(nParam > 0) {
				m_nSel = pDoc->AddWidget2(id, newpoint, name,
					direction, matrix, nParam, strValue, width, height);
			}
			else {
				m_nSel = pDoc->AddWidget(id, newpoint, name,
					direction, matrix, width, height);
			}
		}
		else {
			if(nParam > 0) {
				m_nSel = pDoc->AddSubWidget2(pTargetWidget, id, newpoint, name,
					direction, matrix, nParam, strValue, width, height);
			}
			else {
				m_nSel = pDoc->AddSubWidget(pTargetWidget, id, newpoint, name,
					direction, matrix, width, height);
			}
		}

		//|[gݒ肵Ă
		pWidget = (CWidget*)pDoc->GetWidget(m_nSel);
		//ړꍇłA|[gԂ͕ێĂ
		pWidget->SetInport(inport);
		pInOut = pWidget->GetInportName();
		if(inport != pInOut->GetSize())		//͐`FbN
			pWidget->ChangeInportName();
		pWidget->SetOutport(outport);
		pInOut = pWidget->GetOutportName();
		if(outport != pInOut->GetSize())	//o͐`FbN
			pWidget->ChangeOutportName();
		//Subsystemt
		if(pWidget->GetId() == M_SUBSYSTEM) {
			//ǉ
			CopySubsystem(pWidget, pSubsysArray);
		}
		//Bitmap
		if(bmpName.IsEmpty() == 0)	//bitmapݒ肳Ă
			pWidget->SetBitmap(bmpName);

		if(pWidget->GetId() == M_SUBSYSTEM)
			pDoc->UpdateAllViews(NULL, 0x6A);
		else
			pDoc->UpdateAllViews (NULL);

		//Flush
		odo.Release();
	}	
}

void CExtncsView::OnUpdateEditPaste(CCmdUI* pCmdUI) 
{
	CExtncsDoc* pDoc = GetDocument ();
	//TODO:`FbN
	UINT nFormat = g_pExtncsMain->GetClipboardFormat ();
	//UINT nFormat = pDoc->m_nFormat;
	pCmdUI->Enable (::IsClipboardFormatAvailable (nFormat));	
	
}

void CExtncsView::OnEditDelete() 
{
	CWidget *pWidget;
	CScopeFrame* pScopeFrame;
	CExtncsDoc* pDoc = GetDocument ();

	if (m_nSel != -1) {
		//IĂWidget
		pWidget = pDoc->GetWidget(m_nSel);
		//֌WĂscopeAsubsystemAp[^폜
		pScopeFrame = (CScopeFrame*)pWidget->GetScope();
		if(pScopeFrame)
			pScopeFrame->DestroyWindow();
		//Widget폜
		pDoc->RemoveWidget (m_nSel);
		m_nSel = -1;

		//svɂȂM_GAPAM_SYNAPSE폜
		JuncWidgetDelete();
		pDoc->UpdateAllViews (NULL, 0x6A);

		//ăRpC
		pDoc->m_bCodeGen = FALSE;
		pDoc->m_bCodeCompile = FALSE;
		//֌WĂscopeAsubsystemAp[^폜
		//for(scope = 0; scope < m_nScopeMax; scope++) {
		//	pTmpWidget = ((CScopeFrame *)m_pScopeFrame[scope])->m_pWidget;
		//	if(pWidget == pTmpWidget)
		//		m_pScopeFrame[scope]->DestroyWindow();
		//}
	}

	if (m_lSel != -1) {
		int i,lCount;
		CLine *pLine;

		lCount = pDoc->GetLineCount();
		for (i=lCount - 1; i>=0 ; i--) {
			pLine = pDoc->GetLine (i);
			if(pLine->GetSel())
				pDoc->RemoveLine (i);
		}
		m_lSel = -1;
		//svɂȂM_GAPAM_SYNAPSE폜
		JuncWidgetDelete();
		pDoc->UpdateAllViews (NULL);

		//ăRpC
		pDoc->m_bCodeGen = FALSE;
		pDoc->m_bCodeCompile = FALSE;
	}	
}

void CExtncsView::OnUpdateEditDelete(CCmdUI* pCmdUI) 
{
	// WidgetLineIĂꍇAj[L
	pCmdUI->Enable (m_nSel != -1 || m_lSel != -1);		
}

//svɂȂM_GAPAM_SYNAPSE폜
void CExtncsView::JuncWidgetDelete()
{
	CExtncsDoc* pDoc = GetDocument();
	int i,j,lCount,nCount,type;
	CWidget* pWidget;
	CLine* pLine;
	BOOL del;

	lCount = pDoc->GetLineCount();
	nCount = pDoc->GetWidgetCount();
	for(i = 0; i < nCount;) {
		pWidget = pDoc->GetWidget(i);
		//id = pWidget->GetId();
		//if(id != M_GAP && id != M_SYNAPSE) {
		type = pWidget->GetType();
		if(type != MODULE_GAP && type != MODULE_SYNAPSE) {
			i++;
			continue;
		}
		del = TRUE;
		for(j = 0; j < lCount; j++) {
			pLine = pDoc->GetLine(j);
			if(pLine->GetType() == LINE_START) {
				if(pLine->GetJunction() == i) {
					del = FALSE;
					break;
				}
			}
		}
		if(del) {
			//gpĂȂ
			//xAiԖWidget邽߂i{{Ȃ
			pDoc->RemoveWidget(i);
			lCount = pDoc->GetLineCount();
			nCount = pDoc->GetWidgetCount();
			if(i >= nCount)
				break;
		}
		else
			i++;
	}
}

void CExtncsView::OnKillFocus(CWnd* pNewWnd) 
{
	CScrollView::OnKillFocus(pNewWnd);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	InvalidateRect (NULL, FALSE);		
}

void CExtncsView::OnSetFocus(CWnd* pOldWnd) 
{
	CScrollView::OnSetFocus(pOldWnd);
	
	// TODO: ̈ʒuɃbZ[W nhp̃R[hǉĂ
	InvalidateRect (NULL, FALSE);		
}

BOOL CExtncsView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	BOOL flag;
	CExtncsDoc *pDoc = GetDocument();

	if(!pDoc->m_DragImageFile) {
		//if(m_bLineMode) {
		//	SetCursor (m_hArrow);
		//	return TRUE;
		//}
		if(m_bHitRLine || m_bHitLLine) {
			//̃NX΂ȂŖ߂
		    //m_hArrow = SetCursor (m_hCross);
		    SetCursor (m_hCross);
			return TRUE;
		}
		else if(m_nSizePoint != -1) {
			//ResizeJ[\
			if(m_nSizePoint == 1 || m_nSizePoint == 3)
				SetCursor (m_hRSize);
			else
				SetCursor (m_hLSize);
			return TRUE;
		}
		else {
			SetCursor(m_hArrow);
			return TRUE;
		}
	}
	if(pDoc->m_DragImageFile) {
		SetCursor (m_hArrow);
		//ShowCursor(FALSE);
		m_pDragImage = pDoc->m_DragImageFile;
		flag = m_pDragImage->BeginDrag(0, CPoint(0, 0));
		flag = m_pDragImage->DragEnter(NULL/*this*/, CPoint(0,0));
		//::SetCapture(this->GetSafeHwnd());
		return TRUE;
	}
	
	return CScrollView::OnSetCursor(pWnd, nHitTest, message);
}

void CExtncsView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CExtncsDoc *pDoc = GetDocument();
	int nCount = pDoc->GetWidgetCount ();
	CPoint newpos;
	int	outIndex,inIndex,nResize;
	CRect rect;
	CWidget *pWidget;

	//
	// Convert the click point to logical coordinates.
	//
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	if(!m_bSizeMode && !m_bLineMode && !pDoc->m_DragImageFile) {
		//C`łȂABlockViewhbOłȂ
		if (nCount) {
			//
			// Find out whether a widget was clicked.
			//
			int i;
			m_bHitRLine = m_bHitLLine = FALSE;
			m_nSizePoint = -1;
			for (i=nCount - 1; i>=0 && !m_bHitRLine; i--) {
				pWidget = pDoc->GetWidget (i);
				//EC
				//if (pWidget->PtInWidget (point)) {
				if ((outIndex = pWidget->PtOnRLine (point)) != FALSE) {
					m_bHitRLine = TRUE;
					m_outIndex = outIndex;
					//
					// Select the widget of line  that was clicked.
					//
					m_nWidgetRLine = i;
					break;
				}
				//C
				//if (pWidget->PtInWidget (point)) {
				if ((inIndex = pWidget->PtOnLLine (point, &newpos)) != FALSE) {
					m_bHitLLine = TRUE;
					m_inIndex = inIndex;
					//
					// Select the widget of line  that was clicked.
					//
					m_nWidgetLLine = i;
					break;
				}
				//Resize_
				if(m_nSel != -1) {
					//WidgetIĂƂ
					if((nResize = pWidget->PtOnResize(point)) != -1) {
						m_nSizePoint = nResize;
					}
				}
			}
		}
	}

	if(m_bLineMode) {
		//C`撆
		if (GetCapture () == this) {
			if (m_ptTo != point) {
				InvertLine (&dc, m_ptFrom, m_ptTo);
				InvertLine (&dc, m_ptFrom, point);
				m_ptTo = point;
				//ڑ`FbN
				CheckConnect(&dc, point);
			}
		}
	}

	if(m_bSizeMode) {
		if (GetCapture () == this) {
			rect = CRect(m_ptFrom.x, m_ptFrom.y, m_ptTo.x, m_ptTo.y);
			rect.NormalizeRect();
			dc.DrawFocusRect(rect);
			rect.SetRect(m_ptFrom.x, m_ptFrom.y, point.x, point.y);
			rect.NormalizeRect();
			dc.DrawFocusRect(rect);
			m_ptTo = point;
		}
	}

	if(pDoc->m_DragImageFile) {
		//BlockViewhbO
		dc.LPtoDP (&point);
		GetWindowRect(&rect);
		newpos.x = rect.left + point.x;
		newpos.y = rect.top + point.y;
		m_pDragImage->DragEnter(NULL, newpos/*point*/);
		m_pDragImage->DragMove(newpos/*point*/);
	}

	if(m_bAreaMode) {
		if (GetCapture () == this) {
			if (m_ptTo != point) {
				InvertRect (&dc, m_ptFrom, m_ptTo);
				InvertRect (&dc, m_ptFrom, point);
				m_ptTo = point;
			}
		}
	}
	
	CScrollView::OnMouseMove(nFlags, point);
}

//
// }EXڑ\ȈʒuɂA͖redɕύX֐
//
void CExtncsView::CheckConnect(CDC* pDC, CPoint pos)
{
	CExtncsDoc *pDoc = GetDocument();
	int nCount = pDoc->GetWidgetCount ();
	CPoint newpos;
	int i,index,ports,direction;
	CWidget* pWidget;
	CRect rect;
	double hstep;
	CPen *oldPen;
	CBrush	*oldBrs;
	CBrush	arrowBrs(RGB(255, 0, 0));
	CPen	arrowPen(PS_SOLID, 1, RGB(255,0,0));
	CBrush	defaultBrs(RGB(0, 0, 0));


	if(m_connectPoint[0].x != -1 && m_connectPoint[0].y != -1) {
		//O`悵
		oldBrs = pDC->SelectObject(&defaultBrs);
		pDC->Polygon(m_connectPoint, 3);
		pDC->SelectObject(oldBrs);
	}
	for (i=nCount - 1; i>=0; i--) {
		pWidget = pDoc->GetWidget (i);
		if (index = pWidget->PtOnLLine (pos, &newpos)) {
			//̐ڑ_̑ύXȂ
			rect = pWidget->GetRect();
			ports = pWidget->GetInport();
			direction = pWidget->GetDirection();
			switch(direction) {
			case	DIR_RIGHT:
				hstep = (double)rect.Height() / (ports + 1);
				m_connectPoint[0].x = rect.left;
				m_connectPoint[0].y = rect.top + (int)(hstep * index + 0.5);
				m_connectPoint[1].x = m_connectPoint[0].x - 5;
				m_connectPoint[1].y = m_connectPoint[0].y - 4;
				m_connectPoint[2].x = m_connectPoint[0].x - 5;
				m_connectPoint[2].y = m_connectPoint[0].y + 4;
			break;

			case	DIR_UP:
				hstep = (double)rect.Width() / (ports + 1);
				m_connectPoint[0].x = rect.left + (int)(hstep * index + 0.5);
				m_connectPoint[0].y = rect.bottom;
				m_connectPoint[1].x = m_connectPoint[0].x - 4;
				m_connectPoint[1].y = m_connectPoint[0].y + 5;
				m_connectPoint[2].x = m_connectPoint[0].x + 4;
				m_connectPoint[2].y = m_connectPoint[0].y + 5;
			break;

			case	DIR_LEFT:
				hstep = (double)rect.Height() / (ports + 1);
				m_connectPoint[0].x = rect.right;
				m_connectPoint[0].y = rect.top + (int)(hstep * index + 0.5);
				m_connectPoint[1].x = m_connectPoint[0].x + 5;
				m_connectPoint[1].y = m_connectPoint[0].y - 4;
				m_connectPoint[2].x = m_connectPoint[0].x + 5;
				m_connectPoint[2].y = m_connectPoint[0].y + 4;
			break;

			case	DIR_DOWN:
				hstep = (double)rect.Width() / (ports + 1);
				m_connectPoint[0].x = rect.left + (int)(hstep * index + 0.5);
				m_connectPoint[0].y = rect.top;
				m_connectPoint[1].x = m_connectPoint[0].x - 4;
				m_connectPoint[1].y = m_connectPoint[0].y - 5;
				m_connectPoint[2].x = m_connectPoint[0].x + 4;
				m_connectPoint[2].y = m_connectPoint[0].y - 5;
			break;
			}
			// `
			oldPen = pDC->SelectObject(&arrowPen);
			oldBrs = pDC->SelectObject(&arrowBrs);
			pDC->Polygon(m_connectPoint, 3);
			pDC->SelectObject(oldBrs);
			pDC->SelectObject(oldPen);
		}
	}
}

void CExtncsView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CExtncsDoc *pDoc = GetDocument();
	int nCount = pDoc->GetWidgetCount ();
	CPoint pos, newpos;
	int i,index,nMouse,nLine,row,column,cx,cy;
	CWidget* pWidget;
	CRect lineRect,rect;
	CLine* pLine;
	int mid;		//W[ID

	// Convert the click point to logical coordinates.
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);
	pos = point;

	if(m_bLineMode && !pDoc->m_DragImageFile) {
		//C[hhbOȂ
		if (GetCapture () == this) {
			::ReleaseCapture ();
			InvertLine (&dc, m_ptFrom, m_ptTo);
			//ڑ悩
			m_bHitLLine = FALSE;
			for (i=nCount - 1; i>=0 && !m_bHitLLine; i--) {
				pWidget = pDoc->GetWidget (i);
				if (index = pWidget->PtOnLLine (pos, &newpos)) {
					m_bHitLLine = TRUE;
					//
					// Select the widget of line  that was clicked.
					//
					m_nWidgetLLine = i;
				}
			}
			if(m_bHitLLine) {
				//m_ptToʒu
				//o^
				if(m_bCtrlKey) {	// Line->WidgetԐڑ
					lineRect.left = m_ptFrom.x;
					lineRect.top = m_ptFrom.y;
					lineRect.right = newpos.x/*m_ptTo.x*/;
					lineRect.bottom = newpos.y/*m_ptTo.y*/;
					pDoc->InsertDivide (lineRect, m_lSel, m_nWidgetRLine, m_nWidgetLLine, index, -1);
					//m_mouseArray𒲂ׂ
					nMouse = (int)m_mouseArray.GetSize();
					//IĂ郉CI
					m_lSel = -1;
					nLine = pDoc->GetLineCount();
					for(i = 0; i < nLine; i++) {
						pLine = pDoc->GetLine(i);
						pLine->SetSel (FALSE);
					}
					pDoc->UpdateAllViews(NULL);
				}
				else {	// Widget->WidgetԐڑ
					//CELL͖
					if(m_nWidgetRLine != m_nWidgetLLine) {
						lineRect.left = m_ptFrom.x;
						lineRect.top = m_ptFrom.y;
						lineRect.right = newpos.x/*m_ptTo.x*/;
						lineRect.bottom = newpos.y/*m_ptTo.y*/;
						pDoc->InsertLine (lineRect, m_nWidgetRLine, m_nWidgetLLine, index, m_outIndex, -1);
						//m_mouseArray𒲂ׂ
						nMouse = (int)m_mouseArray.GetSize();
					}
				}
			}
			//C[hNA
			m_bLineMode = FALSE;
			m_bHitLLine = FALSE;
		}	
	}

	if(m_bSizeMode && !pDoc->m_DragImageFile) {
		//Resize[hhbOȂ
		if (GetCapture () == this) {
			::ReleaseCapture ();
			//g_ɉCellTCYύX
			pWidget = pDoc->GetWidget (m_nSel);
			ASSERT (pWidget != NULL);
			switch (m_nSizePoint) {
			case	0:
				rect = CRect(pos.x, pos.y, m_ptFrom.x, m_ptFrom.y);
				break;
			case	1:
				rect = CRect(pos.x, m_ptFrom.y, m_ptFrom.x, pos.y);
				break;
			case	2:
				rect = CRect(m_ptFrom.x, m_ptFrom.y, pos.x, pos.y);
				break;
			case	3:
				rect = CRect(m_ptFrom.x, pos.y, pos.x, m_ptFrom.y);
				break;
			}
			//TCY𒲐Ăݒ
			row = pWidget->GetCellRow();
			column = pWidget->GetCellColumn();
			if(row*column > 1) {
				cx = rect.Width() / column;
				cx = column * cx;
				cy = rect.Height() / row;
				cy = row * cy;
				rect.right = rect.left + cx;
				rect.bottom = rect.top + cy;
			}
			pWidget->SetRect(rect);
			//ZɐڑĂ郉C̈ʒuύX
			//ړɂ郉Cۑ
			SaveWidgetLine(m_nSel);
			//m_nSelɊ֌W郉C폜
			nLine = pDoc->GetLineCount();
			for (i=nLine - 1; i>=0 ; i--) {
				pLine = pDoc->GetLine(i);
				if(pLine->GetSblk() == m_nSel) {
					pDoc->RemoveLine(i);
				}
				if(pLine->GetEblk() == m_nSel) {
					pDoc->RemoveLine(i);
				}
			}
			//C
			LoadWidgetLine(m_nSel, nCount+1);
			//I
			m_nSel = -1;
			if(pWidget->GetSel())
				pWidget->SetSel (FALSE);
			//ĕ`
			pDoc->UpdateAllViews (NULL);

			//Resize[hNA
			m_bSizeMode = FALSE;
			m_nSizePoint = -1;
		}
	}

	if(!m_bHitRLine && pDoc->m_DragImageFile) {
		//BlockView̃hbOI
		m_pDragImage->EndDrag();
		//::ReleaseCapture();
		//C[W폜
		delete m_pDragImage;
		//TvoגȂ̂łubNł̎gp𐧌
		mid = pDoc->m_DragItemIndex;
		if(/*mid == M_SHELL || mid == M_FILE ||*/ mid == M_IMAGE
			/*|| mid == M_XY*/ || mid == M_TITLE || mid == M_AD3120 || mid == M_DA3338) {
			//bZ[W\Ė
			MessageBox("Now, it cannot be used. ",PACKAGE_STRING,MB_ICONWARNING | MB_OK);
		}
		else if (mid == M_INPORT || mid == M_OUTPORT) {
			//bZ[W\Ė
			MessageBox("It cannot be used on this window. ",PACKAGE_STRING,MB_ICONWARNING | MB_OK);
		}
		else {
			//Widget쐬AGapSynapseO[v͓삪قȂ
			//if(mid == M_GAP || mid == M_SYNAPSE) {
			if(pDoc->m_DragItemGroup == MODULE_SYNAPSE ||
				pDoc->m_DragItemGroup == MODULE_GAP) {
				if((index = CheckIntersectWidget(point)) != -1) {
					//Lineɑݒ
					pDoc->InsertWidgetJunc(pDoc->m_DragItemIndex, point, index,
						pDoc->m_DragItemGroup);
				}
			}
			else {
				if(!pDoc->InsertWidget(pDoc->m_DragItemIndex, point)) {
					//bZ[W\Ė
					MessageBox("It has broken. ",PACKAGE_STRING,MB_ICONWARNING | MB_OK);
				}
				else {
					//ExtncsViewSubsystemVKzu
					if(mid == M_SUBSYSTEM) {
						pDoc->UpdateAllViews(NULL, 0x6A);
					}
				}
			}
		}
		pDoc->m_DragImageFile = NULL;
		pDoc->m_bCodeGen = NULL;
		pDoc->m_bCodeCompile = NULL;
	}

	if(m_bAreaMode) {
		if (GetCapture () == this) {
			::ReleaseCapture ();
			//m_bAreaMode = FALSE;

			//̈Widget܂܂Ă邩H
			if(AreaInWidgets(m_ptFrom, m_ptTo)) {
				//|bvAbvj[J
				// }EX|C^XN[Wɕϊ
				this->ClientToScreen( &point );
				// gɃtH[JXݒ
				SetForegroundWindow();
				// |bvAbvj[̍쐬
				CMenu menu;
				// IDR_MENUPOPUP_ESLMON̓j[̃\[XID
				menu.LoadMenu( IDR_POPUP_AREA );
				CMenu* pPopup = menu.GetSubMenu( 0 );
				// |bvAbvj[\
				pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
						point.x, point.y, this);
				// LoadMenuJ
				menu.DestroyMenu();
				// IԂɂ
				pDoc->UpdateAllViews(NULL);
			}
			InvertRect (&dc, m_ptFrom, m_ptTo);
		}
	}
//noinsert:	
	CScrollView::OnLButtonUp(nFlags, point);
}

// ̈WidgetSɊ܂܂Ă邩
BOOL CExtncsView::AreaInWidgets(POINT from, POINT to)
{
	int nCount,i,obj,bHit;
	CExtncsDoc* pDoc = GetDocument();
	CWidget* pWidget;
	char buf[_MAX_PATH];
	CRect rect = CRect(from, to);

	obj = 0;
	nCount = pDoc->GetWidgetCount ();
	for (i=nCount - 1; i>=0 ; i--) {
		pWidget = pDoc->GetWidget (i);
		pWidget->SetSel(FALSE);
		bHit = pWidget->AreaInWidget (rect);
		if(bHit == WIDGET_CROSS) {
			obj = 0;
			sprintf(buf,"%s crossed.", pWidget->GetName());
			MessageBox(buf, "Extncs", MB_OK | MB_ICONERROR);
			break;
		}
		else if(bHit == WIDGET_IN) {
			obj++;
			pWidget->SetSel(TRUE);
		}
	}
	if(obj > 0)
		return TRUE;
	else {
		//SĂ̑I
		for (i=nCount - 1; i>=0 ; i--) {
			pWidget = pDoc->GetWidget (i);
			pWidget->SetSel(FALSE);
		}
		return FALSE;
	}
}

void CExtncsView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	int nCount,i;
	BOOL bHit,bRet;
	CWidget* pWidget;
	CMenu menu;
	CPtrArray* p;
	CExtncsDoc *pDoc = GetDocument();

	//XN[ɑΉ
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	// Widgetŉ
	nCount = pDoc->GetWidgetCount ();
	bHit = FALSE;
	for (i=nCount - 1; i>=0 && !bHit; i--) {
		pWidget = pDoc->GetWidget (i);
		if (pWidget->PtInWidget (point)) {
			bHit = TRUE;
			break;
		}
	}

	if(!bHit)
		return;
	//j[\̂ŁAݒ
	m_bHitRLine = m_bHitLLine = FALSE;
	SetCursor (m_hArrow);
	
	//
	dc.LPtoDP (&point);
	// IDR_WIDGET\Widget
	m_desIndex = i;
	m_popupPos = point;
	// }EX|C^XN[Wɕϊ
	this->ClientToScreen( &point );
	// gɃtH[JXݒ
	SetForegroundWindow();
	// |bvAbvj[̍쐬
	// IDR_MENUPOPUP_ESLMON̓j[̃\[XID
	bRet = menu.LoadMenu( IDR_POPUP_WIDGET );
	if(bRet) {
		// Scopej[
		if(pWidget->GetId() == M_SUBSYSTEM)
			menu.EnableMenuItem(ID_WIDGET_SCOPE, MF_GRAYED);
		else {
			menu.EnableMenuItem(ID_WIDGET_SCOPE, MF_ENABLED);
			//Scopeł鐔mF
			p = pWidget->GetScopePointer();
			if(p->GetSize() == 0)
				menu.EnableMenuItem(ID_WIDGET_SCOPE, MF_GRAYED);
		}
		// Libraryj[
		if(m_nSel == -1)
			menu.EnableMenuItem(ID_WIDGET_LIB, MF_GRAYED);
		else
			menu.EnableMenuItem(ID_WIDGET_LIB, MF_ENABLED);
		// Widgetgj[
		if(m_pWidgetExtend)
			menu.EnableMenuItem(ID_WIDGET_EXTEND, MF_GRAYED);
		else
			menu.EnableMenuItem(ID_WIDGET_EXTEND, MF_ENABLED);
		// Rotatej[
		switch(pWidget->GetDirection()) {
		case	DIR_RIGHT:
			menu.CheckMenuItem(ID_WIDGET_0, MF_CHECKED);
			break;
		case	DIR_UP:
			menu.CheckMenuItem(ID_WIDGET_90, MF_CHECKED);
			break;
		case	DIR_LEFT:
			menu.CheckMenuItem(ID_WIDGET_180, MF_CHECKED);
			break;
		case	DIR_DOWN:
			menu.CheckMenuItem(ID_WIDGET_270, MF_CHECKED);
			break;
		}

		CMenu* pPopup = menu.GetSubMenu( 0 );
		// |bvAbvj[\
		pPopup->TrackPopupMenu( TPM_LEFTALIGN | TPM_RIGHTBUTTON,
				point.x, point.y, this);
		// LoadMenuJ
		menu.DestroyMenu();
	}

	CScrollView::OnRButtonDown(nFlags, point);
}

//C
void CExtncsView::OnWidgetLine() 
{
	// fBXeBl[V	Widgetm_desIndex
	// \[XWidgetm_srcIndex
	if(m_srcIndex < 0 || m_desIndex < 0)
		return;
	CWidget* pWidget;
	CRect rect,line;
	CPoint src,des;
	CExtncsDoc* pDoc = GetDocument();
	pWidget = pDoc->GetWidget (m_srcIndex);
	rect = pWidget->GetRect();
	line.left = rect.right;
	line.top = rect.top + 16;
	pWidget = pDoc->GetWidget (m_desIndex);
	rect = pWidget->GetRect();
	line.right = rect.left;
	line.bottom = rect.top + 16;
	pDoc->InsertLine(line, m_srcIndex, m_desIndex, 1, 1, -1);	
}

void CExtncsView::OnUpdateWidgetLine(CCmdUI* pCmdUI) 
{
	//IĂWidget݂Ȃꍇ͕s	
	int nCount,i;
	BOOL bSelected;
	CExtncsDoc *pDoc = GetDocument();

	// Widgetŉ
	nCount = pDoc->GetWidgetCount ();
	bSelected = FALSE;
	m_srcIndex = -1;
	for (i=nCount - 1; i>=0 && !bSelected; i--) {
		CWidget* pWidget = pDoc->GetWidget (i);
		if (pWidget->GetSel ()) {
			bSelected = TRUE;
			m_srcIndex = i;
			break;
		}
	}
	if(bSelected)
		pCmdUI->Enable(TRUE);
	else
		pCmdUI->Enable(FALSE);
}

void CExtncsView::InvertLine(CDC *pDC, POINT from, POINT to)
{
    int nOldMode = pDC->SetROP2 (R2_NOT);
    pDC->MoveTo (from);
    pDC->LineTo (to);
    pDC->SetROP2 (nOldMode);
}

void CExtncsView::InvertRect(CDC *pDC, POINT from, POINT to)
{
	//
	POINT tmp;
	//CPen pen,*pOldPen;
    int nOldMode = pDC->SetROP2 (R2_NOT);

	//pen.CreatePen(PS_DOT, 1, RGB(0,255,0));
	//pOldPen = pDC->SelectObject (&pen);
    pDC->MoveTo (from);
	tmp.x = from.x; tmp.y = to.y;
    pDC->LineTo (tmp);
	pDC->LineTo (to);
	tmp.x = to.x; tmp.y = from.y;
	pDC->LineTo (tmp);
    pDC->LineTo (from);

	//pDC->SelectObject (pOldPen);
	//pen.DeleteObject();
    pDC->SetROP2 (nOldMode);
}

void CExtncsView::OnExtncsStart() 
{
	ExtncsStart(0, 0L);
}

LRESULT CExtncsView::ExtncsStart(WPARAM wParam, LPARAM lParam) 
{
	//Harware infomation file
	SimuInit();
	//ScriptƎs
	SimuExe();
	//TRUEԂ
	return 0L;
}

void CExtncsView::OnUpdateExtncsStart(CCmdUI* pCmdUI) 
{
	CExtncsDoc *pDoc = GetDocument();
	if(!pDoc->m_bCodeGen || !pDoc->m_bCodeCompile)
		pCmdUI->Enable(FALSE);
	else {
		pCmdUI->Enable(TRUE);
		if(!m_fSimuState)
			pCmdUI->SetCheck(0);
		else
			pCmdUI->SetCheck(1);
	}
}

void CExtncsView::OnExtncsStop() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	simu_exit = TRUE;		//~tO𗧂Ă
	
}

void CExtncsView::OnUpdateExtncsStop(CCmdUI* pCmdUI) 
{
	CExtncsDoc *pDoc = GetDocument();
	if(!pDoc->m_bCodeGen || !pDoc->m_bCodeCompile)
		pCmdUI->Enable(FALSE);
	else {
		pCmdUI->Enable(TRUE);
		if(m_fSimuState)
			pCmdUI->SetCheck(0);
		else
			pCmdUI->SetCheck(1);
	}	
}

void CExtncsView::OnExtncsCondition() 
{
	ExtncsCondition(0, 0L);
}

LRESULT CExtncsView::ExtncsCondition(WPARAM wParam, LPARAM lParam)
{
	//
	CRect rect;
	GetWindowRect(rect);

	CSimuWnd *pSimuWnd = new CSimuWnd;
	if(!pSimuWnd->Create( "Setting conditionss", WS_OVERLAPPEDWINDOW,
		CRect(rect.top, rect.left, 480, 320), this, GetDocument()))
	{
		return 0L;
	}
	pSimuWnd->ShowWindow(SW_SHOW);
	pSimuWnd->PostMessage(WM_SETFOCUS, NULL, 0L);
	m_pSimuWnd = pSimuWnd;
	//pParamWnd->MoveWindow(0, 0, 320, 240, TRUE);

	return 0L;
}

void CExtncsView::OnUpdateExtncsCondition(CCmdUI* pCmdUI) 
{
	CExtncsDoc *pDoc = GetDocument();
	if(!pDoc->m_bCodeGen || !pDoc->m_bCodeCompile)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}

// _uNbN
// 1.p[^[ݒ
// 2.ݒp[^[݂ȏꍇ́AȂɂȂ
// 3.SopeW[̏ꍇ́AScopeJ

void CExtncsView::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	int nCount,i;
	BOOL bHit;
	CWidget* pWidget;
	CExtncsDoc *pDoc = GetDocument();
	CString model;

	//XN[ɑΉ
	CClientDC dc (this);
	OnPrepareDC (&dc);
	dc.DPtoLP (&point);

	// Widgetŉ
	nCount = pDoc->GetWidgetCount ();
	bHit = FALSE;
	for (i=nCount - 1; i>=0 && !bHit; i--) {
		pWidget = pDoc->GetWidget (i);
		if (pWidget->PtInWidget (point)) {
			bHit = TRUE;
			break;
		}
	}

	if(bHit) {
		model = pWidget->GetModel();
		if(model.Compare(_T("subsystem.mdl")) == NULL) {
			OpenSubsystem( pWidget, point );
		}
		else {
			OpenParam( pWidget, point );
		}

		//OnLButtonDwonɃCxgAm_nSelLɂȂĂ̂
		//ZNgĂWidgetȂ
		pWidget->SetSel (FALSE);
		m_nSel = -1;
		pDoc->UpdateAllViews (NULL);
	}
	
	CScrollView::OnLButtonDblClk(nFlags, point);
}

// SubsystemEBhEJ
void CExtncsView::OpenSubsystem(CWidget* pWidget, CPoint point)
{
	CSubsysDoc*	pSubsysDoc;
	CSubsysWnd*	pSubsysWnd;
	CExtncsDoc *pDoc = GetDocument();
	CString title;
	BLOCKINFO* pItem;

	// 2dI[vmF
	if(pWidget->GetWindow())
		return;
	// IĂWidget擾
	pItem = pWidget->GetPitem();

	pSubsysDoc = (CSubsysDoc *)g_pSubsysTemplate->CreateNewDocument();
	if(pSubsysDoc) {
		//lȂ
		pSubsysDoc->m_pWidget = pWidget;
		pSubsysDoc->m_pExtncsDoc = pDoc;
		pSubsysDoc->m_pExtncsView = this;
		pWidget->SetDocument(pSubsysDoc);
		//EBhEǗ
		//pSubsysDoc->m_nThisIndex = m_nSubsysMax; 
		//pDoc->m_bSubsysWnd[m_nSubsysMax] = TRUE;
	}
	else {	// error
		AfxMessageBox("OpenSubsystem error 1.", MB_OK, NULL);
		return;
	}
	pSubsysWnd = (CSubsysWnd *)g_pSubsysTemplate->CreateNewFrame(pSubsysDoc, NULL);
	if(pSubsysWnd) {
		g_pSubsysTemplate->InitialUpdateFrame(pSubsysWnd, pSubsysDoc, TRUE);
		//if(!m_pSubsysWnd[m_nSubsysMax]) {
			pWidget->SetWindow(pSubsysWnd);
		//}
	}
	else {	// error
		AfxMessageBox("OpenSubsystem error 2.", MB_OK, NULL);
		return;
	}
	//̃TuVXẽCfbNX
	//m_nSubsysMax += 1;
}

void CExtncsView::OpenParam(CWidget* pWidget, CPoint point)
{
	int nCount;
	PARAMWNDINFO *pItem;
	CExtncsDoc *pDoc = GetDocument();
	CPtrArray*	p;

	p = pWidget->GetParamPointer();
	nCount = (int)p->GetSize();
	if(nCount == 0)
		return;		//݂Ȃ

	//
	//ClientToScreen(&point);
	CParamWnd *pParamWnd = new CParamWnd;
	if(!pParamWnd->Create( "Setting parameters", WS_OVERLAPPEDWINDOW,
		CRect(point.x, point.y, 480, 320), (CWnd*)this, pWidget))
	{
		return;
	}
	pParamWnd->ShowWindow(SW_SHOW);
	pParamWnd->PostMessage(WM_SETFOCUS, NULL, 0L);
	//ClientToScreen(&point);
	//pParamWnd->MoveWindow(point.x, point.y, 320, 240, TRUE);

	//p[^[EBhEǗ̂ߓo^
	try {
		pItem = new PARAMWNDINFO;
	}
	catch (CMemoryException* e) {
		e->Delete ();
		return;
	}
	//@ݒ
	pItem->pWnd = pParamWnd;
	pItem->pWidget = pWidget;
	//CfbNX
	nCount = (int)m_paramArray.GetSize();
	//o^
	m_paramArray.InsertAt( nCount, pItem );
	nCount++;
}

void CExtncsView::OnWidgetParam() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CExtncsDoc* pDoc = GetDocument();
	CWidget* pWidget = pDoc->GetWidget (m_desIndex);
	OpenParam(pWidget, m_popupPos);	
}

void CExtncsView::OnUpdateWidgetParam(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

// ScopeWnd쐬
// m_desIndexɎw肳ꂽWidgetCfbNXݒ肳Ă
void CExtncsView::OnWidgetScope() 
{
	CExtncsDoc *pDoc = GetDocument();
	CWidget* pWidget;
	CScopeFrame *pScopeFrame;
	CXyWnd*	pXyWnd;
	char pathbuf[_MAX_PATH];

	// IĂWidget擾
	pWidget = pDoc->GetWidget (m_desIndex);
	if(pWidget->GetScope())
		return;		//dI[v֎~

	//TODO:x̓R[hŗL̏
	//Kw擾
	strcpy(pathbuf, "");
	GetWidgetPath(pWidget, pathbuf);

	if(pWidget->GetId() == M_XY) {
		pXyWnd = new CXyWnd;
		if(!pXyWnd->Create( pathbuf, WS_OVERLAPPEDWINDOW,
			CRect(0, 0, 320, 320), this, pWidget))
		{
			return;
		}
		pXyWnd->ShowWindow(SW_SHOW);
		pXyWnd->UpdateWindow();

		//CXyWnd̓o^
		pWidget->SetScope((CWnd*)pXyWnd);
	}
	else {
		pScopeFrame = new CScopeFrame;
		if(!pScopeFrame->Create( pathbuf, WS_OVERLAPPEDWINDOW,
			CRect(0, 0, 480, 320), this, pWidget, m_nScopeMax))
		{
			return;
		}
		pScopeFrame->ShowWindow(SW_SHOW);
		pScopeFrame->UpdateWindow();

		//CScopeFrame̓o^
		pWidget->SetScope((CWnd*)pScopeFrame);
	}
}

void CExtncsView::OnUpdateWidgetScope(CCmdUI* pCmdUI) 
{
	// IĂWidget擾
	CWidget* pWidget;
	pWidget = GetDocument()->GetWidget (m_desIndex);
	if(pWidget->GetId() == M_SUBSYSTEM)
		pCmdUI->Enable(FALSE);
	else
		pCmdUI->Enable(TRUE);
}


void CExtncsView::OnWidget0() 
{
	CExtncsDoc *pDoc = GetDocument();
	CWidget* pWidget;
	pWidget = pDoc->GetWidget (m_desIndex);
	pWidget->SetDirection(DIR_RIGHT);
	pDoc->UpdateAllViews (NULL);	
}

void CExtncsView::OnUpdateWidget0(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CExtncsView::OnWidget90() 
{
	CExtncsDoc *pDoc = GetDocument();
	CWidget* pWidget;
	pWidget = pDoc->GetWidget (m_desIndex);
	pWidget->SetDirection(DIR_UP);
	pDoc->UpdateAllViews (NULL);	
}

void CExtncsView::OnUpdateWidget90(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CExtncsView::OnWidget180() 
{
	CExtncsDoc *pDoc = GetDocument();
	CWidget* pWidget;
	pWidget = pDoc->GetWidget (m_desIndex);
	pWidget->SetDirection(DIR_LEFT);
	pDoc->UpdateAllViews (NULL);	
}

void CExtncsView::OnUpdateWidget180(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CExtncsView::OnWidget270() 
{
	CExtncsDoc *pDoc = GetDocument();
	CWidget* pWidget;
	pWidget = pDoc->GetWidget (m_desIndex);
	pWidget->SetDirection(DIR_DOWN);
	pDoc->UpdateAllViews (NULL);	
}

void CExtncsView::OnUpdateWidget270(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

// Set hardware information
BOOL CExtncsView::SimuInit()
{
	CExtncsDoc* pDoc = GetDocument();
	int	nCount,i,id,j,nSize;
	CWidget* pWidget;
	CPtrArray* p;
	PARAMINFO* pItem;
	CString m_name, s_name;
	char modelpath[_MAX_PATH],modelname[_MAX_PATH],openfile[_MAX_PATH];
	char *cptr;
	FILE* fp;

	strcpy(modelpath, pDoc->m_ExtncsName);
	cptr = strstr(modelpath, ".sig");
	*cptr = '\0';
	strcat(modelpath, ".mdl");
	_splitpath(modelpath, NULL, NULL, modelname, NULL);
	strcpy(modelpath, get_tmpdir());
	sprintf(openfile, "%s/%s.hrd", modelpath, modelname);
	if((fp = fopen(openfile, "w")) != NULL) {
		nCount = pDoc->GetWidgetCount();
		for(i = 0; i < nCount; i++) {
			//pWidget = (CWidget*) pDoc->m_arrWidgets[i];
			pWidget = (CWidget *)pDoc->GetWidget(i);
			id = pWidget->GetId();
			if(id == M_AD3120 || id == M_DA3338 ||
				id == M_AD3163 || id == M_DA3305) {
				m_name = pWidget->GetName();
			fprintf(fp, "[%s, %d]\n", m_name, id);
				p = pWidget->GetParamPointer();
				nSize = (int)p->GetSize();	//j^[\ϐ̐
			fprintf(fp, "%d\n", nSize);
				for(j = 0; j < nSize; j++) {
					pItem = (PARAMINFO*) p->GetAt(j);
				fprintf(fp,"%s %s\n", pItem->strName, pItem->strValue);
				}
			}
		}
		fclose(fp);
	}
	else
		return FALSE;
	return TRUE;
}

//V~[Vs
BOOL CExtncsView::SimuExe()
{
	CExtncsDoc	*pDoc = GetDocument();
	char		modelpath[_MAX_PATH];
	char		scriptpath[_MAX_PATH];
	char		modelname[_MAX_PATH];
	char		*cptr;
	char		slfile[_MAX_PATH];
	FILE		*fp;
	int			i,ch,len;
	DWORD		size;
	const char* tmpdir;
	char	tmppath[_MAX_PATH];

	//e|쐬
	tmpdir = get_tmpdir();
	if(GetShortPathName(tmpdir, tmppath, _MAX_PATH) == NULL)
		strcpy(tmppath, tmpdir);
	//Jgmdlt@C݂Ă邩
#if 0
	strcpy(modelpath, pDoc->m_ExtncsName);
	cptr = strstr(modelpath, ".sig");
	if(!cptr) {
		AfxMessageBox("Extncs not exist.",MB_OK, NULL);
		return FALSE;
	}
	*cptr = '\0';
	strcat(modelpath, ".mdl");
	_splitpath(modelpath, NULL, NULL, modelname, NULL);
	if(_access(modelpath, 0) == -1) {
		AfxMessageBox("Model not exist.",MB_OK, NULL);
		return FALSE;
	}
#else
	strcpy(modelpath, tmppath);
	strcat(modelpath, "\\");
	strcpy(modelname, pDoc->m_ModelName/*m_ExtncsName*/);
	cptr = strstr(modelname, ".sig");
	*cptr = '\0';
	strcat(modelpath, modelname);
	strcat(modelpath, ".mdl");
	if(_access(modelpath, 0) == -1) {
		AfxMessageBox("Model not exist.",MB_OK, NULL);
		return FALSE;
	}
#endif
	//RpCXNvg𔭐M
	//Script쐬
#if 0
	strcpy(scriptpath, modelpath);
	cptr = strstr(scriptpath, ".mdl");
	*cptr = '\0';
	strcat(scriptpath, ".sl");
	fp = fopen(scriptpath, "w");
	//SLt@C
	CreateScript( fp );
	fclose(fp);
#else
	sprintf(scriptpath, "%s/%s.sl",tmppath,modelname);
	fp = fopen(scriptpath, "w");
	if(!fp) {
		AfxMessageBox("Script error.",MB_OK, NULL);
		return FALSE;
	}
	CreateScript( fp );
	fclose(fp);
#endif

	//OutViewɃXNvg\
	ScriptPrint(scriptpath);

	//̎_Scope͊JĂ̂ŁAV~[VԂȂǑM
	ScopeSet();

	//A^CfʐMXbh
	DWORD threadID;
	HANDLE hThread;
	int rtval;

	//A^CfʐMXbh
	//simu_busy = TRUE;
	hThread = CreateThread( 0, 0,
		(LPTHREAD_START_ROUTINE)SyncThread, this, 0, &threadID);
	rtval = GetThreadPriority( hThread );
	if(rtval == THREAD_PRIORITY_ERROR_RETURN) {
		AfxMessageBox("GetThreadPriority error.",MB_OK,NULL);
	}
	if(!SetThreadPriority(hThread, THREAD_PRIORITY_ABOVE_NORMAL)) {
		AfxMessageBox("SetThreadPriority error.",MB_OK,NULL);
	}

	//A^Cfs
	//inline߂ɂĔM
#if 0
	strcpy(slfile, "inline(\"");
	strcat(slfile, modelname);
	strcat(slfile, ".sl");
	strcat(slfile, "\")\n");
#else
	sprintf(slfile, "inline(\"%s.sl\")\n",modelname);
#endif

	//V~[VJnݒ
	m_fSimuState = TRUE;
	//A command is transmitted. 
	_chdir(tmpdir);
	len = (int)strlen(slfile);
	for(i=0; i<len; i++){
		ch = (unsigned char)slfile[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
	return TRUE;
}

//sScriptvg
void CExtncsView::ScriptPrint(CString path)
{
	//R[h\eNA
	//g_pExtncsMain->m_pOutView->AllClear();
	//g_pExtncsMain->m_pOutView->Print("---- Executable script ----");
	printf("---- Executable script ----\n");

	FILE *fp;
	char buf[256];
	fp = fopen(path, "r");
	while(!feof(fp)) {
		if(fgets(buf, 256, fp) == NULL)
			break;
		buf[strlen(buf)-1] = '\0';
		//OutViewłȂConsole
		//g_pExtncsMain->m_pOutView->Print(buf);
		printf("%s\n", buf);
	}
	fclose(fp);
}
///////////////////////////////////////////////////////////
//	ScopeI[vĂ邩
///////////////////////////////////////////////////////////
BOOL CExtncsView::CheckScopeOpen(CWidget* pWidget)
{
	CWnd* pWnd;
	
	pWnd = pWidget->GetScope();
	if(pWnd)
		return TRUE;
	else
		return FALSE;
}

///////////////////////////////////////////////////////////
//	sScript쐬
//	model.sig@| model.sl𐶐
///////////////////////////////////////////////////////////

//V~[VEXNvg̍쐬
//Subsystemp[^[̕ύXɊւ
void CExtncsView::CreateScriptSubParam(FILE *fp, CWidget* pTargetWidget)
{
	CPtrArray* pArrWidgets;
	int i,id,nWidget,j,nSize;
	CString name;
	CWidget* pWidget;
	CPtrArray* p;
	PARAMINFO* pItem;
	char cmdline[_MAX_PATH],subname[32];
	double val;

	//Subsystem
	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	nWidget = (int)pArrWidgets->GetSize(); 
	for(i = 0; i < nWidget; i++) {
		pWidget = (CWidget *)pArrWidgets->GetAt(i);
		id = pWidget->GetId();
		if(id == M_MATH || id == M_TRANSFER)
			continue;
		if(id == M_SUBSYSTEM) {
			//Subsystem
			CreateScriptSubParam(fp, pWidget);
		}
		else {
			//SubsystemȊO
			sprintf(subname, "S%d_", pWidget->GetLevel());
			name = _T(subname);
			name += pWidget->GetName();
			p = pWidget->GetParamPointer();
			nSize = (int)p->GetSize();	//p[^ϐ̐
			for(j = 0; j < nSize; j++) {
				pItem = (PARAMINFO*) p->GetAt(j);
				if(pItem->changed) {
					//p[^[ݒR}h
					val = atof(pItem->strValue);
					if(id == M_DELAY) {
						sprintf(cmdline,"ndelay(\"%s\",\"in\",%f)",
							name,val);
					}
					else {
						sprintf(cmdline,"npara(\"%s\",\"%s\",%f)",
							name,pItem->strName,val);
					}
					fprintf(fp,"%s\n",cmdline);
					//ύXtO
					pItem->changed = FALSE;
				}
			}	
		}
	}
}

//SubsystemScopeɊւ
int CExtncsView::CreateScriptSubScope(FILE *fp, CWidget* pTargetWidget, int nTargetIndex)
{
	CExtncsDoc* pDoc = GetDocument();
	CPtrArray* pArrWidgets;
	int i,id,nWidget,j,nSize,row,column,style,index,k,total;
	CWidget* pWidget;
	CPtrArray* p;
	SCOPEINFO* sItem;
	CString m_name, s_name;
	char cmdline[_MAX_PATH],subname[32];

	//Subsystem
	index = nTargetIndex;
	pArrWidgets = pTargetWidget->GetWidgetsPointer();
	nWidget = (int)pArrWidgets->GetSize(); 
	for(i = 0; i < nWidget; i++) {
		pWidget = (CWidget *)pArrWidgets->GetAt(i);
		id = pWidget->GetId();
		if(id == M_GAP || id == M_SYNAPSE || id == M_TITLE) {
			continue;		//ݑΉłĂȂ
		}
		if(id == M_SUBSYSTEM) {
			//Subsystem
			index = CreateScriptSubScope(fp, pWidget, index);
		}
		else {
			if(!CheckScopeOpen(pWidget))
				continue;
			//SubsystemȊO
			sprintf(subname, "S%d_", pWidget->GetLevel());
			m_name = _T(subname);
			m_name += pWidget->GetName();
			p = pWidget->GetScopePointer();			//j^[\ϐ|C^[
			nSize = (int)p->GetSize();				//j^[\ϐ̐
			//CellStyleɉĕύXKv
			row = pWidget->GetCellRow();
			column = pWidget->GetCellColumn();
			style = pDoc->GetCellStyle(row, column);
			if(style == SINGLE_CELL) {	//	Pcell
				for(j = 0; j < nSize; j++) {
					sItem = (SCOPEINFO*) p->GetAt(j);
					if(sItem->visible) {	//visible
						if(sItem->type == SCOPE_OUTPUT) {
							//Outputo^
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s",s_name);
							fprintf(fp,"%s\n",cmdline);
							sprintf(cmdline, "nout(%s,\"%s\",0,1)",
								s_name, m_name);
							fprintf(fp,"%s\n",cmdline);
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index++;
						} else if(sItem->type == SCOPE_EXINPUT) {
							//TODO 2004/3
							//Exinputo^
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s",s_name);
							fprintf(fp,"%s\n",cmdline);
							sprintf(cmdline, "nout(%s,\"%s\",0,2)",
								s_name, m_name);
							fprintf(fp,"%s\n",cmdline);
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index++;
						} else if(sItem->type == SCOPE_OBS) {
							//Obso^
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s",s_name);
							fprintf(fp,"%s\n",cmdline);
							sprintf(cmdline, "nout(%s,\"%s\",0,3,\"%s\")",
								s_name, m_name, sItem->strName);
							fprintf(fp,"%s\n",cmdline);
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index++;
						}
					}
				}
			}
			else {		//gZ
				//ϐ́A
				for(k = 0; k < nSize; k++) {
					sItem = (SCOPEINFO*) p->GetAt(k);
					if(sItem->visible) {	//visible
						//eStyleňقȂAo͂̂ݕ\
						total = row*column;		//sItem->sizeɓ
						if(sItem->type == SCOPE_OUTPUT) {
							//Outputo^
							total = row*column;		//sItem->sizeɓ
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s[%d]",s_name,total);
							fprintf(fp,"%s\n",cmdline);
							for(j = 0; j < total; j++) {
								sprintf(cmdline, "nout(%s,%d,\"%s\",%d,1)",
									s_name, j, m_name, j);
								fprintf(fp,"%s\n",cmdline);
							}
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index += total;
							//switch(style) {
							//case	COLUMN_CELL:
							//	s_name = m_name + _T("_") + sItem->strName;
							//	sprintf(cmdline, "series %s[%d]",s_name,total);
							//	fprintf(fp,"%s\n",cmdline);
							//	for(j = 0; j < total; j++) {
							//		sprintf(cmdline, "nout(%s,%d,\"%s\",%d,1)",
							//			s_name, j, m_name, j);
							//		fprintf(fp,"%s\n",cmdline);
							//	}
							//	//ǂSCOPE
							//	sItem->visible = TRUE;
							//	sItem->index = index;	//f[^̃CfbNXԍ
							//	index += total;
							//	break;
							//case	ROW_CELL:
							//	s_name = m_name + _T("_") + sItem->strName;
							//	sprintf(cmdline, "series %s[%d]",s_name,total);
							//	fprintf(fp,"%s\n",cmdline);
							//	for(j = 0; j < total; j++) {
							//		sprintf(cmdline, "nout(%s,%d,\"%s\",%d,1)",
							//			s_name, j, m_name, j);
							//		fprintf(fp,"%s\n",cmdline);
							//	}
							//	//ǂSCOPE
							//	sItem->visible = TRUE;
							//	sItem->index = index;	//f[^̃CfbNXԍ
							//	index += total;
							//	break;
							//case	MATRIX_CELL:
							//	s_name = m_name + _T("_") + sItem->strName;
							//	sprintf(cmdline, "series %s[%d]",s_name,total);
							//	fprintf(fp,"%s\n",cmdline);
							//	for(j = 0; j < total; j++) {
							//		sprintf(cmdline, "nout(%s,%d,\"%s\",%d,1)",
							//			s_name, j, m_name, j);
							//		fprintf(fp,"%s\n",cmdline);
							//	}
							//	//ǂSCOPE
							//	sItem->visible = TRUE;
							//	sItem->index = index;	//f[^̃CfbNXԍ
							//	index += total;
							//	break;
							//}
						}
						else if(sItem->type == SCOPE_OBS) {
							//Obso^
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s[%d]",s_name,total);
							fprintf(fp,"%s\n",cmdline);
							for(j = 0; j < total; j++) {
								sprintf(cmdline, "nout(%s,%d,\"%s\",%d,3,\"%s\")",
									s_name, j, m_name, j, sItem->strName);
								fprintf(fp,"%s\n",cmdline);
							}
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index += total;
						}
					}
				}
			}
		}
	}
	return index;
}

//V~[VEXNvg쐬
void CExtncsView::CreateScript(FILE *fp)
{
	CExtncsDoc* pDoc = GetDocument();
	int	nCount,i,j,k,nSize,index,row,column,style,total,id;
	CWidget* pWidget;
	CPtrArray* p;
	SCOPEINFO* sItem;
	PARAMINFO* pItem;
	CString m_name, s_name;
	char cmdline[_MAX_PATH];
	double val;

	///////////////////////////////////////////////
	//	ύXĂp[^[ݒ肷
	//  p[^ύXmdlɔfubN
	//  ́AnparaȂǐݒ肵Ă͂Ȃ
	///////////////////////////////////////////////
	nCount = pDoc->GetWidgetCount();
	for(i = 0; i < nCount; i++) {
		//pWidget = (CWidget*) pDoc->m_arrWidgets[i];
		pWidget = (CWidget *)pDoc->GetWidget(i);
		id = pWidget->GetId();
		if(id == M_MATH || id == M_TRANSFER)
			continue;
		if(id == M_SUBSYSTEM) {
			//Subsystem
			CreateScriptSubParam(fp, pWidget);
		}
		else {
			//SubsystemȊO
			m_name = pWidget->GetName();
			p = pWidget->GetParamPointer();
			nSize = (int)p->GetSize();	//p[^ϐ̐
			for(j = 0; j < nSize; j++) {
				pItem = (PARAMINFO*) p->GetAt(j);
				if(pItem->changed) {
					//p[^[ݒR}h
					val = atof(pItem->strValue);
					if(id == M_DELAY) {
						sprintf(cmdline,"ndelay(\"%s\",\"in\",%f)",
							m_name,val);
					}
					else {
						sprintf(cmdline,"npara(\"%s\",\"%s\",%f)",
							m_name,pItem->strName,val);
					}
					fprintf(fp,"%s\n",cmdline);
					//ύXtO
					pItem->changed = FALSE;
				}
			}
		}
	}

	/////////////////////////////////////////////////////
	//	j^[ϐݒ肷
	/////////////////////////////////////////////////////
	//n߂ɁASẴj^[NA
//TODO:̃R}h܂삵Ȃ
	//strcpy(cmdline, "nerase(\"O\",\"ALL\")");
	//fprintf(fp,"%s\n",cmdline);

	index = 0;
	nCount = pDoc->GetWidgetCount();
	for(i = 0; i < nCount; i++) {
		//pWidget = (CWidget*) pDoc->m_arrWidgets[i];
		pWidget = (CWidget *)pDoc->GetWidget(i);
		id = pWidget->GetId();
		if(id == M_GAP || id == M_SYNAPSE || id == M_TITLE) {
			continue;		//ݑΉłĂȂ
		}
		if(id == M_SUBSYSTEM) {
			//Subsystem
			index = CreateScriptSubScope(fp, pWidget, index);
		}
		else {
			if(!CheckScopeOpen(pWidget))
				continue;
			m_name = pWidget->GetName();
			p = pWidget->GetScopePointer();			//j^[\ϐ|C^[
			nSize = (int)p->GetSize();				//j^[\ϐ̐
			//CellStyleɉĕύXKv
			row = pWidget->GetCellRow();
			column = pWidget->GetCellColumn();
			style = pDoc->GetCellStyle(row, column);
			if(style == SINGLE_CELL) {	//	Pcell
				for(j = 0; j < nSize; j++) {
					sItem = (SCOPEINFO*) p->GetAt(j);
					if(sItem->visible) {	//visible
						if(sItem->type == SCOPE_OUTPUT) {
							//Outputo^
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s",s_name);
							fprintf(fp,"%s\n",cmdline);
							sprintf(cmdline, "nout(%s,\"%s\",0,1)",
								s_name, m_name);
							fprintf(fp,"%s\n",cmdline);
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index++;
						} else if(sItem->type == SCOPE_EXINPUT) {
							//TODO 2004/3
							//Exinputo^
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s",s_name);
							fprintf(fp,"%s\n",cmdline);
							sprintf(cmdline, "nout(%s,\"%s\",0,2)",
								s_name, m_name);
							fprintf(fp,"%s\n",cmdline);
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index++;
						} else if(sItem->type == SCOPE_OBS) {
							//Obso^
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s",s_name);
							fprintf(fp,"%s\n",cmdline);
							sprintf(cmdline, "nout(%s,\"%s\",0,3,\"%s\")",
								s_name, m_name, sItem->strName);
							fprintf(fp,"%s\n",cmdline);
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index++;
						}
					}
				}
			}
			else {		//gZ
				//ϐ́A
				for(k = 0; k < nSize; k++) {
					sItem = (SCOPEINFO*) p->GetAt(k);
					if(sItem->visible) {	//visible
						//eStyleňقȂAo͂̂ݕ\
						total = row*column;		//sItem->sizeɓ
						if(sItem->type == SCOPE_OUTPUT) {
							//Outputo^
							total = row*column;		//sItem->sizeɓ
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s[%d]",s_name,total);
							fprintf(fp,"%s\n",cmdline);
							for(j = 0; j < total; j++) {
								sprintf(cmdline, "nout(%s,%d,\"%s\",%d,1)",
									s_name, j, m_name, j);
								fprintf(fp,"%s\n",cmdline);
							}
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index += total;
							//switch(style) {
							//case	COLUMN_CELL:
							//	s_name = m_name + _T("_") + sItem->strName;
							//	sprintf(cmdline, "series %s[%d]",s_name,total);
							//	fprintf(fp,"%s\n",cmdline);
							//	for(j = 0; j < total; j++) {
							//		sprintf(cmdline, "nout(%s,%d,\"%s\",%d,1)",
							//			s_name, j, m_name, j);
							//		fprintf(fp,"%s\n",cmdline);
							//	}
							//	//ǂSCOPE
							//	sItem->visible = TRUE;
							//	sItem->index = index;	//f[^̃CfbNXԍ
							//	index += total;
							//	break;
							//case	ROW_CELL:
							//	s_name = m_name + _T("_") + sItem->strName;
							//	sprintf(cmdline, "series %s[%d]",s_name,total);
							//	fprintf(fp,"%s\n",cmdline);
							//	for(j = 0; j < total; j++) {
							//		sprintf(cmdline, "nout(%s,%d,\"%s\",%d,1)",
							//			s_name, j, m_name, j);
							//		fprintf(fp,"%s\n",cmdline);
							//	}
							//	//ǂSCOPE
							//	sItem->visible = TRUE;
							//	sItem->index = index;	//f[^̃CfbNXԍ
							//	index += total;
							//	break;
							//case	MATRIX_CELL:
							//	s_name = m_name + _T("_") + sItem->strName;
							//	sprintf(cmdline, "series %s[%d]",s_name,total);
							//	fprintf(fp,"%s\n",cmdline);
							//	for(j = 0; j < total; j++) {
							//		sprintf(cmdline, "nout(%s,%d,\"%s\",%d,1)",
							//			s_name, j, m_name, j);
							//		fprintf(fp,"%s\n",cmdline);
							//	}
							//	//ǂSCOPE
							//	sItem->visible = TRUE;
							//	sItem->index = index;	//f[^̃CfbNXԍ
							//	index += total;
							//	break;
							//}
						}
						else if(sItem->type == SCOPE_OBS) {
							//Obso^
							s_name = m_name + _T("_") + sItem->strName;
							sprintf(cmdline, "series %s[%d]",s_name,total);
							fprintf(fp,"%s\n",cmdline);
							for(j = 0; j < total; j++) {
								sprintf(cmdline, "nout(%s,%d,\"%s\",%d,3,\"%s\")",
									s_name, j, m_name, j, sItem->strName);
								fprintf(fp,"%s\n",cmdline);
							}
							//ǂSCOPE
							sItem->visible = TRUE;
							sItem->index = index;	//f[^̃CfbNXԍ
							index += total;
						}
					}
				}
			}
		}	// if(id == M_SUBSYSTEM)
	}
	m_nMoniMax = index;		//j^[Ă鐔
	////////////////////////////////////////////////////
	//	V~[V
	//  m_strStepm_strSave͓l
	//  SԖڃp[^
	/////////////////////////////////////////////////////
	sprintf(cmdline, "ntime(%.3f,%.5f,%.5f,%.5f)",
		atof(pDoc->m_strTime),
		atof(pDoc->m_strStep),
		atof(pDoc->m_strSave),
		atof(pDoc->m_strSave));
	fprintf(fp,"%s\n",cmdline);
	/////////////////////////////////////////////////////
	//	ϕ
	/////////////////////////////////////////////////////
	switch(pDoc->m_nInteg) {
	case	0:	//Euler
		strcpy(cmdline, "ninteg(\"E\")");
		break;
	case	1:	//Ruge
		strcpy(cmdline, "ninteg(\"R\")");
		break;
	case	2:	//Adaptive
		strcpy(cmdline, "ninteg(\"F\")");
		break;
	}
	fprintf(fp,"%s\n",cmdline);
	//////////////////////////////////////////////////////////////////
	//	A^C
	//	sꍇ́A"2"ŃV~[VA"3"ŃA^C
	//////////////////////////////////////////////////////////////////
	if(pDoc->m_bRtmode)
		strcpy(cmdline, "nrtclk(\"3\",\"ON\")");
	else
		strcpy(cmdline, "nrtclk(\"2\",\"ON\")");
	fprintf(fp,"%s\n",cmdline);
	///////////////////////////////////////////
	//	V~[Vs
	///////////////////////////////////////////
	strcpy(cmdline, "ncal()");
	fprintf(fp,"%s\n",cmdline);

	//j^[ϐ폜
	if(index > 0) {
		strcpy(cmdline, "nerase(\"O\",\"ALL\")");
		fprintf(fp,"%s\n",cmdline);
	}
}

// fobOp
void CExtncsView::Print(char *str)
{
	CExtncsDoc* pDoc = GetDocument();
	//pDoc->Print(_T(str));
}

// ScopeɃV~[V𑗂Ä揉
void CExtncsView::ScopeSet()
{
	CExtncsDoc *pDoc = GetDocument();
	int i,nWidget,cycle,width,index,nSize,id;
	CWidget* pWidget;
	double simtime,simstep;
	//CScopeFrame* pScopeFrame;
	CPtrArray* p;
	SCOPEINFO* pItem;
	CWnd* pWnd;

	//V~[V_
	simtime = atof(pDoc->m_strTime);
	simstep = atof(pDoc->m_strStep);
	cycle = (int)(simtime / simstep);
	//ȏɏScopeɐݒ
	nWidget = pDoc->GetWidgetCount();
	for(i = 0; i < nWidget; i++) {
		pWidget = pDoc->GetWidget(i);
		id = pWidget->GetId();
		if(id == M_SUBSYSTEM)
			SubScopeSet(pWidget);
		else {
			//SCOPEINFO̎ԗ̈ݒ
			pWnd = pWidget->GetScope();
			if(pWnd) {
				if(id == M_XY) {
					// Xy̏ꍇ́AJĂꍇ́Aϐix,y,zjIɃj^[
					p = pWidget->GetScopePointer();
					nSize = (int)p->GetSize();	//j^[\ϐ̐
					width = 0;
					for(index = 0; index < nSize; index++) {
						pItem = (SCOPEINFO*) p->GetAt(index);
						if(pItem->visible) {
							pItem->strTs = _T("0.0");
							pItem->strTe = pDoc->m_strTime;
							//TODO:ĊmF
							pItem->strTime = pDoc->m_strTime;
							width += pItem->size;	//ϐ̕
						}
					}
					//XyDoc̃f[^̈
					pWidget->XySet( simtime, simstep, cycle );
				}
				else {
					p = pWidget->GetScopePointer();
					nSize = (int)p->GetSize();	//j^[\ϐ̐
					width = 0;
					for(index = 0; index < nSize; index++) {
						pItem = (SCOPEINFO*) p->GetAt(index);
						if(pItem->visible) {
							pItem->strTs = _T("0.0");
							pItem->strTe = pDoc->m_strTime;
//TODO:ĊmF
//pItem->strTime = pDoc->m_strTime;
							width += pItem->size;	//ϐ̕
						}
					}
					//ScopeDoc̃f[^̈
					pWidget->ScopeSet( simtime, simstep, cycle );
				}
			}
		}
	}
}

// ScopeɃV~[V𑗂Ä揉
void CExtncsView::SubScopeSet(CWidget* pTargetWidget)
{
	CExtncsDoc *pDoc = GetDocument();
	int i,nWidget,cycle,width,index,nSize,id;
	CWidget* pWidget;
	double simtime,simstep;
	CPtrArray* p;
	SCOPEINFO* pItem;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();
	CWnd* pWnd;

	//V~[V_
	simtime = atof(pDoc->m_strTime);
	simstep = atof(pDoc->m_strStep);
	cycle = (int)(simtime / simstep);
	//ȏɏScopeɐݒ
	nWidget = (int)pArrWidgets->GetSize();
	for(i = 0; i < nWidget; i++) {
		pWidget = (CWidget*)pArrWidgets->GetAt(i);
		id = pWidget->GetId();
		if(id == M_SUBSYSTEM)
			SubScopeSet(pWidget);
		else {
			//SCOPEINFO̎ԗ̈ݒ
			pWnd = pWidget->GetScope();
			if(pWnd) {
				if(id == M_XY) {
					// Xy̏ꍇ́AJĂꍇ́Aϐix,y,zjIɃj^[
					p = pWidget->GetScopePointer();
					nSize = (int)p->GetSize();	//j^[\ϐ̐
					width = 0;
					for(index = 0; index < nSize; index++) {
						pItem = (SCOPEINFO*) p->GetAt(index);
						if(pItem->visible) {
							pItem->strTs = _T("0.0");
							pItem->strTe = pDoc->m_strTime;
							//TODO:ĊmF
							pItem->strTime = pDoc->m_strTime;
							width += pItem->size;	//ϐ̕
						}
					}
					//XyDoc̃f[^̈
					pWidget->XySet( simtime, simstep, cycle );
				}
				else {
					p = pWidget->GetScopePointer();
					nSize = (int)p->GetSize();	//j^[\ϐ̐
					width = 0;
					for(index = 0; index < nSize; index++) {
						pItem = (SCOPEINFO*) p->GetAt(index);
						if(pItem->visible) {
							pItem->strTs = _T("0.0");
							pItem->strTe = pDoc->m_strTime;
//TODO:ĊmF
//pItem->strTime = pDoc->m_strTime;
							width += pItem->size;	//ϐ̕
						}
					}
					//ScopeDoc̃f[^̈
					pWidget->ScopeSet( simtime, simstep, cycle );
				}
			}
		}
	}
}

// XVf[^܂Ƃ߂ē]Ă̂ŁA
// eScopeɃf[^U
void CExtncsView::ScopeUpdate(int cycle, float data[])
{
	CExtncsDoc *pDoc = GetDocument();
	int i,nWidget,addr,index,size,nSize,id;
	CWidget* pWidget;
	CScopeFrame* pScopeFrame;
	CPtrArray* p;
	SCOPEINFO* pItem;
	CWnd* pWnd;
	float* fdata;		// Xypf[^

	//ȏɏScopeɐݒ
	nWidget = pDoc->GetWidgetCount();
	for(i = 0; i < nWidget; i++) {
		pWidget = pDoc->GetWidget(i);
		id = pWidget->GetId();
		if(id == M_SUBSYSTEM)
			SubScopeUpdate(pWidget, cycle, data);
		else {
			pWnd = pWidget->GetScope();
			if(pWnd) {
				if(id == M_XY) {
					//Xy̏ꍇ́Azɂē]
					p = pWidget->GetScopePointer();
					nSize = (int)p->GetSize();	//j^[\ϐ̐
					fdata = (float*)malloc(nSize*sizeof(float));
					index = 0;
					for(size = 0; size < nSize; size++) {
						pItem = (SCOPEINFO*) p->GetAt(size);
						if(pItem->visible) {
							// cycle:Эڰ݉
							// size:pWidgetłm_scopeArrayԍ
							// addr:ޔԒn
							// pItem->size:
							// data[pItem->index]
							fdata[index++] = data[pItem->index];
						}
					}
					pWidget->XyUpdate(cycle, 0/*1XR[v̂*/, index, fdata);
					free(fdata);
				}
				else {
					pScopeFrame = (CScopeFrame*)pWnd;
					p = pWidget->GetScopePointer();
					nSize = (int)p->GetSize();	//j^[\ϐ̐
					index = 0;
					addr = 0;
					for(size = 0; size < nSize; size++) {
						pItem = (SCOPEINFO*) p->GetAt(size);
						if(pItem->visible) {
							// cycle:Эڰ݉
							// size:pWidgetłm_scopeArrayԍ
							// addr:ޔԒn
							// pItem->size:
							// data[pItem->index]
							pWidget->ScopeUpdate(cycle, size/*index*/, pItem->size, &data[pItem->index]);
							index++;
							addr += pItem->size;
						}
					}
				}
			}
		}
	}
}

//SubsystemScopeɃf[^]
void CExtncsView::SubScopeUpdate(CWidget* pTargetWidget, int cycle, float data[])
{
	CExtncsDoc *pDoc = GetDocument();
	int i,nWidget,addr,index,size,nSize,id;
	CWidget* pWidget;
	//CScopeFrame* pScopeFrame;
	CPtrArray* p;
	SCOPEINFO* pItem;
	CWnd* pWnd;
	float* fdata;		// Xypf[^
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	nWidget = (int)pArrWidgets->GetSize();
	for(i = 0; i < nWidget; i++) {
		pWidget = (CWidget*)pArrWidgets->GetAt(i);
		id = pWidget->GetId();
		if(id == M_SUBSYSTEM)
			SubScopeUpdate(pWidget, cycle, data);
		else {
			pWnd = pWidget->GetScope();
			if(pWnd) {
				if(id == M_XY) {
					//Xy̏ꍇ́Azɂē]
					p = pWidget->GetScopePointer();
					nSize = (int)p->GetSize();	//j^[\ϐ̐
					fdata = (float*)malloc(nSize*sizeof(float));
					index = 0;
					for(size = 0; size < nSize; size++) {
						pItem = (SCOPEINFO*) p->GetAt(size);
						if(pItem->visible) {
							// cycle:Эڰ݉
							// size:pWidgetłm_scopeArrayԍ
							// addr:ޔԒn
							// pItem->size:
							// data[pItem->index]
							fdata[index++] = data[pItem->index];
						}
					}
					pWidget->XyUpdate(cycle, 0/*1XR[v̂*/, index, fdata);
					free(fdata);
				}
				else {
					p = pWidget->GetScopePointer();
					nSize = (int)p->GetSize();	//j^[\ϐ̐
					index = 0;
					addr = 0;
					for(size = 0; size < nSize; size++) {
						pItem = (SCOPEINFO*) p->GetAt(size);
						if(pItem->visible) {
							// cycle:Эڰ݉
							// size:pWidgetłm_scopeArrayԍ
							// addr:ޔԒn
							// pItem->size:
							// data[pItem->index]
							pWidget->ScopeUpdate(cycle, size/*index*/, pItem->size, &data[pItem->index]);
							index++;
							addr += pItem->size;
						}
					}
				}
			}
		}
	}
}

//Scope`惂[h
//mode=2ȂI
void CExtncsView::ScopeMode(int mode)
{
	if(mode==2)
		m_fSimuState = FALSE;
}

//
void CExtncsView::SimuMode(int mode)
{
//TODO:Simulation֌ẂA
	if(m_pSimuWnd)
		((CSimuWnd*)m_pSimuWnd)->SetMode(mode);
}

void CExtncsView::OnWidgetExtend() 
{
	WidgetExtend(m_desIndex);
}

void CExtncsView::WidgetExtend(int desIndex)
{
	CWidget* pWidget;
	int type;
	BLOCKINFO* pItem;
	m_desIndex = desIndex;
	CExtncsDoc* pDoc = GetDocument();
	pWidget = pDoc->GetWidget (desIndex);
	CString matrix = pWidget->GetMatrix();
	CString name = pWidget->GetName();
	int connect = pWidget->GetConnect();
	CWidgetExtend*	pExt;

	pExt = new CWidgetExtend();
	if(pExt) {
		pExt->m_matrix = matrix;
		pExt->m_cell = name;
		pExt->m_connect = connect;
		pExt->m_pDoc = pDoc;
		pExt->m_id = pWidget->GetJunction();	//gZJunction
		//g̗L
		if(pWidget->GetInportLine() || pWidget->GetOutportLine())
			pExt->m_bFormat = FALSE;
		else { // ݂Ȃ
			pItem = pWidget->GetPitem();
			type = pItem->type;
			if(type == MODULE_CELL || type == MODULE_USER
				|| type == MODULE_NCS)
				pExt->m_bFormat = TRUE;
			else
				pExt->m_bFormat = FALSE;
		}
		if(pExt->Create(this) == TRUE) {
			m_pWidgetExtend = pExt;
		}
	}
}

void CExtncsView::OnUpdateWidgetExtend(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CExtncsView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(nChar == VK_CONTROL)
		m_bCtrlKey = TRUE;
	else
		m_bCtrlKey = FALSE;
	
	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CExtncsView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	m_bCtrlKey = FALSE;
	
	CScrollView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CExtncsView::OnLineProp() 
{
	int index;
	CExtncsDoc* pDoc = GetDocument();
	CLine* pLine;
	pLine = pDoc->GetLine (m_lSel);
	BOOL flag = FALSE;
	CLineProp* pLprop;

	pLprop = new CLineProp();
	if(pLprop) {
		pLprop->m_nLineStyle = pDoc->GetLineStyle(m_lSel);
		index = pLine->GetJunction();		//qCELL
		pLprop->m_id = index;
		pLprop->m_pExtncsDoc = pDoc;
		if(pLprop->Create(this) == TRUE) {
			m_pLineProp = pLprop;
		}
	}
}

void CExtncsView::OnUpdateLineProp(CCmdUI* pCmdUI) 
{
	if(!m_pLineProp)
		pCmdUI->Enable (m_lSel != -1);	
	else
		pCmdUI->Enable(FALSE);
}

// CParamWnd̎w߂NetworkɊ֌WCell̃p[^[ύX
LRESULT CExtncsView::OnParamChange(WPARAM wParam, LPARAM lParam)
{
	CExtncsDoc* pDoc = GetDocument();
	CWidget* pWidget;
	int id,nCount,port,i;
	CPtrArray*	ptr;
	PARAMINFO *pItem;

	pWidget = (CWidget *)lParam;
	id = pWidget->GetId();
	ptr = pWidget->GetParamPointer();
	nCount = (int)ptr->GetSize();
	switch(id) {
	case	M_SUM:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("inport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetInport(port);
				pWidget->ChangeInportName();
			}
		}
		break;
	case	M_PRODUCT:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("inport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetInport(port);
				pWidget->ChangeInportName();
			}
		}
		break;
	case	M_SELECT:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("inport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetInport(port);
				pWidget->ChangeInportName();
			}
		}
		break;
	case	M_XY:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("type")) == NULL) {
				port = atoi(pItem->strValue);
				//port=0 -> x-y
				//port=1 -> x-y-z
				pWidget->SetInport(port+2);
				pWidget->ChangeInportName();
				//Scopeupdate
				pWidget->ChangeXyScope();
			}
		}
		break;
	case	M_SUBSYSTEM:
		for (i=0; i<nCount; i++) {
			//PARAMINFO
			pItem = (PARAMINFO*) ptr->GetAt (i);
			if(pItem->strName.Compare(_T("inport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetInport(port);
				pWidget->ChangeInportName();
			}
			if(pItem->strName.Compare(_T("outport")) == NULL) {
				port = atoi(pItem->strValue);
				pWidget->SetOutport(port);
				pWidget->ChangeOutportName();
			}
		}
		//Update
		pDoc->SubDeleteContents(pWidget);
		pDoc->InitSubsystem(pWidget, pWidget->GetInport(), pWidget->GetOutport());

		break;
	}

	return 0L;
}

void CExtncsView::OnAppExit() 
{
	//SATELLITEIAExitj[
	char cmdline[_MAX_PATH];
	strcpy(cmdline, "exit\n");
	int i,ch,len;
	DWORD size;

	//A command is transmitted. 
	len = (int)strlen(cmdline);
	for(i=0; i<len; i++){
		ch = (unsigned char)cmdline[i];
		WriteFile(g_pExtncsMain->m_hStdinW, &ch, sizeof(int), &size, NULL);
	}
}

void CExtncsView::OnDestroy() 
{
	/* Save */
	int ret;
	CExtncsDoc* pDoc = GetDocument();
	if(pDoc->IsModified()) {
		if(pDoc->m_ExtncsName.Compare(_T("untitled.sig")) != NULL) {
			ret = ::MessageBox(NULL,"Do you save by the same name ?",
				PACKAGE_STRING, MB_ICONQUESTION | MB_YESNOCANCEL);
			if(ret == IDYES) {
				pDoc->FileSave();
			}
			else if(ret == IDNO) {
				pDoc->FileSaveAs();
			}
		}
		else
			pDoc->FileSaveAs();
	}
	/*DestroyWindow*/
	AllDestroyWindow();
	//MainFrameToolbarL
	AfxGetMainWnd()->PostMessage(SHOW_TOOLBAR, 1, 0L);

	CScrollView::OnDestroy();

	/*DestroyWindow*/
	//AllDestroyWindow();
	//MainFrameToolbarL
	//AfxGetMainWnd()->PostMessage(SHOW_TOOLBAR, 1, 0L);

}

void CExtncsView::AllDestroyWindow()
{
	CExtncsDoc* pDoc = GetDocument();

	int nCount,i;
	PARAMWNDINFO* pItem;
	CWidget* pWidget;
	CWnd* pWnd;
	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (PARAMWNDINFO*) m_paramArray.GetAt (i);
			//if (pItem->pWnd)
			//	pItem->pWnd->DestroyWindow();
			delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
		}
		m_paramArray.RemoveAll();
	}

	//for(win = 0; win < MAX_SUBSYSTEM; win++) {
	//	if(m_pSubsysWnd[win]) {
	//		if(pDoc->m_bSubsysWnd[win])
	//			m_pSubsysWnd[win]->DestroyWindow();
	//		m_pSubsysWnd[win] = NULL;
	//		m_pSubsysDoc[win] = NULL;
	//	}
	//}
	m_nSubsysMax = 0;

	//SĂWidgetAJĂScopeSubsystem폜
	i = pDoc->GetWidgetCount ();
	while (i) {
		pWidget =  pDoc->GetWidget(--i);
		//Subsystem폜
		if(pWidget->GetId() == M_SUBSYSTEM)
			SubDestroySubsystemAndScope(pWidget);
		//Scope
		if(pWnd = pWidget->GetScope())
			pWnd->DestroyWindow();
	}
	//if(m_pSimuWnd)
	//	m_pSimuWnd->DestroyWindow();

	if(m_pWidgetExtend) {
		m_pWidgetExtend->DestroyWindow();
		delete m_pWidgetExtend;
		m_pWidgetExtend = NULL;
	}

	if(m_pLineProp) {
		m_pLineProp->DestroyWindow();
		delete m_pLineProp;
		m_pLineProp = NULL;
	}

	nCount = (int)m_moveArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++)
			delete (MOVELINE*) m_moveArray.GetAt (i);
		m_moveArray.RemoveAll();
	}

}

void CExtncsView::SubDestroySubsystemAndScope(CWidget* pTargetWidget)
{
	int i;
	CWidget* pWidget;
	CWnd* pWnd;
	CPtrArray* pArrWidgets = pTargetWidget->GetWidgetsPointer();

	i = (int)pArrWidgets->GetSize();
	while (i) {
		pWidget =  (CWidget*)pArrWidgets->GetAt(--i);
		//SubsystemSubsystem
		if(pWidget->GetId() == M_SUBSYSTEM)
			SubDestroySubsystemAndScope(pWidget);
		//Scope
		if(pWnd = pWidget->GetScope())
			pWnd->DestroyWindow();
	}
	//SubsystemJĂ
	if(pWnd = pTargetWidget->GetWindow())
		pWnd->DestroyWindow();
}

void CExtncsView::OnAreaDelete() 
{
	//̈WidgetSď
	CExtncsDoc* pDoc = GetDocument();
	int i,nCount;
	CRect area,rect;
	CWidget* pWidget;
	CPoint spt,ept;

	area = CRect(m_ptFrom, m_ptTo);
	nCount = pDoc->GetWidgetCount ();
	for (i=nCount - 1; i>=0 ; i--) {
		pWidget = pDoc->GetWidget (i);
		rect = pWidget->GetRect();
		rect = pWidget->GetRect();
		spt = CPoint(rect.left, rect.top);
		ept = CPoint(rect.right, rect.bottom);
		if((area.PtInRect(spt)) > 0 && (area.PtInRect(spt) > 0)) {
			pDoc->RemoveWidget (i);
		}
	}
	
}

void CExtncsView::OnUpdateAreaDelete(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CExtncsView::OnAreaSubsystem() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	
}

void CExtncsView::OnUpdateAreaSubsystem(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

void CExtncsView::OnAreaModule() 
{
//TODO:Moduleݒ͌
#if 0
#if 1
	CModuleSheet *pSheet;
	CString title;

	title = _T("'Module' properties");
	pSheet = new CModuleSheet(title, this, 0);
	pSheet->m_moduleParam.m_pView = this;
	pSheet->m_moduleMoni.m_pView = this;
	if (pSheet->DoModal() == IDOK) {
		//ݒ肳ꂽ
	}
	delete pSheet;

#else
	CExtncsDoc* pDoc = GetDocument();
	CString moduleName,bmpName;
	int	moduleType;

	CModuleCreate dlgModule(this);
	if(dlgModule.DoModal() == IDOK) {
		//CModuleCreatȅ
		moduleName = dlgModule.m_moduleName;
		bmpName = dlgModule.m_bmpName;
		moduleType = dlgModule.m_moduleType;
		//PubNɂ
		CreateModule(moduleName, bmpName, moduleType);
		//XV
		pDoc->UpdateAllViews(NULL);
	}
	m_bAreaMode = FALSE;
#endif
#endif	
}

void CExtncsView::OnUpdateAreaModule(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	
}

// Module
void CExtncsView::CreateModule(CString moduleName, CString bmpName, int moduleType)
{
//TODOD:Module͌
#if 0
	CExtncsDoc* pDoc = GetDocument();
	CRect rect;
	CLine* pLine;
	int i,lCount,inport,outport,nCount,sblk,eblk,nIndex,cx,cy,port;
	int	in_line[MAX_INTERSECT],out_line[MAX_INTERSECT];//̒ĺAK؂ɏ
	CPoint spt,ept;
	CWidget* pWidget;

	//m_ptFromm_ptToň͂܂ꂽ̈؂郉C
	rect = CRect(m_ptFrom, m_ptTo);
	lCount = pDoc->GetLineCount();
	inport = 0; outport = 0;
	for (i = lCount - 1; i>=0 ; i--) {
		pLine = pDoc->GetLine (i);
		spt = pLine->GetSpos();
		ept = pLine->GetEpos();
		if(IntersectLine(rect, spt, ept) != 0) {
			//o̓|[gvZ
			eblk = pLine->GetEblk();
			pWidget = pDoc->GetWidget (eblk);
			if(pWidget->GetSel()) {
				in_line[inport] = i;
				inport++;
			}
			else {
				out_line[outport] = i;
				outport++;
			}
		}
	}

char buf[256];
sprintf(buf,"in:%d,out%d",inport,outport);
//AfxMessageBox(buf,MB_OK,NULL);

	//m_ptFromm_ptTo̒SM_MODLEWidgetVɍ
	spt.x = m_ptFrom.x + (m_ptTo.x-m_ptFrom.x)/2;
	spt.y = m_ptFrom.y + (m_ptTo.y-m_ptFrom.y)/2;
	if(inport > outport)
		cy = 16+16*inport;
	else
		cy = 16+16*outport;
	cx = 32;

	nIndex = pDoc->AddWidget(M_MODULE, spt, NULL, DIR_RIGHT, CString(_T("1:1")), cx, cy);
	//W[Ƀ|[gAOAbitmapݒ
	pWidget = pDoc->GetWidget(nIndex);
	pWidget->SetInport(inport);
	pWidget->SetOutport(outport);
	pWidget->SetName(moduleName);
	pWidget->SetBitmap(bmpName);
	pWidget->SetType(moduleType);

	//
	//	VC𒣂
	//
	//in_lineɉC
	for(i = 0; i < inport; i++) {
		//Srcʒu
		pLine = pDoc->GetLine( in_line[i] );
		port = pLine->GetOutport();
		sblk = pLine->GetSblk();
		pWidget = pDoc->GetWidget( sblk );
		spt = pWidget->GetOutportPos( port );
		//Desʒu
		pWidget = pDoc->GetWidget( nIndex );
		ept = pWidget->GetInportPos( i+1 );
		//Rect쐬
		rect = CRect(spt, ept);
		//Line
		pDoc->InsertLine (rect, sblk, nIndex, i+1, port, -1);
	}
	//in_lineɉC
	for(i = 0; i < outport; i++) {
		//Srcʒu
		pWidget = pDoc->GetWidget( nIndex );
		spt = pWidget->GetOutportPos( i+1 );
		//Srcʒu
		pLine = pDoc->GetLine( out_line[i] );
		port = pLine->GetInport();
		eblk = pLine->GetEblk();
		pWidget = pDoc->GetWidget( eblk );
		ept = pWidget->GetInportPos( port );
		//Rect쐬
		rect = CRect(spt, ept);
		//Line
		pDoc->InsertLine (rect, nIndex, eblk, port, i+1, -1);
	}

	//WidgetSď
	nCount = pDoc->GetWidgetCount ();
	for (i=nCount - 1; i>=0 ; i--) {
		pWidget = pDoc->GetWidget (i);
		if(pWidget->GetSel()) {
			pDoc->RemoveWidget (i);
			if(i < nIndex)
				nIndex--;
		}
	}

	//W[AnIndexZNgԂ
	pWidget = pDoc->GetWidget( nIndex );
	m_nSel = nIndex;
	pWidget->SetSel(TRUE);
#endif			
}

BOOL CExtncsView::IntersectLine(CRect rect, CPoint from, CPoint to)
{
	if(from.x == to.x) {	//c
		if(rect.left < from.x && rect.right > from.x) {
			//㉺؂邩
			if(from.y < to.y) {
				if(rect.top > from.y && rect.top < to.y)
					return TRUE;
				if(rect.bottom > from.y && rect.bottom < to.y)
					return TRUE;
			}
			else {
				if(rect.top > to.y && rect.top < from.y)
					return TRUE;
				if(rect.bottom > to.y && rect.bottom < from.y)
					return TRUE;
			}
		}
	}
	else {	//
		if(rect.top < from.y && rect.bottom > from.y) {
			//E؂邩
			if(from.x < to.x) {
				if(rect.left > from.x && rect.left < to.x)
					return TRUE;
				if(rect.right > from.x && rect.right < to.x)
					return TRUE;
			}
			else {
				if(rect.left > to.x && rect.left < from.x)
					return TRUE;
				if(rect.right > to.x && rect.right < from.x)
					return TRUE;
			}
		}
	}
	return FALSE;
}

void CExtncsView::OnWidgetLib() 
{
//TODO:Library͌
#if 0
	CExtncsDoc* pDoc = GetDocument();
	CWidget* pWidget;
    BLOCKINFO* pItem;
	BLOCKINFO* binfo;
	CString bmpName;
	int nCount,id,type;
	char buf[_MAX_PATH];

	if(m_nSel != -1) {
		pWidget = pDoc->GetWidget( m_nSel );
		if((id = pWidget->GetId()) == M_MODULE) {
			//o^^Cvݒ
			type = pWidget->GetType();
		}
		else {
			binfo = (BLOCKINFO*)g_pTty->m_blockArray.GetAt(id);
			type = binfo->type;
		}
	}

	if(m_nSel != -1) {
		pWidget = pDoc->GetWidget( m_nSel );
		sprintf(buf,"Lib : %s",pWidget->GetName());
		this->MessageBox(buf,"Extncs",MB_OK);

		//g_pTtyWnd->m_blockArrayXV
		try {
			pItem = new BLOCKINFO;
		}
		catch (CMemoryException* e) {
			e->Delete ();
			return;
		}
		//Block name
		pItem->name = pWidget->GetName();
		//Block type (Cu)
		pItem->type = type;
		//Bitmap file
		bmpName = pWidget->GetBitmap();
		if(bmpName.IsEmpty() != 0) {
			id = pWidget->GetId();
			binfo = (BLOCKINFO*)g_pTty->m_blockArray.GetAt(id);
			bmpName = binfo->fBitmap;
			pItem->fBitmap = bmpName;
		}
		else
			pItem->fBitmap = bmpName;
		//nCount́A{W[TCY
		nCount = g_pTty->m_blockArray.GetSize();
		//nBitmaṕAidɓ
		//Vid
		pItem->nBitmap = nCount;
		//Model name
		//{Cf𐶐ĂKv
		binfo = (BLOCKINFO*)g_pTty->m_blockArray.GetAt(id);
		pItem->model = binfo->model;
		//Direction
		pItem->direction = DIR_RIGHT;
		//Matrix tH[}bg
		pItem->matrix = CString(_T("1:1"));

		//o^
		g_pTty->m_blockArray.InsertAt( nCount, pItem );
		nCount++;

		//XV
		g_pTty->UpdateModel();
	}
#endif	
}

void CExtncsView::OnUpdateWidgetLib(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable (m_nSel != -1);		
}

int CExtncsView::CheckIntersectWidget(CPoint point)
{
	CExtncsDoc* pDoc = GetDocument();
	int	i,nCount;
	CRect rect;
	CPoint spos,epos;
	CLine* pLine;

	rect = CRect(point, CSize(32,32));
	nCount = pDoc->GetLineCount();
	for(i = 0; i < nCount; i++) {
		pLine = pDoc->GetLine(i);
		spos = pLine->GetSpos();
		epos = pLine->GetEpos();
		if(IntersectLine(rect, spos, epos)) {
			//LineCfNXԂ
			return pLine->GetIndex();
		}
	}
	return -1;
}

// delete CWidgetExtend
LRESULT CExtncsView::OnDeleteExtend(WPARAM wParam, LPARAM lParam)
{
	CWidget* pWidget;
	CExtncsDoc* pDoc = GetDocument();
	pWidget = pDoc->GetWidget (m_desIndex);
	CString matrix = pWidget->GetMatrix();
	CString name = pWidget->GetName();
	int connect = pWidget->GetConnect();
	CWidgetExtend* pWidgetExtend = (CWidgetExtend *)m_pWidgetExtend;
	BOOL flag = FALSE;

	if(wParam == 1) {
		//OnOK
		if(matrix.Compare(pWidgetExtend->m_matrix)) {
			//matrixύXꂽ
			pWidget->SetMatrix(pWidgetExtend->m_matrix);
			flag = TRUE;
		}
		if(name.Compare(pWidgetExtend->m_cell)) {
			//nameύXꂽ
			pWidget->SetName(pWidgetExtend->m_cell);
			flag = TRUE;
		}
		if(connect != pWidgetExtend->m_connect) {
			//connectionύXꂽ
			pWidget->SetConnect(pWidgetExtend->m_connect);
			flag = TRUE;
		}
		// Junction
		pWidget->SetJunction(pWidgetExtend->m_id);
		if(flag)
			pDoc->UpdateAllViews (NULL, 0x6A);
	}
	else {
		//OnCancel
	}
	m_pWidgetExtend->DestroyWindow();
	delete m_pWidgetExtend;
	m_pWidgetExtend = NULL;

	return 0L;
}

// delete CLineProp
LRESULT CExtncsView::OnDeleteLineprop(WPARAM wParam, LPARAM lParam)
{
	int style;
	CExtncsDoc* pDoc = GetDocument();
	CLine* pLine;
	pLine = pDoc->GetLine (m_lSel);
	BOOL flag = FALSE;
	CLineProp* pLineProp = (CLineProp *)m_pLineProp;

	if(wParam == 1) {
		//OnOK
		//ConnectionύX
		style = pLineProp->m_nLineStyle;
		//junction
		if(pLineProp->m_id != -1) {
			//VAqݒ肳ꂽ
		}
		//m_lSelőIĂ郉C̑ύX
		pDoc->ChangeLine(m_lSel, style);
	}
	else {
		// OnCancel
		//2-1ȂI
		pDoc->ChangeLine(m_lSel, -1);
	}

	// delete dialog
	m_pLineProp->DestroyWindow();
	delete m_pLineProp;
	m_pLineProp = NULL;
	m_lSel = -1;
	return 0L;
}

void CExtncsView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView) 
{
#if 0
	//MainFrameToolbar\E\\
	if(bActivate) {
		AfxGetMainWnd()->PostMessage(SHOW_TOOLBAR, 0, 0L);
	}
	else {
		AfxGetMainWnd()->PostMessage(SHOW_TOOLBAR, 1, 0L);
	}
#endif
	
	CScrollView::OnActivateView(bActivate, pActivateView, pDeactiveView);
}

// delete param
LRESULT CExtncsView::OnDeleteParam(WPARAM wParam, LPARAM lParam)
{
	int nCount,i;
	PARAMWNDINFO *pItem;

	nCount = (int)m_paramArray.GetSize();
	if(nCount > 0) {
		for (i=0; i<nCount; i++) {
			pItem = (PARAMWNDINFO*) m_paramArray.GetAt (i);
			if (pItem->pWidget == (CWidget *)lParam) {
				pItem->pWnd = NULL;
			}
			delete (PARAMWNDINFO*) m_paramArray.GetAt (i);
		}
		m_paramArray.RemoveAll();
	}
	return 0L;
}

// delete simu
LRESULT CExtncsView::OnDeleteSimu(WPARAM wParam, LPARAM lParam)
{
	m_pSimuWnd = NULL;
	return 0L;
}

// delete Scope
LRESULT CExtncsView::OnDeleteScopeFrame(WPARAM wParam, LPARAM lParam)
{
	CWidget* pWidget;
	pWidget = (CWidget *)lParam;
	pWidget->SetScope(NULL);
	return 0L;
}

// delete Subsystem
LRESULT CExtncsView::OnDeleteSubsystem(WPARAM wParam, LPARAM lParam)
{
	CExtncsDoc* pDoc = GetDocument();

	pDoc->m_bSubsysWnd[wParam] = FALSE;
	m_pSubsysWnd[wParam] = NULL;
	m_pSubsysDoc[wParam] = NULL;
	m_nSubsysMax -= 1;
	return 0L;
}

//ExtncsTreeZNgꂽ
void CExtncsView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	CString strName;
	CExtncsDoc* pDoc = GetDocument();

	if(lHint == 0x5B) {
		//ExtncsTreeIꂽɑ邪Aʂ
		//݂邱Ƃ͂Ȃ
	}
	Invalidate();	
}


bool CExtncsView::GetWidgetPath(CWidget* pWidget, char* pathbuf)
{
	CExtncsDoc* pDoc = GetDocument();
	pDoc->GetWidgetPath(pWidget, pathbuf);
	if(strlen(pathbuf) > 0)
		return true;
	else
		return false;
}
