/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ExtncsView.h,v 1.6 2004/09/14 07:22:21 yoshihiko Exp $ */

#if !defined(AFX_SIGMAVIEW_H__E51D6C0F_DF71_4415_B635_D08790B5233E__INCLUDED_)
#define AFX_SIGMAVIEW_H__E51D6C0F_DF71_4415_B635_D08790B5233E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// CExtncsView r[

class CExtncsView : public CScrollView
{
protected:
	CExtncsView();           // IɎgpveNg RXgN^B
	DECLARE_DYNCREATE(CExtncsView)

// Agr[g
public:

// Iy[V
public:
	//method
	void SubDestroySubsystemAndScope(CWidget* pTargetWidget);
	void CheckConnect(CDC* pDC, CPoint pos);
	void AllDestroyWindow();
	void WidgetExtend(int desIndex);
	void CreateScriptSubParam(FILE *fp, CWidget* pTgtWidget);
	int	CreateScriptSubScope(FILE *fp, CWidget* pTargetWidget, int nTargetIndex);
	BOOL CheckScopeOpen(CWidget* pWidget);
	BOOL IntersectLine(CRect rect, CPoint from, CPoint to);
	void CreateModule(CString moduleName, CString bmpName, int moduleType);
	void ScopeUpdate(int index, float data[]);
	void SubScopeUpdate(CWidget* pTargetWidget, int cycle, float data[]);
	void ScopeSet();
	void SubScopeSet(CWidget* pTargetWidget);
	void ScopeMode(int mode);
	void SimuMode(int mode);
	void ScriptPrint(CString path);
	BOOL SimuInit();
	BOOL SimuExe();
	BOOL ExtncsStart();
	void CreateScript(FILE *fp);
	void Print(char* str);
	int CheckIntersectWidget(CPoint point);
	void OpenParam(CWidget* pWidget, CPoint point);
	void OpenSubsystem(CWidget* pWidget, CPoint point);
	void InvertLine(CDC *pDC, POINT from, POINT to);
	void InvertRect(CDC *pDC, POINT from, POINT to);
	BOOL AreaInWidgets(POINT from, POINT to);
	void JuncWidgetDelete();
	void SaveWidgetLine(int widget);
	void CopySubsystem(CWidget* pWidget, CPtrArray* p);
	void CopyParam(CWidget* pWidget, CPtrArray* p);
	void CopyScope(CWidget* pWidget, CWnd* pWnd, CPtrArray* p);
	void LoadWidgetLine(int widget, int index);
	CExtncsDoc* GetDocument();
	void InvalObj(CDC* pDC, CWidget* pWidget);
	//data
	CPoint		m_connectPoint[3];
	CDialog*	m_pLineProp;
	CDialog*	m_pWidgetExtend;
	BOOL			m_fSimuState;	//Simulation
									//1:Simulation
	CWnd*	m_pSimuWnd;		//SimulationEBhE
	CImageList*	m_pDragImage;
	CPtrArray	m_paramArray;	//p[^[EBhEǗ
	CWnd		*m_pScopeFrame[MAX_SCOPE];
	int			m_nScopeMax;
	int			m_nScopeIndex;
	int			m_nMoniMax;
//TODO:Ή
	//CSubsysDoc	*m_pSubsysDoc[MAX_SUBSYSTEM];
	//CSubsysWnd	*m_pSubsysWnd[MAX_SUBSYSTEM];
	CDocument	*m_pSubsysDoc[MAX_SUBSYSTEM];
	CWnd	*m_pSubsysWnd[MAX_SUBSYSTEM];
	int			m_nSubsysMax;


// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CExtncsView)
	public:
	virtual DROPEFFECT OnDragEnter(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual DROPEFFECT OnDragOver(COleDataObject* pDataObject, DWORD dwKeyState, CPoint point);
	virtual void OnDragLeave();
	virtual BOOL OnDrop(COleDataObject* pDataObject, DROPEFFECT dropEffect, CPoint point);
	protected:
	virtual void OnDraw(CDC* pDC);      // ̃r[`悷邽߂ɃI[o[Ch܂B
	virtual void OnInitialUpdate();     // \zAŏ̏B
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);
	virtual void OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint);
	//}}AFX_VIRTUAL

// Cve[V
protected:
	CPoint	m_popupPos;		//}EXENbNʒu
	int	m_srcIndex,m_desIndex;
	BOOL	m_bAreaMode;
	BOOL	m_bCtrlKey;		//CtrlL[
	BOOL	m_bSizeMode;	//Resize
	int		m_nSizePoint;	//Resizë
	CPtrArray m_mouseArray;	//MOUSE_MOVËʒu
	CPoint	m_ptFrom, m_ptTo;
	BOOL	m_bLineMode;
	int		m_inIndex, m_outIndex;		//|[gԍ
	int	m_nWidgetRLine, m_nWidgetLLine;
	BOOL m_bHitRLine, m_bHitLLine;
	CPtrArray m_moveArray;
	CPoint m_pointLastMsg;
	CPoint m_pointLastImage;
	CSize m_offset;
	HCURSOR m_hCross;
	HCURSOR m_hArrow;
	HCURSOR m_hRSize;
	HCURSOR m_hLSize;
	COleDropTarget m_oleDropTarget;
	int m_lSel;		//CI̎wW
	int m_nSel;
	CLine* m_pTempLine;
	CWidget* m_pTempWidget;
	virtual ~CExtncsView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CExtncsView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnEditCut();
	afx_msg void OnUpdateEditCut(CCmdUI* pCmdUI);
	afx_msg void OnEditCopy();
	afx_msg void OnUpdateEditCopy(CCmdUI* pCmdUI);
	afx_msg void OnEditPaste();
	afx_msg void OnUpdateEditPaste(CCmdUI* pCmdUI);
	afx_msg void OnEditDelete();
	afx_msg void OnUpdateEditDelete(CCmdUI* pCmdUI);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnWidgetLine();
	afx_msg void OnUpdateWidgetLine(CCmdUI* pCmdUI);
	afx_msg void OnExtncsStart();
	afx_msg void OnUpdateExtncsStart(CCmdUI* pCmdUI);
	afx_msg void OnExtncsStop();
	afx_msg void OnUpdateExtncsStop(CCmdUI* pCmdUI);
	afx_msg void OnExtncsCondition();
	afx_msg void OnUpdateExtncsCondition(CCmdUI* pCmdUI);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnWidgetParam();
	afx_msg void OnUpdateWidgetParam(CCmdUI* pCmdUI);
	afx_msg void OnWidgetScope();
	afx_msg void OnUpdateWidgetScope(CCmdUI* pCmdUI);
	afx_msg void OnWidget0();
	afx_msg void OnUpdateWidget0(CCmdUI* pCmdUI);
	afx_msg void OnWidget90();
	afx_msg void OnUpdateWidget90(CCmdUI* pCmdUI);
	afx_msg void OnWidget180();
	afx_msg void OnUpdateWidget180(CCmdUI* pCmdUI);
	afx_msg void OnWidget270();
	afx_msg void OnUpdateWidget270(CCmdUI* pCmdUI);
	afx_msg void OnWidgetExtend();
	afx_msg void OnUpdateWidgetExtend(CCmdUI* pCmdUI);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnLineProp();
	afx_msg void OnUpdateLineProp(CCmdUI* pCmdUI);
	afx_msg void OnAppExit();
	afx_msg void OnDestroy();
	afx_msg void OnAreaDelete();
	afx_msg void OnUpdateAreaDelete(CCmdUI* pCmdUI);
	afx_msg void OnAreaSubsystem();
	afx_msg void OnUpdateAreaSubsystem(CCmdUI* pCmdUI);
	afx_msg void OnAreaModule();
	afx_msg void OnUpdateAreaModule(CCmdUI* pCmdUI);
	afx_msg void OnWidgetLib();
	afx_msg void OnUpdateWidgetLib(CCmdUI* pCmdUI);
	//}}AFX_MSG
	afx_msg LRESULT OnParamChange(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteExtend(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteLineprop(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteParam(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteSimu(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteScopeFrame(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnDeleteSubsystem(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT ExtncsStart(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT ExtncsCondition(WPARAM wParam, LPARAM lParam);
	DECLARE_MESSAGE_MAP()
public:
	bool GetWidgetPath(CWidget* pWidget, char* pathbuf);
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_SIGMAVIEW_H__E51D6C0F_DF71_4415_B635_D08790B5233E__INCLUDED_)
