/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: ExtncsWnd.cpp,v 1.3 2004/07/11 03:37:46 yoshihiko Exp $ */

#include "stdafx.h"
#include "Extncs.h"

#include "WidgetObj.h"
#include "ScopeWnd.h"
#include "SubsysDoc.h"
#include "SubsysWnd.h"
#include "SubsysView.h"
#include "ExtncsDoc.h"
#include "ExtncsView.h"
#include "ExtncsBar.h"
#include "ExtncsWnd.h"
#include "ExtncsTree.h"
#include ".\extncswnd.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CExtncsWnd

IMPLEMENT_DYNCREATE(CExtncsWnd, CFrameWnd)

CExtncsWnd::CExtncsWnd()
{
}

CExtncsWnd::~CExtncsWnd()
{
}


BEGIN_MESSAGE_MAP(CExtncsWnd, CFrameWnd)
	//{{AFX_MSG_MAP(CExtncsWnd)
	ON_WM_CREATE()
	ON_WM_GETMINMAXINFO()
	//}}AFX_MSG_MAP
	ON_WM_HELPINFO()
	// O[o wv R}h
	ON_COMMAND(ID_HELP_FINDER, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
	ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
	ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
	ON_COMMAND(ID_HELP, OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CExtncsWnd bZ[W nh

BOOL CExtncsWnd::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style &= ~FWS_ADDTOTITLE;
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	return TRUE;
}

int CExtncsWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	if (!m_wndExtncsBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_SIZE_FIXED |
		CBRS_TOP | CBRS_TOOLTIPS, AFX_IDW_TOOLBAR ) ||
		!m_wndExtncsBar.LoadToolBar(IDR_TOOLBAR_EXTNCS))
	{
		TRACE0("Failed to create toolbar\n");
		return FALSE;       // 쐬Ɏs
	}

	// ACR\[X[h
	HICON hIcon = AfxGetApp()->LoadIcon(IDI_EXTNCS);
	ASSERT(hIcon);
	// EBhEɐVACRw肷
	this->SendMessage(WM_SETICON, TRUE, (LPARAM)hIcon);

	//^Cg
	char title[_MAX_PATH];
	strcpy(title, "Extncs : untitled.sig");
	this->SendMessage(WM_SETTEXT,0,(LPARAM)title);

	/*A private format name is registered. */
	m_nFormat = ::RegisterClipboardFormat (_T ("Widget"));
	/*It sets up so that Extncs may come next to ModelView. */
	CRect rcWindow;
	rcWindow = CRect(144, 32, 144+640+192, 32+480);
	MoveWindow(rcWindow, TRUE);

	return 0;
}

// Kvȏ́AConsoleViewɏo͂
BOOL CExtncsWnd::OnCreateClient(LPCREATESTRUCT lpcs, CCreateContext* pContext) 
{
	//
	// Note: Create the CFileView first so the CDriveView's OnInitialUpdate
	// function can call OnUpdate on the CFileView.
	//
    if (!m_wndSplitter.CreateStatic (this, 1, 2) ||
        !m_wndSplitter.CreateView (0, 1, RUNTIME_CLASS
            (CExtncsView), CSize (0, 0), pContext) ||
        !m_wndSplitter.CreateView (0, 0, RUNTIME_CLASS (CExtncsTree),
            CSize (192, 0), pContext))
        return FALSE;

    return TRUE;
	
	//return CFrameWnd::OnCreateClient(lpcs, pContext);
}


void CExtncsWnd::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI) 
{
	lpMMI->ptMaxTrackSize.x = 1024;
	lpMMI->ptMaxTrackSize.y = 768;

	CFrameWnd::OnGetMinMaxInfo(lpMMI);
}


BOOL CExtncsWnd::OnHelpInfo(HELPINFO* pHelpInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	//return CFrameWnd::OnHelpInfo(pHelpInfo);
	return TRUE;
}

void CExtncsWnd::OnHelp()
{
	// TODO : ɃR}h nh R[hǉ܂B
	AfxGetApp()->WinHelp(0x20000+IDR_EXTNCS, HELP_CONTEXT);
}
