/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: LineProp.h,v 1.2 2004/05/19 04:11:21 yoshihiko Exp $ */

#if !defined(AFX_LINEPROP_H__0F4D7749_0BFC_4467_99E8_C767773975FF__INCLUDED_)
#define AFX_LINEPROP_H__0F4D7749_0BFC_4467_99E8_C767773975FF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "WidgetObj.h"
typedef CTypedPtrArray<CObArray, CWidget*> CWidgetArray;

/////////////////////////////////////////////////////////////////////////////
// CLineStyle EBhE

class CLineStyle : public CListBox
{
// RXgNV
public:
	CLineStyle();

// Agr[g
public:

// Iy[V
public:

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CLineStyle)
	public:
	virtual void MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	virtual int CompareItem(LPCOMPAREITEMSTRUCT lpCompareItemStruct);
	//}}AFX_VIRTUAL

// Cve[V
public:
	void AddLineItem(int index);
	void Draw(CDC* pDC, RECT rc, int index);
	virtual ~CLineStyle();

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(CLineStyle)
		//  - ClassWizard ͂̈ʒuɃo֐ǉ܂͍폜܂B
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
// CLineProp _CAO

class CLineProp : public CDialog
{
protected:
	CLineStyle m_style;
// RXgNV
public:
	//CLineProp(CWnd* pParent = NULL);   // W̃RXgN^
	CLineProp();
	~CLineProp();
	BOOL	Create(CView* pView);						// _CAO{bNX̍쐬

// _CAO f[^
	//{{AFX_DATA(CLineProp)
	enum { IDD = IDD_LINE_PROP };
	CButton	m_obs;
	CEdit	m_name;
	CStatic	m_junc;
	//}}AFX_DATA
// f[^
	int			m_nLineStyle;
	int			m_id;				//JunctionID
//TODO:̒`
	//CExtncsDoc*	m_pDoc;
	CDocument*	m_pExtncsDoc;
	CImageList*	m_pDragImage;
	CPtrArray	m_paramArray;	//p[^[EBhEǗ
	CView* m_pView;

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CLineProp)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL

// Cve[V
protected:
	CWidgetArray m_arrWidgets;
public:
	int AddWidget(CPoint point, int id, int cx, int cy);
	void OpenParam(CWidget* pWidget, CPoint point);

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CLineProp)
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	virtual void OnCancel();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_LINEPROP_H__0F4D7749_0BFC_4467_99E8_C767773975FF__INCLUDED_)
